/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Export;

import ReportViewerLibrary.Export.ExportConfiguration;
import ReportViewerLibrary.Export.HeaderRenderer;
import ReportViewerLibrary.Export.HtmlWorkerFixer;
import ReportViewerLibrary.Export.ReportImageProvider;
import ReportViewerLibrary.Util.OrderDateComparator;
import ReportViewerXml.Order;
import ReportViewerXml.OrderHeader;
import ReportViewerXml.Patient;
import RuntimeTool.DebugManager;
import StringUtilities.StringCheck;
import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Graphic;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.html.simpleparser.HTMLWorker;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class ReportExporter {
    private static final float ITEXT_IMAGE_DPI_RENDERING = 72.0f;
    public static final SimpleDateFormat PRINTED_ON_DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    private static final Font REPORT_SECTION_TITLE_FONT = FontFactory.getFont((String)"unknown", (float)14.0f, (int)5);
    private static Font DEFAULT_FONT = FontFactory.getFont((String)"unknown");
    private static final int FOOTER_FONT_SIZE = 10;
    private Patient mPatient;
    private Map mOrders;
    private Map mOrderHeaders;
    private ReportImageProvider mReportImageProvider;
    private Date mExportDate;
    private com.lowagie.text.Image mLogo = null;
    private BaseFont mFooterFont = null;
    private String mCurrentExamId;
    private boolean mIheMode;
    private boolean mPrintAll = true;
    private boolean mIncludeKeyImages = true;
    private boolean mIncludeImpressions = true;
    private boolean mIncludeHistory = true;
    private final ExportConfiguration mExportConfiguration;

    public ReportExporter(Patient patient, Map map, Map map2, ReportImageProvider reportImageProvider, String string, boolean bl2, ExportConfiguration exportConfiguration) {
        this.mPatient = patient;
        this.mOrders = map;
        this.mOrderHeaders = map2;
        this.mCurrentExamId = string;
        this.mReportImageProvider = reportImageProvider;
        this.mIheMode = bl2;
        this.mExportConfiguration = exportConfiguration;
        this.initHeaderLogo();
        this.initFooterFont();
    }

    private void initHeaderLogo() {
        try {
            this.mLogo = com.lowagie.text.Image.getInstance((URL)this.mReportImageProvider.getPrintableLogoUrl());
            if (this.mLogo != null) {
                this.scaleLogoAccordingToDPI();
            }
        }
        catch (Exception exception) {
            String string = "Could not retrive printable logo from URL: [" + this.mReportImageProvider.getPrintableLogoUrl() + "]. No logo will be included on exported reports.";
            DebugManager.getDefault().printError(string);
        }
    }

    private void scaleLogoAccordingToDPI() {
        DebugManager.getDefault().printTrace("Logo resolution = " + this.mLogo.width() + " x " + this.mLogo.height());
        DebugManager.getDefault().printTrace("Logo DPI = " + this.mLogo.getDpiX() + " x " + this.mLogo.getDpiY());
        if ((float)this.mLogo.getDpiX() > 72.0f && (float)this.mLogo.getDpiY() > 72.0f) {
            float f2 = 72.0f / (float)this.mLogo.getDpiX() * 100.0f;
            float f3 = 72.0f / (float)this.mLogo.getDpiY() * 100.0f;
            DebugManager.getDefault().printTrace("Scaling logo by (" + f2 + "%, " + f3 + "%) to fit DPI");
            if (f2 > 0.0f && f3 > 0.0f) {
                this.mLogo.scalePercent(f2, f3);
            }
        }
    }

    private void initFooterFont() {
        try {
            this.mFooterFont = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        }
        catch (Exception exception) {
            String string = "Could not initialize footer font. Reports will be exported with no footer!";
            DebugManager.getDefault().printException(string, exception);
        }
    }

    private float inchesToPoints(float f2) {
        return 72.0f * f2;
    }

    public void setPrintAll(boolean bl2) {
        this.mPrintAll = bl2;
    }

    public void setIncludeKeyImages(boolean bl2) {
        this.mIncludeKeyImages = bl2;
    }

    public void setIncludeImpressions(boolean bl2) {
        this.mIncludeImpressions = bl2;
    }

    public void setIncludeHistory(boolean bl2) {
        this.mIncludeHistory = bl2;
    }

    public void export(File file) throws IOException, DocumentException {
        this.export(file, new Date());
    }

    public void export(File file, Date date) throws IOException, DocumentException {
        DebugManager.getDefault().printTrace("Exporting report to " + file.getAbsolutePath());
        this.mExportDate = date;
        Document document = new Document(PageSize.LETTER, this.inchesToPoints(this.mExportConfiguration.getLeftMargin()), this.inchesToPoints(this.mExportConfiguration.getRightMargin()), this.inchesToPoints(this.mExportConfiguration.getTopMargin()), this.inchesToPoints(this.mExportConfiguration.getBottomMargin()));
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
        ReportPageHandler reportPageHandler = new ReportPageHandler();
        pdfWriter.setPageEvent((PdfPageEvent)reportPageHandler);
        Order order = (Order)this.mOrders.get(this.mCurrentExamId);
        reportPageHandler.setCurrentOrder(order);
        document.open();
        reportPageHandler.checkForException();
        this.addReport(document, order);
        if (this.mPrintAll) {
            ArrayList arrayList = new ArrayList(this.mOrders.values());
            Collections.sort(arrayList, new OrderDateComparator(this.mIheMode, false, this.mOrderHeaders));
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Order order2 = (Order)iterator.next();
                if (order2 == order) continue;
                reportPageHandler.setCurrentOrder(order2);
                document.newPage();
                this.addReport(document, order2);
                reportPageHandler.checkForException();
            }
        }
        document.close();
    }

    private void addReport(Document document, Order order) throws IOException, DocumentException {
        HTMLWorker hTMLWorker = new HTMLWorker((DocListener)document);
        this.addReportSectionTitle(document, "Report", false);
        String string = StringCheck.isStringBlank(order.getReport()) ? HtmlWorkerFixer.fixHtml("There is no report for this order.") : HtmlWorkerFixer.fixHtml(order.getReport());
        hTMLWorker.parse((Reader)new StringReader(string));
        if (this.mIncludeImpressions) {
            this.addReportSectionTitle(document, "Impressions", true);
            string = StringCheck.isStringBlank(order.getImpression()) ? HtmlWorkerFixer.fixHtml("There are no impressions for this order.") : HtmlWorkerFixer.fixHtml(order.getImpression());
            hTMLWorker.parse((Reader)new StringReader(string));
        }
        if (this.mIncludeHistory) {
            this.addReportSectionTitle(document, "Clinical History", true);
            string = StringCheck.isStringBlank(order.getHistory()) ? HtmlWorkerFixer.fixHtml("There is no clinical history for this order.") : HtmlWorkerFixer.fixHtml(order.getHistory());
            hTMLWorker.parse((Reader)new StringReader(string));
        }
        this.addKeyImages(document, order.getAccession());
    }

    private void addReportSectionTitle(Document document, String string, boolean bl2) throws DocumentException {
        if (bl2) {
            document.add((Element)new Paragraph("\n", DEFAULT_FONT));
        }
        document.add((Element)new Paragraph(string, REPORT_SECTION_TITLE_FONT));
    }

    private void addKeyImages(Document document, String string) throws IOException, DocumentException {
        int n2 = this.mReportImageProvider.getKeyImageCount(string);
        if (!this.mIncludeKeyImages || n2 == 0) {
            return;
        }
        document.newPage();
        int n3 = (int)Math.ceil(Math.sqrt(n2));
        int n4 = (int)Math.ceil((double)n2 / (double)n3);
        float f2 = document.top() - 120.0f;
        float f3 = document.getPageSize().width() - 36.0f - (float)(n4 - 1) * 6.0f;
        float f4 = f2 - document.bottom() - (float)(n3 - 1) * 6.0f;
        float f5 = f3 / (float)n4;
        float f6 = f4 / (float)n3;
        int n5 = (int)(f5 / 72.0f * 300.0f);
        int n6 = (int)(f6 / 72.0f * 300.0f);
        Image image = this.mReportImageProvider.getKeyImage(string, 0, n5, n6);
        com.lowagie.text.Image image2 = com.lowagie.text.Image.getInstance((Image)image, null);
        image2.scaleToFit(f5, f6);
        float f7 = (f5 - image2.scaledWidth()) / 2.0f;
        float f8 = 18.0f;
        float f9 = f2;
        for (int i2 = 0; i2 < n2; ++i2) {
            Image image3 = this.mReportImageProvider.getKeyImage(string, i2, n5, n6);
            com.lowagie.text.Image image4 = com.lowagie.text.Image.getInstance((Image)image3, null);
            image4.setAlignment(1);
            image4.scaleToFit(f5, f6);
            image4.setAbsolutePosition(f8 + f7, f9 - image4.scaledHeight());
            document.add((Element)image4);
            f8 += f5 + 6.0f;
            if (!(f8 > f3)) continue;
            f8 = 18.0f;
            f9 -= image4.scaledHeight() + 6.0f;
        }
    }

    private void addHeader(Document document, Order order) throws DocumentException {
        String string = this.mIheMode ? order.getPacsKey() : order.getAccession();
        OrderHeader orderHeader = (OrderHeader)this.mOrderHeaders.get(string);
        HeaderRenderer headerRenderer = new HeaderRenderer(this.mExportConfiguration);
        com.lowagie.text.Image image = this.mExportConfiguration.includeLogo() ? this.mLogo : null;
        document.add((Element)headerRenderer.getLogoAndTitle(image));
        document.add((Element)headerRenderer.getFields(orderHeader, this.mPatient));
        if (this.mExportConfiguration.includeLineSeparator()) {
            document.add(ReportExporter.createParagraph(5.0f));
            document.add(ReportExporter.createHorizontalLine());
        }
        document.add(ReportExporter.createParagraph(8.0f));
    }

    private static Element createParagraph(float f2) {
        Paragraph paragraph = new Paragraph();
        paragraph.setSpacingAfter(f2);
        return paragraph;
    }

    private static Element createHorizontalLine() {
        Graphic graphic = new Graphic();
        graphic.setHorizontalLine(1.0f, 100.0f, Color.black);
        return graphic;
    }

    private void addFooter(PdfWriter pdfWriter, Document document, Date date, PdfTemplate pdfTemplate, int n2) {
        String string = "Report exported on " + PRINTED_ON_DATE_FORMAT.format(date) + " -- Page " + n2 + " of ";
        float f2 = this.mFooterFont.getWidthPoint(string, 10.0f);
        float f3 = (document.getPageSize().width() - f2) / 2.0f;
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        float f4 = this.inchesToPoints(this.mExportConfiguration.getFooterMargin());
        pdfContentByte.beginText();
        pdfContentByte.setFontAndSize(this.mFooterFont, 10.0f);
        pdfContentByte.setTextMatrix(f3, f4);
        pdfContentByte.showText(string);
        pdfContentByte.endText();
        pdfContentByte.addTemplate(pdfTemplate, f3 + f2, f4);
    }

    private class ReportPageHandler
    extends PdfPageEventHelper {
        private Order mCurrentOrder = null;
        private int mCurrentOrderPageNumber = 1;
        private PdfTemplate mReportPageTotalTemplate = null;
        private DocumentException mDocumentException = null;

        private ReportPageHandler() {
        }

        public void setCurrentOrder(Order order) {
            this.completeReportPageTotalTemplate(this.mCurrentOrderPageNumber - 1);
            this.mCurrentOrder = order;
        }

        public void onStartPage(PdfWriter pdfWriter, Document document) {
            try {
                if (this.shouldAddHeader(pdfWriter)) {
                    ReportExporter.this.addHeader(document, this.mCurrentOrder);
                }
                if (this.mReportPageTotalTemplate == null) {
                    this.mReportPageTotalTemplate = pdfWriter.getDirectContent().createTemplate(50.0f, 50.0f);
                }
                ReportExporter.this.addFooter(pdfWriter, document, ReportExporter.this.mExportDate, this.mReportPageTotalTemplate, this.mCurrentOrderPageNumber++);
            }
            catch (DocumentException documentException) {
                this.mDocumentException = documentException;
            }
        }

        private boolean shouldAddHeader(PdfWriter pdfWriter) {
            if (!ReportExporter.this.mExportConfiguration.includeHeader()) {
                return false;
            }
            if (pdfWriter.getPageNumber() == 1) {
                return true;
            }
            return ReportExporter.this.mExportConfiguration.repeatHeader();
        }

        public void onCloseDocument(PdfWriter pdfWriter, Document document) {
            this.completeReportPageTotalTemplate(this.mCurrentOrderPageNumber - 2);
        }

        private void completeReportPageTotalTemplate(int n2) {
            if (this.mReportPageTotalTemplate == null || ReportExporter.this.mFooterFont == null) {
                return;
            }
            this.mReportPageTotalTemplate.beginText();
            this.mReportPageTotalTemplate.setFontAndSize(ReportExporter.this.mFooterFont, 10.0f);
            this.mReportPageTotalTemplate.showText(String.valueOf(n2));
            this.mReportPageTotalTemplate.endText();
            this.mReportPageTotalTemplate = null;
            this.mCurrentOrderPageNumber = 1;
        }

        public void checkForException() throws DocumentException {
            if (this.mDocumentException != null) {
                throw this.mDocumentException;
            }
        }
    }
}

