/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Export;

import ReportViewerLibrary.Export.ExportConfiguration;
import ReportViewerLibrary.Export.HeaderField;
import ReportViewerXml.OrderHeader;
import ReportViewerXml.Patient;
import StringUtilities.StringCheck;
import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HeaderRenderer {
    private static final int TWO_COLUMNS_HEADER_FONT_SIZE = 9;
    private static final Font TWO_COLUMN_HEADER_LABEL_FONT = FontFactory.getFont((String)"unknown", (float)9.0f, (int)1);
    private static final Font TWO_COLUMN_HEADER_VALUE_FONT = FontFactory.getFont((String)"unknown", (float)9.0f, (int)0);
    private static final int ONE_COLUMN_HEADER_FONT_SIZE = 11;
    private static final Font ONE_COLUMN_HEADER_LABEL_FONT = FontFactory.getFont((String)"unknown", (float)11.0f, (int)1);
    private static final Font ONE_COLUMN_HEADER_VALUE_FONT = FontFactory.getFont((String)"unknown", (float)11.0f, (int)0);
    private static final int PROMINENT_HEADER_FONT_SIZE = 14;
    private static final Font PROMINENT_HEADER_VALUE_FONT = FontFactory.getFont((String)"unknown", (float)14.0f, (int)1);
    private static final int TITLE_FONT_SIZE = 16;
    private static final Font TITLE_HEADER_LABEL_FONT = FontFactory.getFont((String)"unknown", (float)16.0f, (int)2);
    private final ExportConfiguration mExportConfiguration;
    private final Map mHeaderFields = HeaderField.getAllHeaderFields();
    private int mRowCount;

    public HeaderRenderer(ExportConfiguration exportConfiguration) {
        this.mExportConfiguration = exportConfiguration;
        this.initConfiguration();
    }

    private void initConfiguration() {
        Object object;
        Map map = this.mExportConfiguration.getHeaderFieldLabels();
        Object object2 = map.entrySet().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            ExportConfiguration.HeaderFieldType headerFieldType = (ExportConfiguration.HeaderFieldType)((Object)object.getKey());
            String string = (String)object.getValue();
            ((HeaderField)this.mHeaderFields.get((Object)headerFieldType)).setLabel(string);
        }
        object2 = this.mExportConfiguration.getHeaderFields(ExportConfiguration.HeaderColumnType.FIRST_COLUMN);
        object = this.mExportConfiguration.getHeaderFields(ExportConfiguration.HeaderColumnType.SECOND_COLUMN);
        this.mRowCount = object2.size() > object.size() ? object2.size() : object.size();
    }

    public PdfPTable getFields(OrderHeader orderHeader, Patient patient) {
        List list = this.getHeaderFields(ExportConfiguration.HeaderColumnType.FIRST_COLUMN);
        List list2 = this.getHeaderFields(ExportConfiguration.HeaderColumnType.SECOND_COLUMN);
        boolean bl2 = list2.size() != 0;
        float[] fArray = this.getColumnWidths(bl2);
        PdfPTable pdfPTable = new PdfPTable(fArray);
        pdfPTable.setSpacingBefore(12.0f);
        pdfPTable.addCell(this.createProminentFieldCell(orderHeader, patient, fArray.length));
        for (int i2 = 0; i2 < this.mRowCount; ++i2) {
            PdfPCell pdfPCell = new PdfPCell(this.createFieldCell(i2, list, orderHeader, patient, fArray.length));
            pdfPCell.setLeading(2.0f, 1.0f);
            pdfPCell.setBorder(0);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setVerticalAlignment(1);
            pdfPTable.addCell(pdfPCell);
            if (!bl2) continue;
            pdfPCell = new PdfPCell(this.createFieldCell(i2, list2, orderHeader, patient, fArray.length));
            pdfPCell.setLeading(2.0f, 1.0f);
            pdfPCell.setBorder(0);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingRight(2.0f);
            pdfPCell.setVerticalAlignment(1);
            pdfPTable.addCell(pdfPCell);
        }
        pdfPTable.setHorizontalAlignment(0);
        pdfPTable.setSpacingAfter(8.0f);
        pdfPTable.setWidthPercentage(100.0f);
        return pdfPTable;
    }

    public PdfPTable getLogoAndTitle(Image image) {
        if (!this.hasTitle() && image == null) {
            return new PdfPTable(1);
        }
        int n2 = this.hasTitle() && image != null ? 2 : 1;
        PdfPTable pdfPTable = new PdfPTable(n2);
        if (this.hasTitle()) {
            pdfPTable.addCell(this.createTitleCell());
        }
        if (image != null) {
            pdfPTable.addCell(this.createLogoCell(image));
        }
        pdfPTable.setSpacingAfter(5.0f);
        pdfPTable.setHorizontalAlignment(0);
        pdfPTable.setWidthPercentage(100.0f);
        return pdfPTable;
    }

    private PdfPCell createLogoCell(Image image) {
        PdfPCell pdfPCell = new PdfPCell(image);
        pdfPCell.setHorizontalAlignment(2);
        pdfPCell.setBorder(0);
        pdfPCell.setPaddingRight(30.0f);
        return pdfPCell;
    }

    private PdfPCell createTitleCell() {
        PdfPCell pdfPCell = HeaderRenderer.createPdfCell(this.mExportConfiguration.getReportTitle(), TITLE_HEADER_LABEL_FONT);
        pdfPCell.setHorizontalAlignment(0);
        pdfPCell.setVerticalAlignment(5);
        pdfPCell.setBorder(0);
        pdfPCell.setPaddingLeft(0.0f);
        return pdfPCell;
    }

    private boolean hasTitle() {
        return !StringCheck.isStringBlank(this.mExportConfiguration.getReportTitle());
    }

    private float[] getColumnWidths(boolean bl2) {
        float[] fArray = bl2 ? new float[]{0.5f, 0.5f} : new float[]{1.0f};
        return fArray;
    }

    private List getHeaderFields(ExportConfiguration.HeaderColumnType headerColumnType) {
        ArrayList<HeaderField> arrayList = new ArrayList<HeaderField>();
        List list = this.mExportConfiguration.getHeaderFields(headerColumnType);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ExportConfiguration.HeaderFieldType headerFieldType = (ExportConfiguration.HeaderFieldType)((Object)iterator.next());
            arrayList.add(this.getHeaderField(headerFieldType));
        }
        return arrayList;
    }

    private HeaderField getHeaderField(ExportConfiguration.HeaderFieldType headerFieldType) {
        return (HeaderField)this.mHeaderFields.get((Object)headerFieldType);
    }

    private PdfPTable createFieldCell(int n2, List list, OrderHeader orderHeader, Patient patient, int n3) {
        float[] fArray = new float[]{0.4f, 0.05f, 0.6f};
        if (n3 == 1) {
            fArray[0] = 0.2f;
            fArray[1] = 0.03f;
            fArray[2] = 0.77f;
        }
        PdfPTable pdfPTable = new PdfPTable(fArray);
        if (n2 >= list.size()) {
            return pdfPTable;
        }
        HeaderField headerField = (HeaderField)list.get(n2);
        pdfPTable.addCell(HeaderRenderer.createPdfCell(headerField.getLabel(), HeaderRenderer.getLabelFont(n3)));
        pdfPTable.addCell(HeaderRenderer.createPdfCell(":", HeaderRenderer.getLabelFont(n3), new float[]{3.0f, 0.0f, 3.0f, 0.0f}));
        pdfPTable.addCell(HeaderRenderer.createPdfCell(headerField.getValue(orderHeader, patient), HeaderRenderer.getValueFont(n3)));
        return pdfPTable;
    }

    private PdfPCell createProminentFieldCell(OrderHeader orderHeader, Patient patient, int n2) {
        PdfPTable pdfPTable = new PdfPTable(1);
        if (this.mExportConfiguration.getProminentHeaderField() != null) {
            pdfPTable.addCell(HeaderRenderer.createPdfCell(this.getHeaderField(this.mExportConfiguration.getProminentHeaderField()).getValue(orderHeader, patient), PROMINENT_HEADER_VALUE_FONT));
        }
        PdfPCell pdfPCell = new PdfPCell(pdfPTable);
        pdfPCell.setColspan(n2);
        pdfPCell.setBorder(0);
        pdfPCell.setPaddingBottom(10.0f);
        return pdfPCell;
    }

    private static PdfPCell createPdfCell(String string, Font font) {
        return HeaderRenderer.createPdfCell(string, font, new float[4]);
    }

    private static PdfPCell createPdfCell(String string, Font font, float[] fArray) {
        Phrase phrase = new Phrase();
        phrase.add((Object)new Chunk(string, font));
        PdfPCell pdfPCell = new PdfPCell(phrase);
        pdfPCell.setLeading(2.0f, 1.0f);
        pdfPCell.setPaddingLeft(fArray[0]);
        pdfPCell.setPaddingTop(fArray[1]);
        pdfPCell.setPaddingRight(fArray[2]);
        pdfPCell.setPaddingBottom(fArray[3]);
        pdfPCell.setVerticalAlignment(1);
        pdfPCell.setBorder(0);
        return pdfPCell;
    }

    private static Font getLabelFont(int n2) {
        if (n2 == 1) {
            return ONE_COLUMN_HEADER_LABEL_FONT;
        }
        return TWO_COLUMN_HEADER_LABEL_FONT;
    }

    private static Font getValueFont(int n2) {
        if (n2 == 1) {
            return ONE_COLUMN_HEADER_VALUE_FONT;
        }
        return TWO_COLUMN_HEADER_VALUE_FONT;
    }
}

