/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Export;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.enums.Enum;

public class ExportConfiguration {
    public static final float DEFAULT_LEFT_MARGIN = 0.5f;
    public static final float DEFAULT_RIGHT_MARGIN = 0.25f;
    public static final float DEFAULT_TOP_MARGIN = 0.5f;
    public static final float DEFAULT_BOTTOM_MARGIN = 0.5f;
    public static final float DEFAULT_FOOTER_MARGIN = 0.25f;
    public static final boolean DEFAULT_INCLUDE_LOGO = true;
    public static final boolean DEFAULT_INCLUDE_HEADER = true;
    public static final boolean DEFAULT_INCLUDE_LINE_SEPARATOR = false;
    public static final boolean DEFAULT_REPEAT_HEADER = true;
    public static final String DEFAULT_REPORT_TITLE = "";
    public static final HeaderFieldType DEFAULT_PROMINENT_FIELD = HeaderFieldType.STUDY_DESCRIPTION;
    public static final HeaderFieldType[] DEFAULT_COLUMN_1_FIELDS = new HeaderFieldType[]{HeaderFieldType.ACCESSION, HeaderFieldType.MODALITY, HeaderFieldType.REQUESTED_PROCEDURE_ID, HeaderFieldType.PATIENT_NAME, HeaderFieldType.PATIENT_DATE_OF_BIRTH, HeaderFieldType.REFERING_PHYSICIAN, HeaderFieldType.STUDY_DATE};
    public static final HeaderFieldType[] DEFAULT_COLUMN_2_FIELDS = new HeaderFieldType[0];
    private float mLeftMargin = 0.5f;
    private float mRightMargin = 0.25f;
    private float mTopMargin = 0.5f;
    private float mBottomMargin = 0.5f;
    private float mFooterMargin = 0.25f;
    private boolean mIncludeLogo = true;
    private boolean mIncludeHeader = true;
    private boolean mIncludeLineSeparator = false;
    private boolean mRepeatHeader = true;
    private Map mColumnToHeaderFieldListMap = new HashMap();
    private HeaderFieldType mProminentHeaderField;
    private String mReportTitle;
    private Map mHeaderFieldToLabelMap = new HashMap();
    static /* synthetic */ Class class$ReportViewerLibrary$Export$ExportConfiguration$HeaderColumnType;
    static /* synthetic */ Class class$ReportViewerLibrary$Export$ExportConfiguration$HeaderFieldType;

    public ExportConfiguration() {
        this.mProminentHeaderField = DEFAULT_PROMINENT_FIELD;
        this.mColumnToHeaderFieldListMap.put(HeaderColumnType.FIRST_COLUMN, Arrays.asList(DEFAULT_COLUMN_1_FIELDS));
        this.mColumnToHeaderFieldListMap.put(HeaderColumnType.SECOND_COLUMN, Arrays.asList(DEFAULT_COLUMN_2_FIELDS));
    }

    public float getBottomMargin() {
        return this.mBottomMargin;
    }

    public void setBottomMargin(float f2) {
        this.mBottomMargin = f2;
    }

    public float getFooterMargin() {
        return this.mFooterMargin;
    }

    public void setFooterMargin(float f2) {
        this.mFooterMargin = f2;
    }

    public float getLeftMargin() {
        return this.mLeftMargin;
    }

    public void setLeftMargin(float f2) {
        this.mLeftMargin = f2;
    }

    public float getRightMargin() {
        return this.mRightMargin;
    }

    public void setRightMargin(float f2) {
        this.mRightMargin = f2;
    }

    public float getTopMargin() {
        return this.mTopMargin;
    }

    public void setTopMargin(float f2) {
        this.mTopMargin = f2;
    }

    public boolean includeLogo() {
        return this.mIncludeLogo;
    }

    public void setIncludeLogo(boolean bl2) {
        this.mIncludeLogo = bl2;
    }

    public String getReportTitle() {
        return this.mReportTitle;
    }

    public void setReportTitle(String string) {
        this.mReportTitle = string;
    }

    public boolean includeHeader() {
        return this.mIncludeHeader;
    }

    public void setIncludeHeader(boolean bl2) {
        this.mIncludeHeader = bl2;
    }

    public boolean repeatHeader() {
        return this.mRepeatHeader;
    }

    public void setRepeatHeader(boolean bl2) {
        this.mRepeatHeader = bl2;
    }

    public void setIncludeLineSeparator(boolean bl2) {
        this.mIncludeLineSeparator = bl2;
    }

    public boolean includeLineSeparator() {
        return this.mIncludeLineSeparator;
    }

    public HeaderFieldType getProminentHeaderField() {
        return this.mProminentHeaderField;
    }

    public void setProminentHeaderField(HeaderFieldType headerFieldType) {
        this.mProminentHeaderField = headerFieldType;
    }

    public void setHeaderFields(List list, HeaderColumnType headerColumnType) {
        this.mColumnToHeaderFieldListMap.put(headerColumnType, new ArrayList(list));
    }

    public List getHeaderFields(HeaderColumnType headerColumnType) {
        return Collections.unmodifiableList((List)this.mColumnToHeaderFieldListMap.get((Object)headerColumnType));
    }

    public void setHeaderFieldLabels(Map map) {
        this.mHeaderFieldToLabelMap.putAll(map);
    }

    public Map getHeaderFieldLabels() {
        return Collections.unmodifiableMap(this.mHeaderFieldToLabelMap);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ReportViewerExport configuration: margins (left, right, top bottom, footer) =(").append(this.mLeftMargin).append(",").append(this.mRightMargin).append(",").append(this.mTopMargin).append(",").append(this.mBottomMargin).append(",").append(this.mFooterMargin).append("), ").append("includes logo:").append(this.mIncludeLogo).append(", ").append("includes header:").append(this.mIncludeHeader).append(", ").append("repeat header: ").append(this.mRepeatHeader).append(", ").append("Line separator: ").append(this.mIncludeLineSeparator).append(", ");
        return stringBuffer.toString();
    }

    public static class InvalidHeaderColumnTypeException
    extends Exception {
        public InvalidHeaderColumnTypeException(String string) {
            super(string);
        }
    }

    public static class InvalidHeaderFieldTypeException
    extends Exception {
        public InvalidHeaderFieldTypeException(String string) {
            super(string);
        }
    }

    public static class HeaderFieldType
    extends Enum {
        private static List mKnownHeaderFieldTypes;
        public static final HeaderFieldType PATIENT_NAME;
        public static final HeaderFieldType PATIENT_DATE_OF_BIRTH;
        public static final HeaderFieldType PATIENT_ID;
        public static final HeaderFieldType REFERING_PHYSICIAN;
        public static final HeaderFieldType ORGANIZATION;
        public static final HeaderFieldType STUDY_DATE;
        public static final HeaderFieldType ACCESSION;
        public static final HeaderFieldType REQUESTED_PROCEDURE_ID;
        public static final HeaderFieldType STUDY_DESCRIPTION;
        public static final HeaderFieldType MODALITY;
        public static final HeaderFieldType REPORTING_MD;
        public static final HeaderFieldType DICTATED_STUDY_DATE;

        private HeaderFieldType(String string) {
            super(string);
            if (mKnownHeaderFieldTypes == null) {
                mKnownHeaderFieldTypes = new ArrayList();
            }
            mKnownHeaderFieldTypes.add(this);
        }

        public static HeaderFieldType getInstance(String string) throws InvalidHeaderFieldTypeException {
            HeaderFieldType headerFieldType = (HeaderFieldType)HeaderFieldType.getEnum((Class)(class$ReportViewerLibrary$Export$ExportConfiguration$HeaderFieldType == null ? (class$ReportViewerLibrary$Export$ExportConfiguration$HeaderFieldType = ExportConfiguration.class$("ReportViewerLibrary.Export.ExportConfiguration$HeaderFieldType")) : class$ReportViewerLibrary$Export$ExportConfiguration$HeaderFieldType), (String)string);
            if (!mKnownHeaderFieldTypes.contains((Object)headerFieldType)) {
                throw new InvalidHeaderFieldTypeException("Unknown [" + string + "] header field type");
            }
            return headerFieldType;
        }

        static {
            PATIENT_NAME = new HeaderFieldType("Patient");
            PATIENT_DATE_OF_BIRTH = new HeaderFieldType("PatientDOB");
            PATIENT_ID = new HeaderFieldType("PatientID");
            REFERING_PHYSICIAN = new HeaderFieldType("ReferingPhysician");
            ORGANIZATION = new HeaderFieldType("Organization");
            STUDY_DATE = new HeaderFieldType("StudyDate");
            ACCESSION = new HeaderFieldType("Accession");
            REQUESTED_PROCEDURE_ID = new HeaderFieldType("RequestedProcedureID");
            STUDY_DESCRIPTION = new HeaderFieldType("StudyDescription");
            MODALITY = new HeaderFieldType("Modality");
            REPORTING_MD = new HeaderFieldType("ReportingMD");
            DICTATED_STUDY_DATE = new HeaderFieldType("DictatedStudyDate");
        }
    }

    public static class HeaderColumnType
    extends Enum {
        public static final HeaderColumnType FIRST_COLUMN = new HeaderColumnType("0");
        public static final HeaderColumnType SECOND_COLUMN = new HeaderColumnType("1");
        private static List mKnownHeaderColumnTypes;

        private HeaderColumnType(String string) {
            super(string);
            if (mKnownHeaderColumnTypes == null) {
                mKnownHeaderColumnTypes = new ArrayList();
            }
            mKnownHeaderColumnTypes.add(this);
        }

        public static HeaderColumnType getInstance(String string) throws InvalidHeaderColumnTypeException {
            HeaderColumnType headerColumnType = (HeaderColumnType)HeaderColumnType.getEnum((Class)(class$ReportViewerLibrary$Export$ExportConfiguration$HeaderColumnType == null ? (class$ReportViewerLibrary$Export$ExportConfiguration$HeaderColumnType = ExportConfiguration.class$("ReportViewerLibrary.Export.ExportConfiguration$HeaderColumnType")) : class$ReportViewerLibrary$Export$ExportConfiguration$HeaderColumnType), (String)string);
            if (!mKnownHeaderColumnTypes.contains((Object)headerColumnType)) {
                throw new InvalidHeaderColumnTypeException("Invalid [" + string + "] column ");
            }
            return headerColumnType;
        }
    }
}

