/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Search;

import PatientSearchLibrary.Data.Series;
import PatientSearchLibrary.Data.Study;
import PatientSearchLibrary.Gui.GlobalState;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SeriesMoverClient {
    private int mResultCode = 0;
    private String mErrorDetails = "";

    public abstract void retrieveOfflineStudies(List var1);

    public void getLocationForSeries(Map map) {
        GlobalState.trace("In SeriesMoverClient.getLocationForSeries.");
        try {
            if (this.updateLocationsInSeriesMap(map)) {
                GlobalState.trace("Done parsing series location info.");
                Study.updateStudyStatus(SeriesMoverClient.getStudies(map));
            }
        }
        catch (Exception exception) {
            this.setError("Internal error: " + exception.getMessage(), "Exception in SeriesMoverClient.getLocationForSeries", exception);
        }
    }

    protected abstract boolean updateLocationsInSeriesMap(Map var1) throws IOException, ProtocolException;

    protected static Set getStudies(Map map) {
        HashSet<Study> hashSet = new HashSet<Study>();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Series series = (Series)iterator2.next();
                hashSet.add(series.getStudy());
            }
        }
        return hashSet;
    }

    public abstract List getLocationsForSeriesUids(List var1);

    public String getErrorDetails() {
        return this.mErrorDetails;
    }

    public int getResultCode() {
        return this.mResultCode;
    }

    public void setResultCode(int n2) {
        this.mResultCode = n2;
    }

    protected void setError(String string, String string2) {
        this.setResultCode(1);
        this.mErrorDetails = string;
        GlobalState.error(string2);
    }

    protected void setError(String string, String string2, Exception exception) {
        this.setResultCode(1);
        this.mErrorDetails = string;
        GlobalState.error(string2, exception);
    }

    public static class ResultCode {
        public static final int OK = 0;
        public static final int ERROR = 1;
    }
}

