/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Search;

import PatientSearchLibrary.Data.Study;
import PatientSearchLibrary.Gui.RelatedSeriesWorker;
import PatientSearchLibrary.Gui.RetrievalStatusListener;
import PatientSearchLibrary.Gui.SearchSession;
import PatientSearchLibrary.Gui.ViewWorker;
import PatientSearchLibrary.Retrieve.Retriever;
import PatientSearchLibrary.Search.SearchClient;
import PatientSearchLibrary.View.LoadRequestType;
import PatientSearchLibrary.View.SeriesViewer;
import PatientSearchLibrary.View.ViewSet;
import RuntimeTool.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;

public abstract class SearchRequest {
    private final Debug mDebug;
    private final SearchSession mSearchSession;
    private SearchClient mSearchClient;
    private List mRelatedStudyList;
    private List mLoadSet;
    private String mErrorMessage;

    protected abstract String handleNotStarted();

    protected abstract String handleError();

    protected abstract String handleNoResults();

    protected abstract String handleCancelled();

    protected abstract String handleTooManyResults();

    protected abstract String handleUnsupportedSearchAction();

    protected abstract SearchClient doSearch();

    protected abstract List determineLoadSet(List var1);

    protected SearchRequest(SearchSession searchSession, Debug debug) {
        this.mSearchSession = searchSession;
        this.mDebug = debug;
    }

    public final void performSearch() {
        this.mSearchClient = this.doSearch();
        List list = this.mSearchClient.getSearchResults();
        this.mRelatedStudyList = list != null ? Collections.unmodifiableList(list) : null;
        switch (this.mSearchClient.getResultCode()) {
            case 0: {
                this.handleOk();
                break;
            }
            case 1: {
                this.mErrorMessage = this.handleError();
                break;
            }
            case 2: {
                this.mErrorMessage = this.handleNoResults();
                break;
            }
            case 3: {
                this.mErrorMessage = this.handleTooManyResults();
                break;
            }
            case 4: {
                this.mErrorMessage = this.handleCancelled();
                break;
            }
            case -1: {
                this.mErrorMessage = this.handleNotStarted();
                break;
            }
            case 5: {
                this.mErrorMessage = this.handleUnsupportedSearchAction();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown result code " + this.mSearchClient.getResultCode());
            }
        }
        this.mLoadSet = this.determineLoadSet(this.mRelatedStudyList);
    }

    public boolean searchOk() {
        if (!this.searchResultCodeOK()) {
            return false;
        }
        if (this.mRelatedStudyList == null || this.mRelatedStudyList.isEmpty()) {
            this.appendErrorMessage("Did not find any related series");
            return false;
        }
        if (this.mLoadSet == null || this.mLoadSet.isEmpty()) {
            this.appendErrorMessage("Did not find any data to load");
            return false;
        }
        return true;
    }

    public final String getErrorMessage() {
        return this.mErrorMessage;
    }

    public final void loadStudies(JFrame jFrame, SeriesViewer seriesViewer, Retriever retriever, LoadRequestType loadRequestType, Runnable runnable) {
        this.checkState();
        ViewSet viewSet = new ViewSet(this.mLoadSet);
        RetrievalStatusListener retrievalStatusListener = new RetrievalStatusListener(){

            public void updateRetrievalStatus() {
            }
        };
        ViewWorker viewWorker = new ViewWorker(this.mSearchSession, jFrame, viewSet, seriesViewer, loadRequestType, retriever, retrievalStatusListener, false, false, runnable);
        RelatedSeriesWorker relatedSeriesWorker = new RelatedSeriesWorker(this.mSearchSession, viewSet, seriesViewer, viewWorker, this.getRelatedSeries());
        viewWorker.start();
        relatedSeriesWorker.start();
    }

    protected final void handleOk() {
        this.getDebug().printDebug("Search succeeded: related study list = " + this.mRelatedStudyList);
    }

    protected void checkState() {
        if (this.mRelatedStudyList == null) {
            throw new IllegalStateException("attempt to load studies after failed search");
        }
    }

    public final List getRelatedSeries() {
        if (this.mRelatedStudyList == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.mRelatedStudyList.iterator();
        while (iterator.hasNext()) {
            Study study = (Study)iterator.next();
            arrayList.addAll(study.getSeriesMap().values());
        }
        return arrayList;
    }

    public final List getLoadSet() {
        return Collections.unmodifiableList(this.mLoadSet);
    }

    protected final Debug getDebug() {
        return this.mDebug;
    }

    protected final SearchSession getSearchSession() {
        return this.mSearchSession;
    }

    protected final String getErrorDetails() {
        return this.mSearchClient.getErrorDetails();
    }

    protected final boolean searchResultCodeOK() {
        return this.mSearchClient.getResultCode() == 0;
    }

    protected final void appendErrorMessage(String string) {
        this.mErrorMessage = this.mErrorMessage == null ? string : this.mErrorMessage + "\n" + string;
    }
}

