/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Search;

import StringUtilities.StringSplit;
import java.util.Arrays;
import java.util.List;

public class SearchField {
    public static final String CONFIG_KEY_PREFIX = "SearchField";
    private static final List mKeys = Arrays.asList("patientId", "patientName", "accessionNumber", "referringPhysician", "studyDescription", "seriesDescription", "requestedProcedureId");
    private String mKey;
    private String mDatabaseKey;
    private String mOperator;
    private String mLabel;

    public SearchField(String string, String string2, String string3, String string4) {
        this.mKey = string;
        this.mLabel = string2;
        this.mDatabaseKey = string4;
        this.setOperator(string3);
    }

    SearchField(String string, String string2) {
        this.mKey = string;
        List list = StringSplit.split(string2, "|", false);
        if (list != null && list.size() > 0) {
            this.mLabel = ((String)list.get(0)).replace('%', '#');
            this.setOperator((String)list.get(1));
            this.mDatabaseKey = (String)list.get(2);
        }
    }

    public String getKey() {
        return this.mKey;
    }

    public String getDatabaseKey() {
        return this.mDatabaseKey;
    }

    private void setOperator(String string) {
        if (string.equals("C")) {
            this.mOperator = "CONTAINS";
        } else if (string.equals("B")) {
            this.mOperator = "BEGINS";
        } else {
            throw new IllegalArgumentException("Bad search field operator: must be 'C' or 'B'");
        }
    }

    public String getOperator() {
        return this.mOperator;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public static String getConfigKey(int n2) {
        return CONFIG_KEY_PREFIX + (n2 + 1);
    }

    public static final String getKey(int n2) {
        return (String)mKeys.get(n2);
    }

    public static String[] getPreferredSearchFieldKeys(String string, String string2) {
        String[] stringArray = new String[]{"patientId", "patientName"};
        if (mKeys.contains(string)) {
            stringArray[0] = string;
        }
        if (mKeys.contains(string2)) {
            stringArray[1] = string2;
        }
        return stringArray;
    }

    public static int[] getPreferredSearchFieldIndices(String string, String string2) {
        String[] stringArray = SearchField.getPreferredSearchFieldKeys(string, string2);
        int[] nArray = new int[]{mKeys.indexOf(stringArray[0]), mKeys.indexOf(stringArray[1])};
        return nArray;
    }

    public static final class Key {
        public static final String PATIENT_ID = "patientId";
        public static final String PATIENT_NAME = "patientName";
        public static final String ACCESSION_NUMBER = "accessionNumber";
        public static final String REFERRING_PHYSICIAN = "referringPhysician";
        public static final String STUDY_DESCRIPTION = "studyDescription";
        public static final String SERIES_DESCRIPTION = "seriesDescription";
        public static final String REQUESTED_PROCEDURE_ID = "requestedProcedureId";
    }

    public static class Operator {
        public static final String BEGINS_WITH = "BEGINS";
        public static final String CONTAINS = "CONTAINS";
    }
}

