/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Search;

import PatientSearchLibrary.Search.DateFilter;
import PatientSearchLibrary.Search.DisplayFieldParameters;
import PatientSearchLibrary.Search.SearchField;
import RuntimeTool.ControlFileException;
import StringUtilities.StringCheck;
import com.intelerad.table.lib.TableColumnProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SearchConfiguration {
    public static final int MAX_SEARCH_FIELDS = 7;
    private String mLanguage;
    private Map mSearchFields;
    private List mSearchFieldList;
    private List mStudyColumns;
    private List mSeriesColumns;
    private ArrayList mDateFilters;

    public SearchConfiguration(String string, Map map) throws ControlFileException {
        this.mLanguage = string;
        this.initSearchFields(map);
        this.initDisplayFields(map);
        this.initDateFilters(map);
    }

    private void initSearchFields(Map map) throws ControlFileException {
        this.mSearchFields = new LinkedHashMap();
        for (int i2 = 0; i2 < 7; ++i2) {
            String string = SearchField.getConfigKey(i2);
            String string2 = (String)map.get(string);
            SearchField searchField = !StringCheck.isStringEmpty(string2) ? new SearchField(SearchField.getKey(i2), string2) : this.handleSearchFieldNotFound(i2);
            if (searchField == null) continue;
            this.mSearchFields.put(searchField.getKey(), searchField);
        }
        this.mSearchFieldList = new ArrayList(this.mSearchFields.values());
    }

    private void initDisplayFields(Map map) throws ControlFileException {
        this.mStudyColumns = this.getDisplayColumns(true, map);
        this.mSeriesColumns = this.getDisplayColumns(false, map);
    }

    private void initDateFilters(Map map) {
        this.mDateFilters = new ArrayList();
        List list = this.getKeysStartingWith(map, "DateDisplayField");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            if (StringCheck.isStringEmpty(string2)) continue;
            this.mDateFilters.add(new DateFilter(string2));
        }
    }

    private List getDisplayColumns(boolean bl2, Map map) throws ControlFileException {
        List list = this.parseDisplayFieldParameters(DisplayFieldParameters.getConfigKeyPrefix(bl2), map);
        if (list.isEmpty()) {
            list = this.handleDisplayFieldsNotFound(bl2);
        }
        return list;
    }

    private List parseDisplayFieldParameters(String string, Map map) {
        ArrayList<TableColumnProperties> arrayList = new ArrayList<TableColumnProperties>();
        List list = this.getKeysStartingWith(map, string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)map.get(string2);
            if (StringCheck.isStringEmpty(string3)) continue;
            DisplayFieldParameters displayFieldParameters = new DisplayFieldParameters(string3);
            arrayList.add(this.customizeColumn(displayFieldParameters));
        }
        return arrayList;
    }

    private List getKeysStartingWith(Map map, String string) {
        List<String> list = new ArrayList();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            list.add(string2);
        }
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        Collections.sort(list);
        return list;
    }

    private HashMap getColumnMap(List list) {
        LinkedHashMap<String, TableColumnProperties> linkedHashMap = new LinkedHashMap<String, TableColumnProperties>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TableColumnProperties tableColumnProperties = (TableColumnProperties)iterator.next();
            linkedHashMap.put(tableColumnProperties.getKey(), tableColumnProperties);
        }
        return linkedHashMap;
    }

    protected SearchField handleSearchFieldNotFound(int n2) throws ControlFileException {
        throw new ControlFileException("Did not find configuration key '" + SearchField.getConfigKey(n2) + "' for language " + this.mLanguage);
    }

    protected List handleDisplayFieldsNotFound(boolean bl2) throws ControlFileException {
        throw new ControlFileException("Did not find any display field keys (starting with " + DisplayFieldParameters.getConfigKeyPrefix(bl2) + ")");
    }

    protected TableColumnProperties customizeColumn(TableColumnProperties tableColumnProperties) {
        return tableColumnProperties;
    }

    public int getConfiguredFieldsCount() {
        return this.mSearchFields.size();
    }

    public SearchField getSearchField(int n2) {
        return (SearchField)this.mSearchFieldList.get(n2);
    }

    public SearchField getSearchField(String string) {
        return (SearchField)this.mSearchFields.get(string);
    }

    public int getStudyColumnCount() {
        return this.mStudyColumns.size();
    }

    public TableColumnProperties getStudyColumn(int n2) {
        return (TableColumnProperties)this.mStudyColumns.get(n2);
    }

    public int getSeriesColumnCount() {
        return this.mSeriesColumns.size();
    }

    public TableColumnProperties getSeriesColumn(int n2) {
        return (TableColumnProperties)this.mSeriesColumns.get(n2);
    }

    public int getDateFilterCount() {
        return this.mDateFilters.size();
    }

    public DateFilter getDateFilter(int n2) {
        return (DateFilter)this.mDateFilters.get(n2);
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public String getPatientIdLabel() {
        return this.getSearchField("patientId").getLabel();
    }

    public String getAccessionNumberLabel() {
        return this.getSearchField("accessionNumber").getLabel();
    }

    public String getRequestedProcedureIdLabel() {
        return this.getSearchField("requestedProcedureId").getLabel();
    }

    public Map getStudyDisplayFieldMap() {
        return this.getColumnMap(this.mStudyColumns);
    }

    public Map getSeriesDisplayFieldMap() {
        return this.getColumnMap(this.mSeriesColumns);
    }

    public static String getPatientIdDelimiter(boolean bl2) {
        return bl2 ? "\\" : "/";
    }
}

