/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Search;

import PatientSearchLibrary.Data.Study;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Gui.SearchSession;
import PatientSearchLibrary.Search.BaseSearchSpecification;
import PatientSearchLibrary.Search.SearchSpecification;
import StringUtilities.ToString;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class SearchClient {
    private String mErrorDetails = "";
    private int mResultCode = -1;

    public static SearchClient searchAllStudiesForPatients(SearchSession searchSession, Set set, boolean bl2) {
        SearchClient searchClient = searchSession.createSearchClient();
        SearchSpecification searchSpecification = searchClient.createPatientSearchSpecification(set, bl2);
        searchClient.setSearchSpecification(searchSpecification);
        searchClient.performSearch();
        List list = searchClient.getSearchResults();
        if (searchClient.getResultCode() == 0 && list != null) {
            GlobalState.trace("Iterating through search results to remove studies that do not exactly match patient IDs " + ToString.set(set));
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Study study = (Study)iterator.next();
                String string = (String)study.getValue("PatID");
                if (set.contains(string)) continue;
                iterator.remove();
            }
            if (list.size() == 0) {
                GlobalState.trace("No studies left in result list. Setting searchResults to null and resultCode to NO_RESULTS.");
                searchClient.setResultCode(2);
                searchClient.setErrorDetails("No results found");
            }
            GlobalState.trace("Finished removing invalid studies from result list.");
        }
        return searchClient;
    }

    protected abstract SearchSpecification createPatientSearchSpecification(Set var1, boolean var2);

    public abstract void cancelSearch() throws IOException;

    public abstract List getSearchResults();

    public abstract BaseSearchSpecification getSearchSpecification();

    public abstract void performSearch();

    public abstract void setSearchSpecification(BaseSearchSpecification var1);

    void setErrorDetails(String string) {
        this.mErrorDetails = string;
    }

    public String getErrorDetails() {
        return this.mErrorDetails;
    }

    void setResultCode(int n2) {
        this.mResultCode = n2;
    }

    public int getResultCode() {
        return this.mResultCode;
    }

    public static class ResultCode {
        public static final int NOT_STARTED = -1;
        public static final int OK = 0;
        public static final int ERROR = 1;
        public static final int NO_RESULTS = 2;
        public static final int TOO_MANY_RESULTS = 3;
        public static final int CANCELLED = 4;
        public static final int UNSUPPORTED_SEARCH_ACTION = 5;
    }
}

