/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Search;

import DataModels.SearchFramework.SeriesLocation;
import PatientSearchLibrary.Data.PacsSeriesLocation;
import PatientSearchLibrary.Data.Series;
import PatientSearchLibrary.Data.Status;
import PatientSearchLibrary.Data.Study;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Gui.PacsSearchSession;
import PatientSearchLibrary.Search.SeriesMoverClient;
import StringUtilities.StringEncoder;
import StringUtilities.StringJoin;
import StringUtilities.StringSplit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PacsSeriesMoverClient
extends SeriesMoverClient {
    private static final String IDENTIFIER = "IV";
    private PacsSearchSession mSession;

    public PacsSeriesMoverClient(PacsSearchSession pacsSearchSession) {
        this.mSession = pacsSearchSession;
    }

    public void retrieveOfflineStudies(List list) {
        String string;
        Object object;
        Object object2;
        Object object3;
        if (list.isEmpty()) {
            return;
        }
        GlobalState.trace("In SeriesMoverClient.getOfflineStudies");
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object3 = (Study)iterator.next();
            object2 = ((Study)object3).getStudyUid();
            object = ((Study)object3).getSeriesMap().keySet().iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                vector.add((String)object2);
                vector2.add(string);
            }
        }
        object3 = new StringBuffer();
        ((StringBuffer)object3).append("&studyUid=");
        ((StringBuffer)object3).append(StringJoin.vectorJoin(vector, "|"));
        ((StringBuffer)object3).append("&seriesUid=");
        ((StringBuffer)object3).append(StringJoin.vectorJoin(vector2, "|"));
        ((StringBuffer)object3).append("&identifier=" + this.getIdentifier());
        try {
            object2 = this.mSession.getSeriesMoverServletUrl("?action=moveStudyHere");
            object = this.post((URL)object2, ((StringBuffer)object3).toString());
            GlobalState.trace("Successfully opened connection.");
            string = ((BufferedReader)object).readLine();
            if (string == null) {
                this.setError("No data received from server.", "No data received from server.");
            } else if (!string.startsWith("OK")) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string.substring(string.indexOf("|") + 1));
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    stringBuffer.append("\n");
                    stringBuffer.append(string);
                }
                this.setError("Retrieving offline studies returned an error.", "Retrieving offline studies returned an error. Data returned from server:\n" + stringBuffer.toString());
            } else {
                GlobalState.trace("SeriesMoverServlet returned 'OK'.");
                this.setResultCode(0);
            }
        }
        catch (Exception exception) {
            this.setError("Internal error: " + exception.getMessage(), "Exception in SeriesMoverClient.getOfflineStudies", exception);
        }
    }

    protected boolean updateLocationsInSeriesMap(Map map) throws IOException, ProtocolException {
        URL uRL = this.mSession.getSeriesMoverServletUrl("?action=getSeriesLocation&returnIpAddress=true");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("&seriesUid=");
        stringBuffer.append(this.getSeriesUidsArgument(map));
        stringBuffer.append("&identifier=" + this.getIdentifier());
        BufferedReader bufferedReader = this.post(uRL, stringBuffer.toString());
        GlobalState.trace("Successully opened connection. Parsing data...");
        return this.parseServletOutput(map, bufferedReader);
    }

    private String getIdentifier() {
        return StringEncoder.urlEncode("IV_" + this.mSession.getUsername(), GlobalState.getDebug());
    }

    boolean parseServletOutput(Map map, BufferedReader bufferedReader) throws IOException {
        String string;
        boolean bl2 = true;
        while ((string = bufferedReader.readLine()) != null) {
            if (bl2 && !string.startsWith("OK|") && !string.startsWith("NA|")) {
                String string2 = string.substring(string.indexOf(124) + 1);
                this.setError("Getting series locations returned an error: " + string2, "SeriesMover servlet returned an error getting series locations: " + string2 + ". Aborting parsing.");
                return false;
            }
            if (!string.startsWith("OK|") && !string.startsWith("NA|")) {
                this.setError("Error parsing series location information.", "Unable to parse data '" + string + "'. Aborting parsing.");
                return false;
            }
            this.parseServletOutputLine(map, string);
            bl2 = false;
        }
        if (bl2) {
            this.setError("No data received from server.", "No data received from server. Aborting parsing.");
            return false;
        }
        return true;
    }

    private void parseServletOutputLine(Map map, String string) {
        List list = StringSplit.split(string, "|");
        String string2 = (String)list.get(1);
        List list2 = (List)map.get(string2);
        if (list2 == null) {
            this.setError("Data consistency error", "SeriesMover servlet returned result for series UID [" + string2 + "] but SeriesMoverClient does not know " + "about this series. Skipping this series.");
            return;
        }
        if (string.startsWith("OK|")) {
            String string3 = (String)list.get(2);
            String string4 = (String)list.get(3);
            boolean bl2 = Boolean.valueOf(string4);
            Status status = bl2 ? Status.OFFLINE : Status.ONLINE;
            this.setSeriesLocationAndStatus(list2, string3, bl2, status);
        } else {
            this.setSeriesLocationAndStatus(list2, null, false, Status.UNAVAILABLE);
        }
    }

    private void setSeriesLocationAndStatus(List list, String string, boolean bl2, Status status) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Series series = (Series)iterator.next();
            SeriesLocation.InstanceAvailability instanceAvailability = SeriesLocation.UNAVAILABLE;
            if (status == Status.ONLINE) {
                instanceAvailability = SeriesLocation.ONLINE;
            } else if (status == Status.OFFLINE) {
                instanceAvailability = SeriesLocation.NEARLINE;
            }
            PacsSeriesLocation pacsSeriesLocation = string != null ? new PacsSeriesLocation(series.getSeriesUid(), string, instanceAvailability) : null;
            series.setOffline(bl2);
            series.setSeriesLocation(pacsSeriesLocation);
            series.setStatus(status);
        }
    }

    private String getSeriesUidsArgument(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string);
            if (!iterator.hasNext()) continue;
            stringBuffer.append("|");
        }
        return stringBuffer.toString();
    }

    public List getLocationsForSeriesUids(List list) {
        List list2;
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        Study study = new Study("one|two|three|four|five|six|seven|eight|nine|ten|eleven|twelve|13|14|");
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            object = new Series((String)object2 + "|two|three|1918/11/11 11:11|five|six|7|8|9|10|11|12|", study);
            list2 = new ArrayList<Object>();
            list2.add(object);
            hashMap.put(((Series)object).getSeriesUid(), list2);
        }
        this.getLocationForSeries(hashMap);
        if (this.getResultCode() == 1) {
            return null;
        }
        object3 = new ArrayList();
        object2 = list.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            list2 = (List)hashMap.get(object);
            Series series = (Series)list2.get(0);
            object3.add(series.getSeriesLocation());
        }
        return object3;
    }

    private BufferedReader post(URL uRL, String string) throws IOException, ProtocolException {
        GlobalState.trace("Hitting seriesMoverServlet with the following URL: " + uRL + " Post data: " + string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestMethod("POST");
        OutputStream outputStream = httpURLConnection.getOutputStream();
        outputStream.write(string.getBytes());
        InputStreamReader inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream());
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        return bufferedReader;
    }
}

