/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Retrieve;

import PatientSearchLibrary.Data.Series;
import PatientSearchLibrary.Data.Status;
import PatientSearchLibrary.Data.Study;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StudyToRetrieve {
    private List mStudyList = new ArrayList();
    private Map mSeriesMap = new LinkedHashMap();
    private boolean moveRequested;

    public StudyToRetrieve(Study study) {
        this.mStudyList.add(study);
        this.addSeries(study);
        this.moveRequested = false;
    }

    public int getNumberOfTimesRequested() {
        return this.mStudyList.size();
    }

    public boolean isMoveRequested() {
        return this.moveRequested;
    }

    public List getStudyList() {
        return this.mStudyList;
    }

    public void setMoveRequested(boolean bl2) {
        this.moveRequested = bl2;
    }

    public void addStudy(Study study) {
        this.mStudyList.add(study);
        this.addSeries(study);
    }

    public void removeStudy(Study study) {
        this.mStudyList.remove(study);
        this.removeSeries(study);
    }

    public String getStudyUid() {
        return ((Study)this.mStudyList.get(0)).getStudyUid();
    }

    public boolean isOnline() {
        return ((Study)this.mStudyList.get(0)).getStatus() == Status.ONLINE;
    }

    public Map getSeriesMap() {
        return this.mSeriesMap;
    }

    public void updateStatus() {
        Iterator iterator = this.mStudyList.iterator();
        while (iterator.hasNext()) {
            Study study = (Study)iterator.next();
            study.updateStatus();
        }
    }

    private void addSeries(Study study) {
        Iterator iterator = study.getSeriesMap().values().iterator();
        while (iterator.hasNext()) {
            List<Series> list;
            Series series = (Series)iterator.next();
            String string = series.getSeriesUid();
            if (this.mSeriesMap.containsKey(string)) {
                list = (List)this.mSeriesMap.get(string);
                list.add(series);
                continue;
            }
            list = new ArrayList<Series>();
            list.add(series);
            this.mSeriesMap.put(string, list);
        }
    }

    private void removeSeries(Study study) {
        Iterator iterator = study.getSeriesMap().values().iterator();
        while (iterator.hasNext()) {
            Series series = (Series)iterator.next();
            String string = series.getSeriesUid();
            if (this.mSeriesMap.containsKey(string)) {
                List list = (List)this.mSeriesMap.get(string);
                if (list == null) {
                    throw new IllegalStateException("Found null list of series with UID [" + string + "] in StudyToRetrieve's Series map");
                }
                list.remove(series);
                continue;
            }
            throw new IllegalStateException("Expected to find list of series with UID [" + string + "] in StudyToRetrieve's Series map");
        }
    }
}

