/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Retrieve;

import PatientSearchLibrary.Data.Study;
import PatientSearchLibrary.Gui.ErrorDisplayer;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Gui.RetrievalHandler;
import PatientSearchLibrary.Gui.RetrievalStatusListener;
import PatientSearchLibrary.Gui.SearchSession;
import PatientSearchLibrary.Retrieve.StudyToRetrieve;
import PatientSearchLibrary.Search.SeriesMoverClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Retriever
extends Thread {
    private static final int SLEEP_TIME_MILLISECONDS = 10000;
    private static int mThreadCount = 0;
    private SearchSession mSession;
    private Map mStudiesToRetrieve;
    private Set mRetrievalStatusListeners;
    private Set mRetrievalHandlers;
    private ErrorDisplayer mErrorDisplayer;

    public Retriever(SearchSession searchSession, ErrorDisplayer errorDisplayer) {
        super("PatientSearch-Retriever-" + mThreadCount++);
        this.mSession = searchSession;
        this.mStudiesToRetrieve = new LinkedHashMap();
        this.mRetrievalStatusListeners = new LinkedHashSet();
        this.mRetrievalHandlers = new LinkedHashSet();
        this.mErrorDisplayer = errorDisplayer;
    }

    public void run() {
        try {
            while (true) {
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                this.processStudiesToRetrieve(arrayList, arrayList2);
                this.notifyAllListeners();
                this.removeOnlineStudies(arrayList);
                SeriesMoverClient seriesMoverClient = this.mSession.createSeriesMoverClient();
                seriesMoverClient.retrieveOfflineStudies(this.getStudiesFromStudyUidList(arrayList2));
                if (seriesMoverClient.getResultCode() == 1) {
                    this.mErrorDisplayer.showError("Error retrieving offline images");
                    GlobalState.error("Error getting offline studies: " + seriesMoverClient.getErrorDetails());
                }
                Retriever.sleep(10000L);
            }
        }
        catch (InterruptedException interruptedException) {
            GlobalState.error("Got InterruptedException in Retriever.run()", interruptedException);
            return;
        }
    }

    private synchronized List getStudiesFromStudyUidList(List list) {
        ArrayList<Study> arrayList = new ArrayList<Study>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2;
            String string = (String)iterator.next();
            StudyToRetrieve studyToRetrieve = (StudyToRetrieve)this.mStudiesToRetrieve.get(string);
            if (studyToRetrieve == null || (list2 = studyToRetrieve.getStudyList()) == null || list2.size() <= 0) continue;
            Study study = (Study)list2.get(0);
            arrayList.add(study);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllListeners() {
        HashSet hashSet;
        Object object = this;
        synchronized (object) {
            hashSet = new HashSet(this.mRetrievalStatusListeners);
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            RetrievalStatusListener retrievalStatusListener = (RetrievalStatusListener)object.next();
            retrievalStatusListener.updateRetrievalStatus();
        }
    }

    private synchronized void removeOnlineStudies(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.mStudiesToRetrieve.remove(string);
        }
    }

    private synchronized void processStudiesToRetrieve(List list, List list2) {
        Iterator iterator = this.mStudiesToRetrieve.values().iterator();
        while (iterator.hasNext()) {
            StudyToRetrieve studyToRetrieve = (StudyToRetrieve)iterator.next();
            if (!studyToRetrieve.isMoveRequested()) {
                studyToRetrieve.setMoveRequested(true);
                list2.add(studyToRetrieve.getStudyUid());
                continue;
            }
            SeriesMoverClient seriesMoverClient = this.mSession.createSeriesMoverClient();
            seriesMoverClient.getLocationForSeries(studyToRetrieve.getSeriesMap());
            if (seriesMoverClient.getResultCode() == 1) {
                this.mErrorDisplayer.showError("Error getting image location information");
                GlobalState.error("Error getting series location: " + seriesMoverClient.getErrorDetails());
                continue;
            }
            studyToRetrieve.updateStatus();
            if (!studyToRetrieve.isOnline()) continue;
            list.add(studyToRetrieve.getStudyUid());
        }
    }

    public synchronized void addStudyToRetrieve(Study study) {
        String string = study.getStudyUid();
        if (this.mStudiesToRetrieve.containsKey(string)) {
            StudyToRetrieve studyToRetrieve = (StudyToRetrieve)this.mStudiesToRetrieve.get(string);
            studyToRetrieve.addStudy(study);
        } else {
            StudyToRetrieve studyToRetrieve = new StudyToRetrieve(study);
            this.mStudiesToRetrieve.put(string, studyToRetrieve);
        }
    }

    public synchronized void cancelStudyRetrieval(Study study) {
        String string = study.getStudyUid();
        if (this.mStudiesToRetrieve.containsKey(string)) {
            StudyToRetrieve studyToRetrieve = (StudyToRetrieve)this.mStudiesToRetrieve.get(string);
            studyToRetrieve.removeStudy(study);
            if (studyToRetrieve.getNumberOfTimesRequested() <= 0) {
                this.mStudiesToRetrieve.remove(string);
            }
        }
    }

    public synchronized void registerRetrievalStatusListener(RetrievalStatusListener retrievalStatusListener) {
        this.mRetrievalStatusListeners.add(retrievalStatusListener);
    }

    public synchronized void unregisterRetrievalStatusListener(RetrievalStatusListener retrievalStatusListener) {
        this.mRetrievalStatusListeners.remove(retrievalStatusListener);
    }

    public synchronized void registerRetrievalHandler(RetrievalHandler retrievalHandler) {
        this.mRetrievalHandlers.add(retrievalHandler);
        this.registerRetrievalStatusListener(retrievalHandler);
    }

    public synchronized void unregisterRetrievalHandler(RetrievalHandler retrievalHandler) {
        this.mRetrievalHandlers.remove(retrievalHandler);
        this.unregisterRetrievalStatusListener(retrievalHandler);
    }

    public synchronized boolean isStudyBeingRetrieved(Study study) {
        return this.mStudiesToRetrieve.containsKey(study.getStudyUid());
    }

    public synchronized void unregisterAllAutomaticRetrievalHandlers() {
        Iterator iterator = this.mRetrievalHandlers.iterator();
        while (iterator.hasNext()) {
            RetrievalHandler retrievalHandler = (RetrievalHandler)iterator.next();
            if (retrievalHandler.isUserCancellable()) continue;
            iterator.remove();
        }
    }

    public synchronized void reset() {
        this.mRetrievalHandlers.clear();
        this.mRetrievalStatusListeners.clear();
        this.mStudiesToRetrieve.clear();
    }
}

