/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Preferences;

import GuiUtilities.Util.LabelValuePair;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Search.DisplayFieldParameters;
import PatientSearchLibrary.Search.ModalityConfiguration;
import PatientSearchLibrary.Search.SearchConfiguration;
import PatientSearchLibrary.Search.SearchField;
import RuntimeTool.ControlFile;
import RuntimeTool.ControlFileException;
import StringUtilities.StringCheck;
import com.intelerad.patientsearch.lib.PatientNameTreatment;
import com.intelerad.table.lib.TableColumnProperties;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SiteConfiguration {
    public static final String SEARCH_FORM_ENGLISH_SECTION = "SEARCH_FORM_ENGLISH";
    public static final String MODALITY_QUERY_SECTION = "MODALITY_QUERY";
    private static final String PATIENT_SEARCH_SECTION = "PATIENT_SEARCH";
    private static final String PATIENT_SEARCHABLE_SOURCE_SECTION = "PATIENT_SEARCHABLE_SOURCE";
    private static final String SEARCH_SERVLET = "SEARCH_SERVLET";
    private static final String SERIES_MOVER_SERVLET = "SERIES_MOVER_SERVLET";
    private static final String BACKSLASH_PATIENT_ID_DELIMITER = "backslashPatientIdDelimiter";
    private static final String PATIENT_NAME_TREATMENT = "patientNameTreatment";
    private static final String SEARCHABLE_SOURCE_TYPE = "SEARCHABLE_SOURCE_TYPE";
    private static final String DICOM_SOURCE_NAME = "DICOM_SOURCE_NAME";
    public static final String PATIENT_NAME_STUDY_DISPLAY_FIELD_KEY = "PName";
    public static final String PATIENT_ID_STUDY_DISPLAY_FIELD_KEY = "PatID";
    public static final String ACCESSION_NB_STUDY_DISPLAY_FIELD_KEY = "AccNum";
    public static final String DATE_STUDY_DISPLAY_FIELD_KEY = "StuDate";
    public static final String MODALITIES_STUDY_DISPLAY_FIELD_KEY = "Mod";
    public static final String SERIES_NUM_STUDY_DISPLAY_FIELD_KEY = "Ser%";
    public static final String DESCRIPTION_STUDY_DISPLAY_FIELD_KEY = "StuDes";
    public static final String DATE_SERIES_DISPLAY_FIELD_KEY = "SerDate";
    public static final String SERIES_NUM_SERIES_DISPLAY_FIELD_KEY = "SerNum";
    public static final String IMAGE_SERIES_DISPLAY_FIELD_KEY = "Image%";
    public static final String DESCRIPTION_SERIES_DISPLAY_FIELD_KEY = "SerDes";
    private static final int COLUMN_PIXELS_PER_CHAR = 12;
    private static final SearchField[] DEFAULT_SEARCH_FIELDS = new SearchField[]{new SearchField("patientId", "Patient ID", "B", "StudyLevel.PatParent"), new SearchField("patientName", "Patient Name", "B", "StudyLevel.GroupName"), new SearchField("accessionNumber", "Requisition Number", "C", "StudyLevel.AccNum"), new SearchField("referringPhysician", "Referring Physican", "B", "StudyLevel.RefPhyNam"), new SearchField("studyDescription", "Study Description", "C", "StudyLevel.StuDes"), new SearchField("seriesDescription", "Series Description", "C", "SeriesLevel.SerDes")};
    private static final TableColumnProperties[] DEFAULT_STUDY_COLUMNS = new TableColumnProperties[]{new TableColumnProperties("Patient Name", 20, "PName"), new TableColumnProperties("Patient ID", 14, "PatID"), new TableColumnProperties("Acc. No.", 12, "AccNum"), new TableColumnProperties("Study Date", 18, "StuDate"), new TableColumnProperties("Mod", 5, "Mod"), new TableColumnProperties("Series", 7, "Ser%"), new TableColumnProperties("Study Description", 30, "StuDes")};
    private static final TableColumnProperties[] DEFAULT_SERIES_COLUMNS = new TableColumnProperties[]{new TableColumnProperties("Patient Name", 20, "PName"), new TableColumnProperties("Patient ID", 14, "PatID"), new TableColumnProperties("Series Date", 18, "SerDate"), new TableColumnProperties("Mod", 5, "Mod"), new TableColumnProperties("Series #", 8, "SerNum"), new TableColumnProperties("Images", 8, "Image%"), new TableColumnProperties("Series Description", 30, "SerDes")};
    private static final String DICOM_SEARCHABLE_SOURCE_TYPE = "DICOM";
    public static final int MAX_SEARCH_FIELDS = 6;
    private ControlFile mControlFile;
    private ModalityConfiguration mModalityConfiguration;
    private SearchConfiguration mSearchConfiguration;
    private String mDicomSourceName;
    private boolean mDicomSearchAvailable;
    private String mSearchServletPath;
    private String mSeriesMoverServletPath;
    private String mPacsSearchPatientIdDelimiter;
    private PatientNameTreatment mPatientNameTreatment;

    public SiteConfiguration(ControlFile controlFile) {
        this.mControlFile = controlFile;
        this.updateAvailableModalities();
        this.initSearchConfiguration();
        this.updateServletPaths();
        this.updateSearchSource();
        this.initBackslashPatientIdDelimiter();
        this.initPatientNameTreatment();
    }

    public List getAvailableModalities() {
        return this.mModalityConfiguration.getAvailableModalityLabels();
    }

    public List getAvailableModalityLabelValues() {
        return this.mModalityConfiguration.getAvailableModalityLabelAndValues();
    }

    public SearchField getSearchField(int n2) {
        return this.mSearchConfiguration.getSearchField(n2);
    }

    public String getDicomSourceName() {
        return this.mDicomSourceName;
    }

    public boolean isDicomSearchAvailable() {
        return this.mDicomSearchAvailable;
    }

    public String getSearchServletPath() {
        return this.mSearchServletPath;
    }

    public String getSeriesMoverServletPath() {
        return this.mSeriesMoverServletPath;
    }

    public Map getStudyDisplayFieldMap() {
        return this.mSearchConfiguration.getStudyDisplayFieldMap();
    }

    public Map getSeriesDisplayFieldMap() {
        return this.mSearchConfiguration.getSeriesDisplayFieldMap();
    }

    public String getPacsSearchPatientIdDelimiter() {
        return this.mPacsSearchPatientIdDelimiter;
    }

    public PatientNameTreatment getPatientNameTreatment() {
        return this.mPatientNameTreatment;
    }

    private void updateAvailableModalities() {
        Map map = this.mControlFile.GetSectionOrdered(MODALITY_QUERY_SECTION);
        if (map == null) {
            this.mModalityConfiguration = new ModalityConfiguration();
            GlobalState.trace("MODALITY_QUERY section not found. Setting default modalities.");
        } else {
            this.mModalityConfiguration = new ModalityConfiguration(map);
            GlobalState.trace("Found " + map.size() + " site default keys in section " + MODALITY_QUERY_SECTION + ":");
            Iterator iterator = this.mModalityConfiguration.getAvailableModalityLabelAndValues().iterator();
            while (iterator.hasNext()) {
                LabelValuePair labelValuePair = (LabelValuePair)iterator.next();
                GlobalState.trace("Found key " + labelValuePair.getLabel());
            }
        }
    }

    private void initSearchConfiguration() {
        try {
            Map map = this.mControlFile.GetSectionOrdered(SEARCH_FORM_ENGLISH_SECTION);
            this.mSearchConfiguration = new SearchConfiguration("en", map){

                protected SearchField handleSearchFieldNotFound(int n2) throws ControlFileException {
                    String string = SearchField.getConfigKey(n2);
                    if (n2 < DEFAULT_SEARCH_FIELDS.length) {
                        GlobalState.warning("Did not find search field key '" + string + "' in section '" + SiteConfiguration.SEARCH_FORM_ENGLISH_SECTION + "'. Using default value.");
                        return DEFAULT_SEARCH_FIELDS[n2];
                    }
                    GlobalState.warning("Did not find search field key '" + string + "' in section '" + SiteConfiguration.SEARCH_FORM_ENGLISH_SECTION + "'. We don't have a default value, so we will just " + "ignore this field.");
                    return null;
                }

                protected List handleDisplayFieldsNotFound(boolean bl2) throws ControlFileException {
                    String string = DisplayFieldParameters.getConfigKeyPrefix(bl2);
                    GlobalState.warning("Did not find any display field keys (starting with " + string + ") in section '" + SiteConfiguration.SEARCH_FORM_ENGLISH_SECTION + "'. Using default values.");
                    return Arrays.asList(bl2 ? DEFAULT_STUDY_COLUMNS : DEFAULT_SERIES_COLUMNS);
                }

                protected TableColumnProperties customizeColumn(TableColumnProperties tableColumnProperties) {
                    return new TableColumnProperties(tableColumnProperties.getKey(), tableColumnProperties.getColumnWidth() * 12, tableColumnProperties.getFieldName());
                }
            };
        }
        catch (ControlFileException controlFileException) {
            throw new IllegalStateException("SearchFields initialization should never have thrown a ControlFileException since we catch missing fields and use default values!");
        }
    }

    private String getConfigKey(String string, String string2, String string3) {
        String string4 = this.mControlFile.GetStringValue(string, string2);
        if (!StringCheck.isStringEmpty(string4)) {
            return string4;
        }
        GlobalState.warning("No value found for key " + string2 + " in [" + string + "] " + "(using default value: " + string3 + ")");
        return string3;
    }

    private boolean getConfigKey(String string, String string2, boolean bl2) {
        try {
            return this.mControlFile.GetBooleanValue(string, string2);
        }
        catch (NumberFormatException numberFormatException) {
            GlobalState.warning("Missing or invalid boolean value found for key " + string2 + " in [" + string + "] (using default value: " + bl2 + ")");
            return bl2;
        }
    }

    private void updateServletPaths() {
        this.mSearchServletPath = this.getConfigKey(PATIENT_SEARCH_SECTION, SEARCH_SERVLET, null);
        this.mSeriesMoverServletPath = this.getConfigKey(PATIENT_SEARCH_SECTION, SERIES_MOVER_SERVLET, null);
    }

    private void updateSearchSource() {
        String string = this.getConfigKey(PATIENT_SEARCHABLE_SOURCE_SECTION, SEARCHABLE_SOURCE_TYPE, null);
        this.mDicomSearchAvailable = DICOM_SEARCHABLE_SOURCE_TYPE.equals(string);
        this.mDicomSourceName = this.getConfigKey(PATIENT_SEARCHABLE_SOURCE_SECTION, DICOM_SOURCE_NAME, "External PACS");
    }

    private void initBackslashPatientIdDelimiter() {
        boolean bl2 = this.getConfigKey(PATIENT_SEARCH_SECTION, BACKSLASH_PATIENT_ID_DELIMITER, false);
        this.mPacsSearchPatientIdDelimiter = SearchConfiguration.getPatientIdDelimiter(bl2);
        GlobalState.trace("Using '" + this.mPacsSearchPatientIdDelimiter + "' as a patient ID delimiter in PACS searches.");
    }

    private void initPatientNameTreatment() {
        PatientNameTreatment patientNameTreatment = PatientNameTreatment.DICOM_COMMA;
        String string = this.getConfigKey(PATIENT_SEARCH_SECTION, PATIENT_NAME_TREATMENT, null);
        this.mPatientNameTreatment = PatientNameTreatment.getInstance(string);
        if (this.mPatientNameTreatment == null) {
            GlobalState.warning("Did not find key patientNameTreatment in [PATIENT_SEARCH], or the value is invalid.  Will use default.");
            this.mPatientNameTreatment = patientNameTreatment;
        }
        GlobalState.trace("Using patient name treatment: " + this.mPatientNameTreatment.getName());
    }

    public ControlFile getControlFile() {
        return this.mControlFile;
    }
}

