/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import PatientSearchLibrary.Data.BasicData;
import PatientSearchLibrary.Data.Series;
import PatientSearchLibrary.Data.Status;
import PatientSearchLibrary.Data.Study;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Gui.RelatedSeriesWorker;
import PatientSearchLibrary.Gui.ResultPane;
import PatientSearchLibrary.Gui.ResultTable;
import PatientSearchLibrary.Gui.ResultTableModel;
import PatientSearchLibrary.Gui.RetrievalHandler;
import PatientSearchLibrary.Gui.SearchSession;
import PatientSearchLibrary.Gui.ViewWorker;
import PatientSearchLibrary.Retrieve.Retriever;
import PatientSearchLibrary.View.LoadRequestType;
import PatientSearchLibrary.View.SeriesViewer;
import PatientSearchLibrary.View.ViewSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StudyRetrieveStatus
extends JFrame
implements ActionListener,
RetrievalHandler {
    public static final String ACTION_CANCEL = "CANCEL";
    private SearchSession mSession;
    private JButton mViewButton;
    private JButton mCancelButton;
    private JLabel mLabel;
    private ViewSetTable mViewSetTable;
    private JProgressBar mProgress;
    private ViewSet mViewSet;
    private Retriever mRetriever;
    private SeriesViewer mSeriesViewer;
    private boolean mFinishedRetrieving;

    public StudyRetrieveStatus(String string, SearchSession searchSession, ViewSet viewSet, Retriever retriever, SeriesViewer seriesViewer) {
        super(string);
        this.mSession = searchSession;
        this.mViewSet = viewSet;
        this.mRetriever = retriever;
        this.mSeriesViewer = seriesViewer;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler(this));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.createControlPane(jPanel);
        this.createViewSetPane(jPanel);
        this.setContentPane(jPanel);
        this.pack();
        this.setExtendedState(1);
    }

    public Map getDefaultColumns(boolean bl2) {
        if (bl2) {
            return ResultPane.getSeriesColumns(this.mSession.getSiteConfiguration().getSeriesDisplayFieldMap());
        }
        return ResultPane.getStudyColumns(this.mSession.getSiteConfiguration().getStudyDisplayFieldMap());
    }

    private void createViewSetPane(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.mLabel = new JLabel("Please wait while retrieving images from archive");
        Map map = this.getDefaultColumns(this.mViewSet.isSeriesSelected());
        ViewSetTableModel viewSetTableModel = new ViewSetTableModel(this.mViewSet.getSelectedStudiesOrSeries(), map);
        this.mViewSetTable = new ViewSetTable(viewSetTableModel, this.createMenu(), this.mViewSet.isSeriesSelected());
        this.mViewSetTable.addMouseListener(new ViewSetTableMouseAdapter(this.mViewSetTable));
        this.mViewSetTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                StudyRetrieveStatus.this.updateViewButtonState();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.mViewSetTable);
        jScrollPane.setPreferredSize(new Dimension(600, 200));
        jScrollPane.getViewport().setBackground(Color.LIGHT_GRAY);
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(Color.ORANGE, Color.BLACK), " " + this.mViewSet.getTitle() + " ");
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.BLUE);
        jScrollPane.setBorder(titledBorder);
        this.mProgress = new JProgressBar();
        this.mProgress.setSize(400, 25);
        this.mProgress.setEnabled(true);
        this.mProgress.setStringPainted(true);
        this.mProgress.setBorderPainted(true);
        this.mProgress.setMaximum(this.mViewSet.getOfflineElementsCount());
        jPanel2.add("North", this.mLabel);
        jPanel2.add("Center", jScrollPane);
        jPanel2.add("South", this.mProgress);
        jPanel.add("Center", jPanel2);
    }

    private JPopupMenu createMenu() {
        String string = this.mViewSet.isSeriesSelected() ? "Series menu" : "Study menu";
        JPopupMenu jPopupMenu = new JPopupMenu(string);
        String string2 = this.mViewSet.isSeriesSelected() ? "View selected series" : "View selected studies";
        String string3 = this.mViewSet.isSeriesSelected() ? "VIEW_SERIES" : "VIEW_STUDIES";
        JMenuItem jMenuItem = new JMenuItem(string2, GlobalState.getImageIcon("/PatientSearchLibrary/Gui/Icons/view.png", 16, 16));
        jMenuItem.setActionCommand(string3);
        jMenuItem.addActionListener(this);
        String string4 = this.mViewSet.isSeriesSelected() ? "View selected series in new window" : "View selected studies in new window";
        String string5 = this.mViewSet.isSeriesSelected() ? "VIEW_SERIES_IN_NEW_WINDOW" : "VIEW_STUDIES_IN_NEW_WINDOW";
        JMenuItem jMenuItem2 = new JMenuItem(string4, ResultPane.NULL_ICON);
        jMenuItem2.setActionCommand(string5);
        jMenuItem2.addActionListener(this);
        String string6 = this.mViewSet.isSeriesSelected() ? "Add selected series" : "Add selected studies";
        String string7 = this.mViewSet.isSeriesSelected() ? "ADD_SERIES" : "ADD_STUDIES";
        JMenuItem jMenuItem3 = new JMenuItem(string6, ResultPane.NULL_ICON);
        jMenuItem3.setActionCommand(string7);
        jMenuItem3.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem3);
        return jPopupMenu;
    }

    private void updateViewButtonState() {
        if (!this.mFinishedRetrieving) {
            this.mViewButton.setEnabled(this.mViewSetTable.getSelectedRowCount() > 0 && this.mViewSetTable.isAllSelectedDataOnline());
        }
    }

    private void createControlPane(JPanel jPanel) {
        Box box = new Box(0);
        box.setBorder(new EmptyBorder(8, 8, 8, 8));
        box.add(Box.createGlue());
        this.mViewButton = new JButton("View");
        this.mViewButton.addActionListener(this);
        this.mViewButton.setActionCommand(this.mViewSet.isSeriesSelected() ? "VIEW_SERIES" : "VIEW_STUDIES");
        this.mViewButton.setEnabled(false);
        this.getRootPane().setDefaultButton(this.mViewButton);
        this.mCancelButton = new JButton("Cancel");
        this.mCancelButton.setActionCommand(ACTION_CANCEL);
        this.mCancelButton.addActionListener(this);
        box.add(this.mViewButton);
        box.add(Box.createGlue());
        box.add(this.mCancelButton);
        box.add(Box.createGlue());
        jPanel.add("South", box);
    }

    private void view(LoadRequestType loadRequestType) {
        ViewSet viewSet = this.getViewSetForSelectedRows();
        ViewWorker viewWorker = new ViewWorker(this.mSession, this, viewSet, this.mSeriesViewer, loadRequestType, this.mRetriever, this);
        RelatedSeriesWorker relatedSeriesWorker = new RelatedSeriesWorker(this.mSession, this.getViewSetForSelectedRows(), this.mSeriesViewer, viewWorker);
        viewWorker.start();
        relatedSeriesWorker.start();
        if (this.mFinishedRetrieving) {
            this.dispose();
        }
    }

    private void cancel() {
        Set set = this.mViewSet.getOfflineStudies();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.mRetriever.cancelStudyRetrieval((Study)iterator.next());
        }
        this.mRetriever.unregisterRetrievalHandler(this);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACTION_CANCEL)) {
            this.cancel();
        } else if (string.equals("VIEW_STUDIES") || string.equals("VIEW_SERIES")) {
            this.view(LoadRequestType.LOAD_IN_CURRENT);
        } else if (string.equals("VIEW_STUDIES_IN_NEW_WINDOW") || string.equals("VIEW_SERIES_IN_NEW_WINDOW")) {
            this.view(LoadRequestType.LOAD_IN_NEW);
        } else if (string.equals("ADD_STUDIES") || string.equals("ADD_SERIES")) {
            this.view(LoadRequestType.ADD_TO_CURRENT);
        } else {
            GlobalState.error("Unsupported action [" + string + "] in StudyRetrieveStatus.actionPerformed");
        }
    }

    public boolean isUserCancellable() {
        return true;
    }

    public void updateRetrievalStatus() {
        Runnable runnable = new Runnable(){

            public void run() {
                StudyRetrieveStatus.this.updateStatus();
            }
        };
        EventQueue.invokeLater(runnable);
    }

    private void updateStatus() {
        ViewSetTableModel viewSetTableModel = (ViewSetTableModel)this.mViewSetTable.getModel();
        viewSetTableModel.fireTableColumnUpdated(0);
        int n2 = this.mViewSet.getOfflineElementsCount();
        this.mProgress.setValue(this.mProgress.getMaximum() - n2);
        if (n2 == 0) {
            this.mFinishedRetrieving = true;
            this.mRetriever.unregisterRetrievalHandler(this);
            this.mLabel.setText("Images are available for viewing");
            this.setTitle("Images are available for viewing");
            int n3 = this.mViewSetTable.getModel().getRowCount() - 1;
            this.mViewSetTable.getSelectionModel().addSelectionInterval(0, n3);
            this.mViewButton.setEnabled(true);
            if (!this.isVisible()) {
                this.setVisible(true);
                this.setExtendedState(1);
            }
            Alerter alerter = new Alerter(this);
            alerter.start();
        }
    }

    private List getSelectedSeries() {
        ViewSetTableModel viewSetTableModel = (ViewSetTableModel)this.mViewSetTable.getModel();
        ArrayList<Series> arrayList = new ArrayList<Series>();
        if (this.mViewSet.isSeriesSelected()) {
            int[] nArray = this.mViewSetTable.getSelectedRows();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                Series series = (Series)viewSetTableModel.getStudyOrSeries(nArray[i2]);
                arrayList.add(series);
            }
        } else {
            int[] nArray = this.mViewSetTable.getSelectedRows();
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                Study study = (Study)viewSetTableModel.getStudyOrSeries(nArray[i3]);
                arrayList.addAll(study.getSeriesMap().values());
            }
        }
        return arrayList;
    }

    private ViewSet getViewSetForSelectedRows() {
        if (this.mViewSet.isSeriesSelected()) {
            return new ViewSet(this.getSelectedSeries());
        }
        ViewSetTableModel viewSetTableModel = (ViewSetTableModel)this.mViewSetTable.getModel();
        ArrayList<Study> arrayList = new ArrayList<Study>();
        int[] nArray = this.mViewSetTable.getSelectedRows();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Study study = (Study)viewSetTableModel.getStudyOrSeries(nArray[i2]);
            arrayList.add(study);
        }
        return new ViewSet(arrayList);
    }

    class ViewSetTableMouseAdapter
    extends ResultTable.MouseAdapter {
        ViewSetTableMouseAdapter(ViewSetTable viewSetTable) {
            super(viewSetTable);
        }

        protected void mouseDoubleClicked() {
            if (((ViewSetTable)this.mTable).isAllSelectedDataOnline()) {
                StudyRetrieveStatus.this.view(LoadRequestType.LOAD_IN_CURRENT);
            }
        }
    }

    class Alerter
    extends Timer {
        Alerter(StudyRetrieveStatus studyRetrieveStatus2) {
            super(500, null);
            AlertActionListener alertActionListener = new AlertActionListener(studyRetrieveStatus2, this);
            this.addActionListener(alertActionListener);
        }

        class AlertActionListener
        implements ActionListener {
            private JFrame mFrame;
            private Timer mTimer;
            private boolean mFlashing;
            private String mFlashingTitle;
            private String mDefaultTitle;

            AlertActionListener(JFrame jFrame, Timer timer) {
                this.mFrame = jFrame;
                this.mTimer = timer;
                this.mFlashingTitle = "";
                this.mDefaultTitle = this.mFrame.getTitle();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.mFrame.getExtendedState() == 1 || !this.mFrame.isFocused()) {
                    if (this.mFlashing) {
                        this.mFrame.setTitle(this.mFlashingTitle);
                    } else {
                        this.mFrame.setTitle(this.mDefaultTitle);
                    }
                    this.mFlashing = !this.mFlashing;
                } else if (this.mTimer != null) {
                    this.mFrame.setTitle(this.mDefaultTitle);
                    this.mTimer.stop();
                }
            }
        }
    }

    class WindowHandler
    extends WindowAdapter {
        StudyRetrieveStatus mWindow;

        public WindowHandler(StudyRetrieveStatus studyRetrieveStatus2) {
            this.mWindow = studyRetrieveStatus2;
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (!StudyRetrieveStatus.this.mFinishedRetrieving) {
                this.mWindow.setVisible(false);
            } else {
                StudyRetrieveStatus.this.dispose();
            }
        }
    }

    class ViewSetTableModel
    extends ResultTableModel {
        ViewSetTableModel(List list, Map map) {
            super(list, map);
        }

        public Object getStudyOrSeries(int n2) {
            return this.mData.get(n2);
        }

        protected void setInitialSortingOrder() {
            if (StudyRetrieveStatus.this.mViewSet.isSeriesSelected()) {
                this.mPrimarySortColumn = "PName";
                this.mPrimarySortAscending = true;
                this.mSecondarySortColumn = "SerDate";
                this.mSecondarySortAscending = true;
                this.mTertiarySortColumn = "SerNum";
                this.mTertiarySortAscending = true;
            } else {
                this.mPrimarySortColumn = "PName";
                this.mPrimarySortAscending = true;
                this.mSecondarySortColumn = "StuDate";
                this.mSecondarySortAscending = true;
                this.mTertiarySortColumn = null;
                this.mTertiarySortAscending = true;
            }
        }
    }

    class ViewSetTable
    extends ResultTable {
        private boolean mSeriesSelected;

        ViewSetTable(ViewSetTableModel viewSetTableModel, JPopupMenu jPopupMenu, boolean bl2) {
            super(viewSetTableModel, jPopupMenu);
            this.mSeriesSelected = bl2;
        }

        public boolean isMenuEnabled() {
            return this.getSelectedRowCount() > 0 && this.isAllSelectedDataOnline();
        }

        public boolean isAllSelectedDataOnline() {
            ViewSetTableModel viewSetTableModel = (ViewSetTableModel)this.getModel();
            boolean bl2 = true;
            int[] nArray = this.getSelectedRows();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                Status status;
                BasicData basicData;
                if (this.mSeriesSelected) {
                    basicData = (Series)viewSetTableModel.getStudyOrSeries(nArray[i2]);
                    status = (Status)basicData.getValue("Status");
                    if (status == Status.ONLINE) continue;
                    bl2 = false;
                    break;
                }
                basicData = (Study)viewSetTableModel.getStudyOrSeries(nArray[i2]);
                status = (Status)basicData.getValue("Status");
                if (status == Status.ONLINE) continue;
                bl2 = false;
                break;
            }
            return bl2;
        }
    }
}

