/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import GuiUtilities.Layouts.ParagraphLayout;
import GuiUtilities.Util.GuiUtilities;
import PatientSearchLibrary.Gui.PatientSearchPane;
import PatientSearchLibrary.Gui.SearchFieldUi;
import PatientSearchLibrary.Gui.SearchView;
import PatientSearchLibrary.Search.SearchSpecification;
import java.awt.Component;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SimpleSearchView
extends SearchView {
    protected static LinkedHashMap mSimpleDateFilterOptions = new LinkedHashMap();

    public SimpleSearchView(JFrame jFrame, PatientSearchPane patientSearchPane) {
        super(jFrame, patientSearchPane);
    }

    protected boolean isComparatorUsed() {
        return false;
    }

    protected void initUsedSearchFields() {
        SearchFieldUi searchFieldUi = this.getSearchField(this.mPatientSearchPane.getSession().getPreferredSearchFieldKey1());
        SearchFieldUi searchFieldUi2 = this.getSearchField(this.mPatientSearchPane.getSession().getPreferredSearchFieldKey2());
        if (searchFieldUi == null || searchFieldUi2 == null) {
            searchFieldUi = this.getDefaultSearchField1();
            searchFieldUi2 = this.getDefaultSearchField2();
        }
        this.mUsedSearchFields.add(searchFieldUi);
        this.mUsedSearchFields.add(searchFieldUi2);
    }

    protected void createDateFilterPanel() {
        Serializable serializable;
        this.mDateFilterPanel = new JPanel();
        this.mDateFilterPanel.setLayout(new ParagraphLayout());
        if (this.mSiteConfig.isDicomSearchAvailable()) {
            serializable = new JLabel("     ");
            this.mSearchExternalPacs = new JCheckBox("Search " + this.mSiteConfig.getDicomSourceName());
            this.mDateFilterPanel.add((Component)serializable, ParagraphLayout.NEW_PARAGRAPH);
            this.mDateFilterPanel.add(this.mSearchExternalPacs);
        }
        if (this.mPatientSearchPane.getSession().useSiteCodes()) {
            this.mSiteFilterLabel = new JLabel("Site :");
            serializable = new Vector();
            ((Vector)serializable).addAll(this.mPatientSearchPane.getSession().getSiteCodes());
            ((Vector)serializable).add(0, "All");
            this.mSiteFilterComboBox = new JComboBox(serializable);
            this.mDateFilterPanel.add((Component)this.mSiteFilterLabel, ParagraphLayout.NEW_PARAGRAPH);
            this.mDateFilterPanel.add(this.mSiteFilterComboBox);
        }
        this.mDateFilterLabel = new JLabel("Date :");
        this.mDateFilterComboBox = new JComboBox<String>(mSimpleDateFilterOptions.keySet().toArray(new String[0]));
        this.mDateFilterPanel.add((Component)this.mDateFilterLabel, ParagraphLayout.NEW_PARAGRAPH);
        this.mDateFilterPanel.add(this.mDateFilterComboBox);
        this.add(this.mDateFilterPanel);
    }

    protected boolean verifySearchOptions() {
        return true;
    }

    public SearchSpecification getSearchSpecification() {
        SearchSpecification searchSpecification = new SearchSpecification();
        List list = this.mModalityPanel.getCheckBoxes();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            JCheckBox jCheckBox = (JCheckBox)list.get(i2);
            if (!jCheckBox.isSelected()) continue;
            searchSpecification.addModality(jCheckBox.getText());
        }
        this.updateSearchSpecificationWithSearchFields(searchSpecification);
        if (this.mSiteConfig.isDicomSearchAvailable() && this.mSearchExternalPacs != null) {
            searchSpecification.setSearchDicomSource(this.mSearchExternalPacs.isSelected());
        }
        if (this.mPatientSearchPane.getSession().useSiteCodes() && this.mSiteFilterComboBox != null) {
            String string = (String)this.mSiteFilterComboBox.getSelectedItem();
            if (string.equals("All")) {
                string = "";
            }
            searchSpecification.setSiteCode(string);
        }
        searchSpecification.setDateSelection((Integer)mSimpleDateFilterOptions.get(this.mDateFilterComboBox.getSelectedItem()));
        return searchSpecification;
    }

    static {
        mSimpleDateFilterOptions.put(GuiUtilities.getHtmlLabel("All dates", "/PatientSearchLibrary/Gui/Icons/date.png"), new Integer(-1));
        mSimpleDateFilterOptions.put(GuiUtilities.getHtmlLabel("Today", "/PatientSearchLibrary/Gui/Icons/date.png"), new Integer(0));
        mSimpleDateFilterOptions.put(GuiUtilities.getHtmlLabel("Yesterday", "/PatientSearchLibrary/Gui/Icons/date.png"), new Integer(1));
        mSimpleDateFilterOptions.put(GuiUtilities.getHtmlLabel("Last 2 days", "/PatientSearchLibrary/Gui/Icons/date.png"), new Integer(2));
        mSimpleDateFilterOptions.put(GuiUtilities.getHtmlLabel("Last 7 days", "/PatientSearchLibrary/Gui/Icons/date.png"), new Integer(7));
        mSimpleDateFilterOptions.put(GuiUtilities.getHtmlLabel("Last 31 days", "/PatientSearchLibrary/Gui/Icons/date.png"), new Integer(31));
    }
}

