/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import PatientSearchLibrary.Data.BasicData;
import PatientSearchLibrary.Data.DataComparator;
import com.intelerad.table.lib.TableColumnProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;

abstract class ResultTableModel
extends DefaultTableModel {
    protected List mData;
    private List mColumnKeys;
    private List mColumnNames;
    private List mColumnWidths;
    protected String mPrimarySortColumn;
    protected String mSecondarySortColumn;
    protected String mTertiarySortColumn;
    protected boolean mPrimarySortAscending = false;
    protected boolean mSecondarySortAscending = false;
    protected boolean mTertiarySortAscending = false;

    public ResultTableModel(List list, Map map) {
        super(list.size(), map.size());
        this.mData = list;
        this.mColumnKeys = new ArrayList();
        this.mColumnNames = new ArrayList();
        this.mColumnWidths = new ArrayList();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            TableColumnProperties tableColumnProperties = (TableColumnProperties)map.get(iterator.next());
            this.mColumnKeys.add(tableColumnProperties.getKey());
            this.mColumnNames.add(tableColumnProperties.getFieldName());
            this.mColumnWidths.add(new Integer(tableColumnProperties.getColumnWidth()));
        }
    }

    public boolean isCellEditable(int n2, int n3) {
        return false;
    }

    public Object getValueAt(int n2, int n3) {
        String string = this.getColumnKey(n3);
        BasicData basicData = (BasicData)this.mData.get(n2);
        return basicData.getValue(string);
    }

    public String getColumnName(int n2) {
        return (String)this.mColumnNames.get(n2);
    }

    public String getColumnKey(int n2) {
        return (String)this.mColumnKeys.get(n2);
    }

    public int getColumnWidth(int n2) {
        return (Integer)this.mColumnWidths.get(n2);
    }

    public int getRowCount() {
        if (this.mData == null) {
            return 0;
        }
        return this.mData.size();
    }

    public void clearData() {
        this.mData.clear();
    }

    protected void reSort() {
        if (this.mPrimarySortColumn == null) {
            this.setInitialSortingOrder();
        }
        TreeSet treeSet = new TreeSet(new DataComparator(this.mPrimarySortColumn, this.mPrimarySortAscending, this.mSecondarySortColumn, this.mSecondarySortAscending, this.mTertiarySortColumn, this.mTertiarySortAscending));
        treeSet.addAll(this.mData);
        this.mData.clear();
        this.mData.addAll(treeSet);
    }

    public void sortByColumn(int n2) {
        this.updateSortingOrder(this.getColumnKey(n2));
        TreeSet treeSet = new TreeSet(new DataComparator(this.mPrimarySortColumn, this.mPrimarySortAscending, this.mSecondarySortColumn, this.mSecondarySortAscending, this.mTertiarySortColumn, this.mTertiarySortAscending));
        treeSet.addAll(this.mData);
        this.mData.clear();
        this.mData.addAll(treeSet);
    }

    public List getSelectedRows(int[] nArray) {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            arrayList.add(this.mData.get(nArray[i2]));
        }
        return arrayList;
    }

    public int[] getRowIndices(List list) {
        int[] nArray = new int[list.size()];
        Iterator iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            nArray[n2++] = this.mData.indexOf(iterator.next());
        }
        return nArray;
    }

    private void updateSortingOrder(String string) {
        if (this.mPrimarySortColumn == null) {
            this.mPrimarySortColumn = string;
            this.mPrimarySortAscending = true;
        } else if (string.equals(this.mPrimarySortColumn)) {
            this.mPrimarySortAscending = !this.mPrimarySortAscending;
        } else {
            this.mTertiarySortColumn = this.mSecondarySortColumn;
            this.mSecondarySortColumn = this.mPrimarySortColumn;
            this.mTertiarySortAscending = this.mSecondarySortAscending;
            this.mSecondarySortAscending = this.mPrimarySortAscending;
            this.mPrimarySortColumn = string;
            this.mPrimarySortAscending = true;
        }
    }

    public boolean isPrimarySortAscending() {
        return this.mPrimarySortAscending;
    }

    public int getPrimarySortColumnIndex() {
        return this.mColumnKeys.indexOf(this.mPrimarySortColumn);
    }

    public void fireTableColumnUpdated(int n2) {
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            this.fireTableCellUpdated(i2, n2);
        }
    }

    public int getColumnIndexByKey(String string) {
        return this.mColumnKeys.indexOf(string);
    }

    public void updateData(List list, Map map) {
        this.mData.clear();
        this.mData.addAll(list);
        this.mColumnKeys.clear();
        this.mColumnNames.clear();
        this.mColumnWidths.clear();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            TableColumnProperties tableColumnProperties = (TableColumnProperties)map.get(iterator.next());
            this.mColumnKeys.add(tableColumnProperties.getKey());
            this.mColumnNames.add(tableColumnProperties.getFieldName());
            this.mColumnWidths.add(new Integer(tableColumnProperties.getColumnWidth()));
        }
        this.reSort();
    }

    public void selectData(ListSelectionModel listSelectionModel, List list) {
        listSelectionModel.clearSelection();
        int[] nArray = this.getRowIndices(list);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] == -1) continue;
            listSelectionModel.addSelectionInterval(nArray[i2], nArray[i2]);
        }
    }

    protected abstract void setInitialSortingOrder();
}

