/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import GuiUtilities.Table.TableMouseListener;
import PatientSearchLibrary.Data.Status;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Gui.ResultTableModel;
import PatientSearchLibrary.View.ViewSet;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ResultTable
extends JTable {
    private boolean mSortingData;
    private IconHeaderRenderer mIconHeaderRender;
    private IconCellRenderer mIconCellRenderer;
    private JPopupMenu mPopupMenu;

    public ResultTable(ResultTableModel resultTableModel, JPopupMenu jPopupMenu) {
        super(resultTableModel);
        this.mPopupMenu = jPopupMenu;
        this.mIconHeaderRender = new IconHeaderRenderer();
        this.mIconCellRenderer = new IconCellRenderer();
        this.setSelectionMode(2);
        this.getTableHeader().addMouseListener(new TableColumnMouseAdapter(this));
        int n2 = this.getModel().getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.getTableHeader().getColumnModel().getColumn(i2).setHeaderRenderer(this.mIconHeaderRender);
            this.getColumnModel().getColumn(i2).setCellRenderer(this.mIconCellRenderer);
            this.getColumnModel().getColumn(i2).setPreferredWidth(resultTableModel.getColumnWidth(i2));
        }
        this.getTableHeader().setReorderingAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
    }

    public void updateTableHeader() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        ResultTableModel resultTableModel = (ResultTableModel)this.getModel();
        int n2 = resultTableModel.getPrimarySortColumnIndex();
        int n3 = tableColumnModel.getColumnCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            TableColumn tableColumn = tableColumnModel.getColumn(i2);
            Object object = n2 == i2 ? new TextAndIcon(resultTableModel.getColumnName(i2), this.getSortIcon(resultTableModel.isPrimarySortAscending())) : resultTableModel.getColumnName(i2);
            tableColumn.setHeaderValue(object);
        }
        this.getTableHeader().resizeAndRepaint();
    }

    public boolean isSortingData() {
        return this.mSortingData;
    }

    private Icon getSortIcon(boolean bl2) {
        if (bl2) {
            return GlobalState.getImageIcon("/PatientSearchLibrary/Gui/Icons/up.gif");
        }
        return GlobalState.getImageIcon("/PatientSearchLibrary/Gui/Icons/down.gif");
    }

    public JPopupMenu getPopupMenu() {
        return this.mPopupMenu;
    }

    public ViewSet getSelection() {
        ResultTableModel resultTableModel = (ResultTableModel)this.getModel();
        return new ViewSet(resultTableModel.getSelectedRows(this.getSelectedRows()));
    }

    static abstract class MouseAdapter
    extends TableMouseListener {
        protected ResultTable mTable;

        public MouseAdapter(ResultTable resultTable) {
            super(resultTable.getPopupMenu());
            this.mTable = resultTable;
        }
    }

    class IconCellRenderer
    extends DefaultTableCellRenderer {
        IconCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            if (bl2) {
                super.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                super.setForeground(jTable.getForeground());
                super.setBackground(jTable.getBackground());
            }
            this.setFont(jTable.getFont());
            if (object instanceof Status) {
                Status status = (Status)object;
                this.setIcon(status.getIcon());
                this.setText(null);
                String string = status == Status.UNKNOWN ? null : status.toString();
                this.setToolTipText(string);
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(2);
                this.setText(object == null ? "" : object.toString());
                this.setIcon(null);
                this.setToolTipText(null);
            }
            this.setHorizontalTextPosition(10);
            return this;
        }
    }

    class TextAndIcon {
        String mText;
        Icon mIcon;

        TextAndIcon(String string, Icon icon) {
            this.mText = string;
            this.mIcon = icon;
        }
    }

    class IconHeaderRenderer
    extends DefaultTableCellRenderer {
        IconHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            JTableHeader jTableHeader;
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setFont(jTableHeader.getFont());
            }
            if (object instanceof TextAndIcon) {
                this.setIcon(((TextAndIcon)object).mIcon);
                this.setText(((TextAndIcon)object).mText);
            } else {
                this.setText(object == null ? "" : object.toString());
                this.setIcon(null);
            }
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(10);
            return this;
        }
    }

    class TableColumnMouseAdapter
    extends java.awt.event.MouseAdapter {
        private ResultTable mTable;

        TableColumnMouseAdapter(ResultTable resultTable2) {
            this.mTable = resultTable2;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = this.mTable.getColumnModel();
            int n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n3 = this.mTable.convertColumnIndexToModel(n2);
            ResultTableModel resultTableModel = (ResultTableModel)this.mTable.getModel();
            List list = resultTableModel.getSelectedRows(this.mTable.getSelectedRows());
            ResultTable.this.mSortingData = true;
            resultTableModel.sortByColumn(n3);
            resultTableModel.fireTableDataChanged();
            this.mTable.updateTableHeader();
            int[] nArray = resultTableModel.getRowIndices(list);
            this.mTable.getSelectionModel().clearSelection();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this.mTable.getSelectionModel().addSelectionInterval(nArray[i2], nArray[i2]);
            }
            ResultTable.this.mSortingData = false;
        }
    }
}

