/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import DataModels.UserModels.SessionIdProvider;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Gui.SearchSession;
import PatientSearchLibrary.Search.PacsSearchClient;
import PatientSearchLibrary.Search.PacsSeriesMoverClient;
import PatientSearchLibrary.Search.SearchClient;
import PatientSearchLibrary.Search.SeriesMoverClient;
import java.net.MalformedURLException;
import java.net.URL;

public class PacsSearchSession
extends SearchSession {
    private SessionIdProvider mSessionIdProvider;
    private URL mBaseUrl;

    public PacsSearchSession(String string, SessionIdProvider sessionIdProvider, URL uRL) {
        super(string);
        this.mSessionIdProvider = sessionIdProvider;
        this.mBaseUrl = uRL;
    }

    protected PacsSearchSession() {
    }

    public void setUsername(String string) {
        this.mUsername = string;
    }

    public String getSessionId() {
        return this.mSessionIdProvider.getSessionId();
    }

    public URL getBaseUrl() {
        return this.mBaseUrl;
    }

    public void setBaseUrl(URL uRL) {
        this.mBaseUrl = uRL;
    }

    public URL getSearchServletUrl(String string) {
        if (this.getPreferenceProvider() == null) {
            return null;
        }
        String string2 = this.getSiteConfiguration().getSearchServletPath();
        return this.createUrl(string2 + string);
    }

    public URL getSeriesMoverServletUrl(String string) {
        if (this.getPreferenceProvider() == null) {
            return null;
        }
        String string2 = this.getSiteConfiguration().getSeriesMoverServletPath();
        return this.createUrl(string2 + string);
    }

    private URL createUrl(String string) {
        if (this.mBaseUrl == null) {
            return null;
        }
        try {
            return new URL(this.mBaseUrl, string);
        }
        catch (MalformedURLException malformedURLException) {
            GlobalState.error("Error creating URL with suffix '" + string + "' from baseUrl [" + this.mBaseUrl.toString() + "]", malformedURLException);
            return null;
        }
    }

    public SearchClient createSearchClient() {
        return new PacsSearchClient(this);
    }

    public SeriesMoverClient createSeriesMoverClient() {
        return new PacsSeriesMoverClient(this);
    }

    public String getPatientIdDelimiter() {
        return this.getSiteConfiguration().getPacsSearchPatientIdDelimiter();
    }
}

