/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import PatientSearchLibrary.Data.Series;
import PatientSearchLibrary.Data.Study;
import PatientSearchLibrary.Gui.GenericResultPane;
import PatientSearchLibrary.Gui.PatientSearchExtender;
import PatientSearchLibrary.Gui.SearchSession;
import PatientSearchLibrary.View.LoadRequestType;
import PatientSearchLibrary.View.SeriesViewer;
import PatientSearchLibrary.View.ViewSet;
import java.awt.BorderLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;

public class DicomDirResultPane
extends GenericResultPane {
    private final SeriesViewer mSeriesViewer;

    public DicomDirResultPane(SeriesViewer seriesViewer, SearchSession searchSession, PatientSearchExtender patientSearchExtender, Map map, Map map2, boolean bl2) {
        super(searchSession, patientSearchExtender);
        this.mSeriesViewer = seriesViewer;
        this.guiInit(map, map2, bl2);
    }

    private void guiInit(Map map, Map map2, boolean bl2) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.initStudyTable(new ArrayList(), DicomDirResultPane.getStudyColumns(map));
        this.initSeriesTable(DicomDirResultPane.getSeriesColumns(map2));
        this.initSplitPane();
        this.add(this.mSplitPane);
        this.mSplitPane.setDividerSize(15);
        if (!bl2) {
            this.mSplitPane.setDividerLocation((int)this.mSplitPane.getPreferredSize().getHeight());
        }
    }

    protected JPopupMenu createStudyMenu() {
        JPopupMenu jPopupMenu = super.createStudyMenu();
        this.extendMenu(PatientSearchExtender.PatientMenuType.STUDY_EXTRAS, jPopupMenu);
        return jPopupMenu;
    }

    protected JPopupMenu createSeriesMenu(ActionListener actionListener) {
        JPopupMenu jPopupMenu = super.createSeriesMenu(actionListener);
        this.extendMenu(PatientSearchExtender.PatientMenuType.SERIES_EXTRAS, jPopupMenu);
        return jPopupMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void viewData(ViewSet viewSet, LoadRequestType loadRequestType) {
        List list = viewSet.getSelectedSeries();
        List list2 = this.findRelatedSeries(list);
        if (list != null) {
            this.mSeriesViewer.loadSeries(list, loadRequestType);
            this.mSeriesViewer.setRelatedSeries(list2);
        } else {
            this.mSeriesViewer.showError("Nothing to load");
        }
    }

    private List findRelatedSeries(List list) {
        GenericResultPane.StudyTableModel studyTableModel = (GenericResultPane.StudyTableModel)this.mStudyTable.getModel();
        List list2 = studyTableModel.getAllStudies();
        HashSet<String> hashSet = new HashSet<String>();
        Object object = list.iterator();
        while (object.hasNext()) {
            hashSet.add(((Series)object.next()).getPatientId());
        }
        object = new ArrayList();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Study study = (Study)iterator.next();
            if (!hashSet.contains(study.getPatientId())) continue;
            object.addAll(study.getSeriesList());
        }
        return object;
    }
}

