/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import GuiUtilities.Util.GuiUtilities;
import GuiUtilities.Worker.Worker;
import GuiUtilities.Worker.WorkerController;
import PatientSearchLibrary.Gui.DicomDirResultPane;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Gui.PatientSearchExtender;
import PatientSearchLibrary.Gui.SearchSession;
import PatientSearchLibrary.Search.SearchClient;
import PatientSearchLibrary.View.SeriesViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class CdPatientLoadPane
extends JPanel {
    private DicomDirResultPane mResultPane;
    private SearchSession mSearchSession;
    private SeriesViewer mSeriesViewer;
    private JDialog mHelpDialog;

    public CdPatientLoadPane(PatientSearchExtender patientSearchExtender, SearchSession searchSession, SeriesViewer seriesViewer, boolean bl2) {
        this(patientSearchExtender, searchSession, seriesViewer, bl2, null);
    }

    public CdPatientLoadPane(PatientSearchExtender patientSearchExtender, SearchSession searchSession, SeriesViewer seriesViewer, boolean bl2, Component component) {
        this.mSeriesViewer = seriesViewer;
        this.mSearchSession = searchSession;
        this.guiInit(patientSearchExtender, bl2, component);
    }

    private void guiInit(PatientSearchExtender patientSearchExtender, boolean bl2, Component component) {
        this.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(GlobalState.getImageIcon("/GuiUtilities/Icons/intelerad-logo-small.jpg"));
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(){

            public void paintComponent(Graphics graphics) {
                Color color = new Color(38, 75, 119);
                graphics.setColor(color);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                Color color2 = new Color(0, 43, 94);
                graphics.setColor(color2);
                graphics.fillRect(0, 0, this.getWidth(), 30);
                graphics.fillRect(0, 118, this.getWidth(), 32);
            }
        };
        jPanel2.setLayout(null);
        JButton jButton = new JButton("Help");
        jButton.setOpaque(false);
        jButton.setForeground(Color.white);
        jButton.setFocusable(false);
        jButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        jButton.setIcon(GlobalState.getImageIcon("/GuiUtilities/Icons/help-16.png"));
        jButton.setSize(new Dimension(75, 30));
        jButton.setLocation(0, 0);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CdPatientLoadPane.this.showInstructionsDialog();
            }
        });
        jPanel2.add(jButton);
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.add("Center", jPanel2);
        jPanel.add("East", jLabel);
        this.add("North", component == null ? jPanel : component);
        this.mResultPane = new DicomDirResultPane(this.mSeriesViewer, this.mSearchSession, patientSearchExtender, this.mSearchSession.getSiteConfiguration().getStudyDisplayFieldMap(), this.mSearchSession.getSiteConfiguration().getSeriesDisplayFieldMap(), bl2);
        this.add("Center", this.mResultPane);
    }

    private void showInstructionsDialog() {
        if (this.mHelpDialog == null) {
            JPanel jPanel = new JPanel();
            jPanel.setBorder(new EmptyBorder(10, 20, 10, 20));
            jPanel.setLayout(new BorderLayout());
            JLabel jLabel = new JLabel(CdPatientLoadPane.buildHtmlInstructions());
            jLabel.setFont(new Font("Arial", 1, 12));
            jPanel.add("Center", jLabel);
            jPanel.setPreferredSize(new Dimension(600, 310));
            this.mHelpDialog = new JDialog((JFrame)SwingUtilities.getWindowAncestor(this), "Help", false);
            this.mHelpDialog.getContentPane().add(jPanel);
            this.mHelpDialog.setResizable(false);
            JButton jButton = new JButton("Close");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (CdPatientLoadPane.this.mHelpDialog != null) {
                        CdPatientLoadPane.this.mHelpDialog.dispose();
                    }
                }
            });
            JPanel jPanel2 = new JPanel();
            jPanel2.add(jButton);
            jPanel.add("South", jPanel2);
            this.mHelpDialog.pack();
            this.mHelpDialog.setVisible(true);
            this.mHelpDialog.setDefaultCloseOperation(1);
            GuiUtilities.centerWindowOnParent(this.mHelpDialog.getParent(), this.mHelpDialog);
        } else {
            this.mHelpDialog.show();
            this.mHelpDialog.toFront();
        }
    }

    public void populate() {
        Worker worker = new Worker(){

            public Object call() throws Exception {
                SearchClient searchClient = CdPatientLoadPane.this.mSearchSession.createSearchClient();
                searchClient.performSearch();
                return searchClient.getSearchResults();
            }

            public void handleCancel() {
            }

            public void handleSuccess(Object object) {
                List list = (List)object;
                CdPatientLoadPane.this.mResultPane.updateData(list, CdPatientLoadPane.this.mSearchSession.getSiteConfiguration().getStudyDisplayFieldMap(), CdPatientLoadPane.this.mSearchSession.getSiteConfiguration().getSeriesDisplayFieldMap());
            }

            public void handleException(Exception exception) {
                exception.printStackTrace();
            }
        };
        WorkerController workerController = new WorkerController(worker);
        workerController.start();
    }

    public static String buildHtmlInstructions() {
        StringBuffer stringBuffer = new StringBuffer("<HTML>");
        stringBuffer.append("<BODY LANG=\"en-US\" DIR=\"LTR\"><P><TT>");
        stringBuffer.append("1. Click a study to select it. The related series appear in the Series list below.");
        stringBuffer.append("<BR><BR>2. To start viewing images, do any of the following:");
        stringBuffer.append("<BR>&nbsp; - Double-click a study or series<BR>&nbsp; - Ctrl+click multiple studies or Shift+click a range, then");
        stringBuffer.append(" right-click and choose View Selected Studies");
        stringBuffer.append("<BR><BR>3. To view images without closing any that are already open, right-click and choose either: ");
        stringBuffer.append("<BR>&nbsp; - View Selected Studies In A New Window: opens selected studies in a new InteleViewer window<BR>&nbsp;");
        stringBuffer.append("- Add Selected Studies: opens selected studies in the existing InteleViewer window</TT></P>");
        stringBuffer.append("</BODY></HTML>");
        return stringBuffer.toString();
    }

    public static Component createEmptyHeader() {
        return Box.createVerticalGlue();
    }
}

