/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol.SeriesHeaderParser;

import J2cProtocol.SeriesHeaderParser.SimpleTagNode;
import J2cProtocol.XmlSeriesHeader;
import J2cProtocol.XmlSeriesHeaderKeys;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SeriesHeaderHandler
extends DefaultHandler
implements XmlSeriesHeaderKeys {
    private static final int MAXIMUM_DEPTH = 10;
    private static final int ROOT_NODE_DEPTH = 2;
    private XmlSeriesHeader mSeriesHeader;
    private SimpleTagNode mCurrentRootNode = null;
    private String[] mCurrentTagPath;
    private int mCurrentDepth;
    private boolean mIsLeafNode;
    private String mCurrentString = null;
    private StringBuffer mCurrentBuffer = null;

    public SeriesHeaderHandler(XmlSeriesHeader xmlSeriesHeader) {
        this.mSeriesHeader = xmlSeriesHeader;
        this.mCurrentTagPath = new String[10];
        this.mCurrentDepth = 0;
        this.mIsLeafNode = false;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.mCurrentDepth;
        if (this.mCurrentDepth > 10) {
            return;
        }
        this.mCurrentTagPath[this.mCurrentDepth - 1] = string3;
        this.mIsLeafNode = true;
        this.mCurrentBuffer = null;
        this.mCurrentString = null;
        if (this.mCurrentDepth == 2) {
            this.setCurrentRootNode();
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.mIsLeafNode && this.mCurrentDepth <= 10) {
            String string4 = this.mCurrentString;
            if (string4 == null && this.mCurrentBuffer != null) {
                string4 = this.mCurrentBuffer.toString();
            }
            this.processTagValue(string4);
        }
        if (this.mCurrentDepth == 2) {
            this.mCurrentRootNode = null;
        }
        --this.mCurrentDepth;
        this.mIsLeafNode = false;
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (this.mCurrentDepth > 10) {
            return;
        }
        if (this.mCurrentBuffer == null && this.mCurrentString == null) {
            this.mCurrentString = new String(cArray, n2, n3);
        } else {
            if (this.mCurrentBuffer == null) {
                this.mCurrentBuffer = new StringBuffer(this.mCurrentString);
                this.mCurrentString = null;
            }
            this.mCurrentBuffer.append(cArray, n2, n3);
        }
    }

    private void setCurrentRootNode() {
        String string = this.mCurrentTagPath[this.mCurrentDepth - 1];
        if (string.equals("IMAGE")) {
            this.mCurrentRootNode = this.mSeriesHeader.addImageNode();
        } else if (string.equals("INTELERAD")) {
            this.mCurrentRootNode = this.mSeriesHeader.getInteleradNode();
        } else if (string.equals("PATIENT")) {
            this.mCurrentRootNode = this.mSeriesHeader.getPatientNode();
        } else if (string.equals("STUDY")) {
            this.mCurrentRootNode = this.mSeriesHeader.getStudyNode();
        } else if (string.equals("SERIES")) {
            this.mCurrentRootNode = this.mSeriesHeader.getSeriesNode();
        } else if (string.equals("ACQUISITION")) {
            this.mCurrentRootNode = this.mSeriesHeader.getAcquisitionNode();
        } else if (string.equals("COMMONIMAGE")) {
            this.mCurrentRootNode = this.mSeriesHeader.getCommonImageNode();
        }
    }

    private void processTagValue(String string) {
        if (this.mCurrentRootNode != null) {
            this.mCurrentRootNode.processTagValue(this.mCurrentTagPath, this.mCurrentDepth, string);
        }
    }
}

