/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol.SeriesHeaderParser;

import J2cProtocol.DisplayShutter;
import J2cProtocol.J2cMissingValueException;
import J2cProtocol.SeriesHeaderParser.ListNode;
import J2cProtocol.SeriesHeaderParser.SimpleTagNode;
import J2cProtocol.XmlSeriesHeader;
import java.util.Vector;

public class DisplayShutterNode
extends SimpleTagNode {
    private ListNode mShapeNode = new ListNode("SHAPE");
    private ListNode mCircleCentre = new ListNode("COORD");
    private ListNode mPolygonalVertices = new ListNode("COORD");

    public DisplayShutterNode() {
        super(4);
    }

    void processTagValue(String[] stringArray, int n2, String string) {
        String string2 = stringArray[n2 - 1];
        String string3 = stringArray[n2 - 2];
        switch (n2) {
            case 4: {
                this.saveSimpleTag(stringArray, n2, string);
                break;
            }
            case 5: {
                if (string3.equals("SHAPE")) {
                    this.mShapeNode.processTagValue(stringArray, n2, string);
                    break;
                }
                if (string3.equals("CENTEROFCIRCULARSHUTTER")) {
                    this.mCircleCentre.processTagValue(stringArray, n2, string);
                    break;
                }
                if (!string3.equals("VERTICESOFPOLYGONALSHUTTER")) break;
                this.mPolygonalVertices.processTagValue(stringArray, n2, string);
            }
        }
    }

    DisplayShutter getImageShutter() throws J2cMissingValueException {
        if (this.mShapeNode.getItems() == null) {
            return null;
        }
        DisplayShutter displayShutter = new DisplayShutter(this.mShapeNode.getItems(), this.getPresentationValue());
        this.setRectangularShutter(displayShutter);
        this.setCircularShutter(displayShutter);
        this.setPolygonalShutter(displayShutter);
        return displayShutter;
    }

    private Integer getPresentationValue() {
        String string = this.getSimpleTag("PRESENTATIONVALUE");
        Integer n2 = null;
        if (string != null) {
            n2 = new Integer(string);
        }
        return n2;
    }

    private void setRectangularShutter(DisplayShutter displayShutter) throws J2cMissingValueException {
        if (!displayShutter.getShutterShapes().contains("RECTANGULAR")) {
            return;
        }
        try {
            int n2 = Integer.parseInt(this.getSimpleTag("LEFTVERTICALEDGE"));
            int n3 = Integer.parseInt(this.getSimpleTag("RIGHTVERTICALEDGE"));
            int n4 = Integer.parseInt(this.getSimpleTag("UPPERHORIZONTALEDGE"));
            int n5 = Integer.parseInt(this.getSimpleTag("LOWERHORIZONTALEDGE"));
            displayShutter.setRectangularShutter(n2, n3, n4, n5);
        }
        catch (NumberFormatException numberFormatException) {
            throw new J2cMissingValueException("Could not parse rectangular shutter parameters" + numberFormatException.toString());
        }
    }

    private void setCircularShutter(DisplayShutter displayShutter) throws J2cMissingValueException {
        if (!displayShutter.getShutterShapes().contains("CIRCULAR")) {
            return;
        }
        try {
            Vector vector = this.mCircleCentre.getItems();
            if (vector == null || vector.size() != 2) {
                throw new J2cMissingValueException("Could not parse circular centre");
            }
            int n2 = Integer.parseInt((String)vector.get(0));
            int n3 = Integer.parseInt((String)vector.get(1));
            int n4 = Integer.parseInt(this.getSimpleTag("RADIUSOFCIRCULARSHUTTER"));
            displayShutter.setCircularShutter(n3, n2, n4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new J2cMissingValueException("Could not parse circular shutter parameters" + numberFormatException.toString());
        }
    }

    private void setPolygonalShutter(DisplayShutter displayShutter) throws J2cMissingValueException {
        if (!displayShutter.getShutterShapes().contains("POLYGONAL")) {
            return;
        }
        displayShutter.setPolygonalShutter(XmlSeriesHeader.getIntVector(this.mPolygonalVertices.getItems()));
    }
}

