/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.J2cProtocolException;
import J2cProtocol.Message;
import J2cProtocol.State;
import J2cProtocol.VariableBlockInputStream;
import J2cProtocol.VariableBlockOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class SeriesHeaderMessage
extends Message {
    private static final int BUFFER_SIZE = 4096;
    private String mSeriesHeader = "";
    private int mCompressedBytes = 0;

    public SeriesHeaderMessage() {
    }

    public SeriesHeaderMessage(String string) {
        this.setSeriesHeader(string);
    }

    public void setSeriesHeader(String string) {
        this.mSeriesHeader = string;
    }

    public String getSeriesHeader() {
        return this.mSeriesHeader;
    }

    public void read(DataInputStream dataInputStream) throws IOException, J2cProtocolException {
        InflaterInputStream inflaterInputStream = new InflaterInputStream(new VariableBlockInputStream(dataInputStream));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n2 = 0;
        do {
            if ((n2 = ((InputStream)inflaterInputStream).read(byArray)) <= 0) continue;
            byteArrayOutputStream.write(byArray, 0, n2);
        } while (n2 > 0);
        ((InputStream)inflaterInputStream).close();
        this.setSeriesHeader(byteArrayOutputStream.toString());
        this.mCompressedBytes = this.estimateCompressedBytes(byteArrayOutputStream.size());
    }

    public void write(DataOutputStream dataOutputStream) throws IOException, J2cProtocolException {
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(new VariableBlockOutputStream(dataOutputStream));
        byte[] byArray = this.getSeriesHeader().getBytes();
        ((OutputStream)deflaterOutputStream).write(byArray);
        ((OutputStream)deflaterOutputStream).close();
        this.mCompressedBytes = this.estimateCompressedBytes(byArray.length);
    }

    private int estimateCompressedBytes(int n2) {
        return n2 / 40 + 2000;
    }

    public int getLength() {
        return this.mCompressedBytes;
    }

    public int getCode() {
        return 3;
    }

    public void validateMessage(State state) throws J2cProtocolException {
        this.validateMessage(state, State.SERIES_HEADER_TRANSFER);
    }
}

