/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.J2cProtocolException;
import J2cProtocol.Message;
import J2cProtocol.State;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ProxyReplyMessage
extends Message {
    public static final int ACCEPTED_STATUS = 1;
    public static final int REJECTED_STATUS = 2;
    private int mStatus = 1;
    private String mDescription = "";

    public ProxyReplyMessage() {
    }

    public ProxyReplyMessage(int n2, String string) {
        this.setStatus(n2);
        this.setDescription(string);
    }

    public void setStatus(int n2) {
        this.mStatus = n2;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public void setDescription(String string) {
        this.mDescription = string;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void read(DataInputStream dataInputStream) throws IOException, J2cProtocolException {
        this.setStatus(dataInputStream.readUnsignedShort());
        this.setDescription(ProxyReplyMessage.readString(dataInputStream));
    }

    public void write(DataOutputStream dataOutputStream) throws IOException, J2cProtocolException {
        dataOutputStream.writeShort(this.getStatus());
        ProxyReplyMessage.writeString(dataOutputStream, this.getDescription());
    }

    public int getLength() {
        return 2 + ProxyReplyMessage.writeStringLength(this.getDescription());
    }

    public int getCode() {
        return 28954;
    }

    public void validateMessage(State state) throws J2cProtocolException {
    }

    public String getStatusString() {
        return ProxyReplyMessage.getStatusString(this.getStatus());
    }

    public static String getStatusString(int n2) {
        switch (n2) {
            case 1: {
                return "accepted";
            }
            case 2: {
                return "rejected";
            }
        }
        return "unknown";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Request for proxy connection ");
        stringBuffer.append(this.getStatusString());
        if (this.getStatus() == 2) {
            stringBuffer.append(": ");
            stringBuffer.append(this.getDescription());
        }
        return stringBuffer.toString();
    }
}

