/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.Association;
import J2cProtocol.J2cProtocolException;
import J2cProtocol.J2cProtocolVersionException;
import J2cProtocol.Message;
import J2cProtocol.State;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DisconnectMessage
extends Message {
    private int mStatus = 0;
    private String mDescription = "";

    public DisconnectMessage() {
    }

    public DisconnectMessage(int n2, String string) {
        this.setStatus(n2);
        this.setDescription(string);
    }

    public void setDescription(String string) {
        this.mDescription = string;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setStatus(int n2) {
        this.mStatus = n2;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public void read(DataInputStream dataInputStream) throws IOException, J2cProtocolException {
        this.setStatus(dataInputStream.readUnsignedShort());
        this.setDescription(Message.readString(dataInputStream));
    }

    public void write(DataOutputStream dataOutputStream) throws IOException, J2cProtocolException {
        dataOutputStream.writeShort(this.getStatus());
        DisconnectMessage.writeString(dataOutputStream, this.getDescription());
    }

    public int getLength() {
        return 2 + DisconnectMessage.writeStringLength(this.getDescription());
    }

    public int getCode() {
        return 10;
    }

    public void validateMessage(State state) throws J2cProtocolException {
    }

    public final void updateAssociationOnInput(Association association) throws J2cProtocolException {
        association.recordDisconnectMessage(this);
        if (this.getStatus() == 4) {
            throw new J2cProtocolVersionException(this.getDescription());
        }
        association.stopServicing();
    }

    public final void updateAssociationOnOutput(Association association) throws J2cProtocolException {
        association.stopServicing();
    }
}

