/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.AbstractSeriesHeader;
import J2cProtocol.DisplayShutter;
import J2cProtocol.ImageId;
import J2cProtocol.J2cMissingValueException;
import J2cProtocol.SeriesHeader;
import RuntimeTool.DebugManager;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.tools.Sequences;
import com.intelerad.lib.dicomtools.DicomObjectCopier;
import com.intelerad.lib.dicomtools.DicomObjectProvider;
import com.intelerad.lib.dicomtools.JdtUtil;
import com.intelerad.lib.dicomtools.PrivateElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;

public class DicomSeriesHeader
extends AbstractSeriesHeader
implements DicomObjectProvider {
    private static final Transformer DICOM_OBJECT_REF_TO_DICOM_OBJECT = new Transformer(){

        public Object transform(Object object) {
            return ((DicomObjectRef)object).mDicomObject;
        }
    };
    private final List mDicomEntryList = new ArrayList();
    private final Map mDicomObjectMap = new HashMap();
    private final boolean mAllowDicomObjectReplace;

    public DicomSeriesHeader(List list) throws DicomException {
        this(list, false);
    }

    public DicomSeriesHeader(List list, boolean bl2) throws DicomException {
        this.mAllowDicomObjectReplace = bl2;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addSopInstanceInternal((DicomObject)iterator.next());
        }
    }

    private final void validateAtrribute(String string, String string2, String string3) {
        if (!string2.equals(string3)) {
            throw new IllegalArgumentException("Cannot add: " + string + " is [" + string3 + "] in SeriesHeader, but [" + string2 + "] in new instance.");
        }
    }

    private final void validateNewInstance(String string, String string2, String string3) throws IllegalArgumentException {
        if (string2 == null) {
            throw new IllegalArgumentException("Cannot add: Series Instance UID is null in new instance.");
        }
        if (this.getNumberOfDicomObjects() == 0) {
            return;
        }
        this.validateAtrribute("Study Instance UID", string3, this.getStudyInstanceUid());
        this.validateAtrribute("Series Instance UID", string2, this.getSeriesInstanceUid());
        if (this.mDicomObjectMap.containsKey(string)) {
            throw new IllegalArgumentException("Cannot add: duplicate SOP Instance UID [" + string + "]");
        }
    }

    public List addSopInstance(DicomObject dicomObject) {
        try {
            return this.addSopInstanceInternal(dicomObject);
        }
        catch (DicomException dicomException) {
            DebugManager.getDefault().printException("Failed to add new SOP instance", dicomException);
            return Collections.EMPTY_LIST;
        }
    }

    private List addSopInstanceInternal(DicomObject dicomObject) throws DicomException {
        String string = dicomObject.getS(63);
        this.validateNewInstance(string, dicomObject.getS(426), dicomObject.getS(425));
        boolean bl2 = DicomSeriesHeader.hasImageData(dicomObject);
        if (!this.mDicomObjectMap.isEmpty()) {
            boolean bl3;
            boolean bl4 = bl3 = !this.mDicomEntryList.isEmpty();
            if (bl2 != bl3) {
                throw new IllegalArgumentException("Cannot mix image and non-image DICOM objects in the same series");
            }
        }
        DicomObjectRef dicomObjectRef = new DicomObjectRef(dicomObject);
        this.mDicomObjectMap.put(string, dicomObjectRef);
        ArrayList<ImageId> arrayList = new ArrayList<ImageId>();
        if (bl2) {
            int n2 = this.getNumberOfFrames(dicomObject);
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(new ImageId(this.mDicomEntryList.size()));
                this.mDicomEntryList.add(new DicomEntry(dicomObjectRef, i2));
            }
        }
        return arrayList;
    }

    public void replaceSopInstance(DicomObject dicomObject) {
        try {
            this.replaceSopInstanceInternal(dicomObject);
        }
        catch (DicomException dicomException) {
            DebugManager.getDefault().printException("Failed to replace SOP instance", dicomException);
        }
    }

    private void replaceSopInstanceInternal(DicomObject dicomObject) throws DicomException {
        String string = dicomObject.getS(63);
        DicomObjectRef dicomObjectRef = (DicomObjectRef)this.mDicomObjectMap.get(string);
        if (dicomObjectRef == null) {
            throw new IllegalArgumentException("Cannot replace: SOP instance UID " + string + " not found");
        }
        DicomObject dicomObject2 = dicomObjectRef.mDicomObject;
        if (DicomSeriesHeader.hasImageData(dicomObject) != DicomSeriesHeader.hasImageData(dicomObject2)) {
            throw new IllegalArgumentException("new instance " + (DicomSeriesHeader.hasImageData(dicomObject) ? "is" : "is not") + " an image, but old instance " + (DicomSeriesHeader.hasImageData(dicomObject2) ? "is" : "is not") + " an image");
        }
        if (this.getNumberOfFrames(dicomObject2) != this.getNumberOfFrames(dicomObject)) {
            throw new IllegalArgumentException("Number of frames changed from " + this.getNumberOfFrames(dicomObject2) + " to " + this.getNumberOfFrames(dicomObject));
        }
        if (this.mAllowDicomObjectReplace) {
            dicomObjectRef.mDicomObject = dicomObject;
        }
    }

    private DicomObject getDicomObjectByImage(int n2) {
        return ((DicomEntry)this.mDicomEntryList.get(n2)).mDicomObjectRef.mDicomObject;
    }

    protected void checkIndex(int n2) {
    }

    public List getDicomObjects() {
        ArrayList arrayList = new ArrayList(this.mDicomObjectMap.values());
        CollectionUtils.transform(arrayList, (Transformer)DICOM_OBJECT_REF_TO_DICOM_OBJECT);
        return arrayList;
    }

    public int getNumberOfDicomObjects() {
        return this.mDicomObjectMap.size();
    }

    public DicomObject getDicomObjectByUid(String string) {
        DicomObjectRef dicomObjectRef = (DicomObjectRef)this.mDicomObjectMap.get(string);
        return dicomObjectRef == null ? null : DicomObjectCopier.copy(dicomObjectRef.mDicomObject);
    }

    public static DicomObject getDicomObjectByUid(List list, String string) {
        if (string == null) {
            return null;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            try {
                DicomObject dicomObject = (DicomObject)list.get(i2);
                if (!string.equals(dicomObject.getS(63))) continue;
                return DicomObjectCopier.copy(dicomObject);
            }
            catch (DicomException dicomException) {
                DebugManager.getDefault().printException("Skipping object " + i2 + ": could not obtain SOP instance UID", dicomException);
            }
        }
        return null;
    }

    public Object getElementValue(int n2, int n3) {
        if (this.mDicomObjectMap.isEmpty()) {
            return null;
        }
        if (n2 == -1) {
            n2 = 0;
        }
        if (n2 == 0 && this.mDicomEntryList.size() == 0) {
            return DicomSeriesHeader.getElementValue(((DicomObjectRef)this.mDicomObjectMap.values().iterator().next()).mDicomObject, n3);
        }
        return DicomSeriesHeader.getElementValue(this.getDicomObjectByImage(n2), n3);
    }

    public static Object getElementValue(DicomObject dicomObject, int n2) {
        if (n2 < 0) {
            return DicomSeriesHeader.getImsPrivateTag(dicomObject, n2);
        }
        if (DicomSeriesHeader.getTagMultiplicity(n2) == SeriesHeader.Multiplicity.SEQUENCE) {
            return DicomSeriesHeader.getSequenceElementValue(dicomObject, n2);
        }
        int n3 = dicomObject.getSize(n2);
        if (n3 <= 0) {
            return null;
        }
        if (!DicomSeriesHeader.isArray(n2)) {
            return dicomObject.get(n2);
        }
        Object[] objectArray = new Object[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            objectArray[i2] = dicomObject.get(n2, i2);
        }
        return objectArray;
    }

    private static Object getSequenceElementValue(DicomObject dicomObject, int n2) {
        Sequences sequences = new Sequences(dicomObject);
        int n3 = DicomSeriesHeader.getSequenceTag(n2);
        try {
            int n4 = dicomObject.getSize(n3);
            if (n4 < 0) {
                return null;
            }
            Object[] objectArray = new Object[n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                objectArray[i2] = sequences.get(n3, i2, n2);
                if (objectArray[i2] != null) continue;
                return null;
            }
            return objectArray;
        }
        catch (DicomException dicomException) {
            return null;
        }
    }

    private static Object getImsPrivateTag(DicomObject dicomObject, int n2) {
        try {
            switch (n2) {
                case -1: {
                    return PrivateElement.getImsSourceAeTitle(dicomObject);
                }
                case -2: {
                    return PrivateElement.getImsInstitution(dicomObject);
                }
            }
            return null;
        }
        catch (DicomException dicomException) {
            return null;
        }
    }

    private static boolean hasImageData(DicomObject dicomObject) {
        try {
            int n2 = dicomObject.getI(466);
            if (n2 <= 0 || n2 == Integer.MAX_VALUE) {
                return false;
            }
            int n3 = dicomObject.getI(467);
            if (n3 <= 0 || n3 == Integer.MAX_VALUE) {
                return false;
            }
        }
        catch (DicomException dicomException) {
            return false;
        }
        return true;
    }

    private int getNumberOfFrames(DicomObject dicomObject) throws DicomException {
        int n2 = dicomObject.getI(464);
        if (n2 <= 0 || n2 == Integer.MAX_VALUE) {
            n2 = 1;
        }
        return n2;
    }

    public int getNumberOfImages() {
        return this.mDicomEntryList.size();
    }

    public int getImageFrameNumber(int n2) {
        return ((DicomEntry)this.mDicomEntryList.get(n2)).mFrameIndex;
    }

    public boolean hasImagePercentile(int n2, String string) {
        try {
            return this.getImagePercentile(n2, string) != Double.MAX_VALUE;
        }
        catch (J2cMissingValueException j2cMissingValueException) {
            return false;
        }
    }

    public double getImagePercentile(int n2, String string) throws J2cMissingValueException {
        DicomObject dicomObject = this.getDicomObjectByImage(n2);
        PrivateElement privateElement = new PrivateElement(JdtUtil.getTransferSyntax(dicomObject), 0);
        try {
            double d2;
            int n3 = this.getPercentileIndex(dicomObject, privateElement, string);
            if (n3 != -1 && (d2 = privateElement.getImsHistogramPercentileValues(dicomObject, n3)) != Double.MAX_VALUE) {
                return d2;
            }
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
        throw new J2cMissingValueException();
    }

    public DisplayShutter getImageDisplayShutter(int n2) {
        return DicomSeriesHeader.getImageDisplayShutter(this.getDicomObjectByImage(n2));
    }

    public static DisplayShutter getImageDisplayShutter(DicomObject dicomObject) {
        return DisplayShutter.createDisplayShutter(dicomObject);
    }

    private int getPercentileIndex(DicomObject dicomObject, PrivateElement privateElement, String string) {
        if (!string.startsWith("P")) {
            throw new IllegalArgumentException("Unknown percentile label: " + string);
        }
        int n2 = Integer.parseInt(string.substring(1));
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        do {
            ++n4;
            try {
                n3 = privateElement.getImsHistogramPercentiles(dicomObject, n4);
                if (n2 == n3) {
                    return n4;
                }
            }
            catch (DicomException dicomException) {
                return -1;
            }
        } while (n3 != Integer.MAX_VALUE);
        return -1;
    }

    private double getDoubleNullImplementation(int n2) throws J2cMissingValueException {
        this.checkIndex(n2);
        throw new J2cMissingValueException();
    }

    public String getImageJ2cFileName(int n2) {
        return "";
    }

    public int getImagePixelValueShift(int n2) {
        Object object = this.getElementValue(n2, 478);
        if (!(object instanceof Integer)) {
            return 0;
        }
        int n3 = (Integer)object;
        object = this.getElementValue(n2, 476);
        if (!(object instanceof Integer)) {
            return 0;
        }
        int n4 = (Integer)object;
        if (n3 == 0) {
            return 0;
        }
        return 1 << n4 - 1;
    }

    public Set getSopInstances() {
        return new HashSet(this.mDicomObjectMap.keySet());
    }

    private static class DicomEntry {
        private final DicomObjectRef mDicomObjectRef;
        private final int mFrameIndex;

        private DicomEntry(DicomObjectRef dicomObjectRef, int n2) {
            this.mDicomObjectRef = dicomObjectRef;
            this.mFrameIndex = n2;
        }
    }

    private static final class DicomObjectRef {
        private DicomObject mDicomObject;

        DicomObjectRef(DicomObject dicomObject) {
            this.mDicomObject = dicomObject;
        }
    }
}

