/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.AnswerableMessage;
import J2cProtocol.Association;
import J2cProtocol.J2cProtocolException;
import J2cProtocol.Message;
import J2cProtocol.State;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ConnectReplyMessage
extends Message
implements AnswerableMessage {
    private int mMajorVersion = 0;
    private int mMinorVersion = 0;
    private int mMaximumBufferLength = 0;

    public ConnectReplyMessage() {
    }

    public ConnectReplyMessage(int n2) {
        this.setMaximumBufferLength(n2);
    }

    public Message createAnswerMessage(Association association) throws J2cProtocolException {
        throw new J2cProtocolException("ConnectReplyMessage must be sub-classed on the client side");
    }

    private void initializeAssociationBuffer(Association association) {
        association.setupBuffers(this.getMaximumBufferLength());
    }

    public final void updateAssociationOnInput(Association association) throws J2cProtocolException {
        association.checkVersionCompatibility(this.getMajorVersionNumber(), this.getMinorVersionNumber());
        this.initializeAssociationBuffer(association);
    }

    public final void updateAssociationOnOutput(Association association) throws J2cProtocolException {
        this.initializeAssociationBuffer(association);
    }

    public int getMajorVersionNumber() {
        return this.mMajorVersion;
    }

    public int getMinorVersionNumber() {
        return this.mMinorVersion;
    }

    public int getMaximumBufferLength() {
        return this.mMaximumBufferLength;
    }

    public void setMaximumBufferLength(int n2) {
        this.mMaximumBufferLength = n2;
    }

    public void read(DataInputStream dataInputStream) throws IOException, J2cProtocolException {
        this.mMajorVersion = dataInputStream.readShort();
        this.mMinorVersion = dataInputStream.readShort();
        this.setMaximumBufferLength(dataInputStream.readInt());
    }

    public void write(DataOutputStream dataOutputStream) throws IOException, J2cProtocolException {
        dataOutputStream.writeShort(this.mMajorVersion);
        dataOutputStream.writeShort(this.mMinorVersion);
        dataOutputStream.writeInt(this.getMaximumBufferLength());
    }

    public int getLength() {
        return 8;
    }

    public int getCode() {
        return 28952;
    }

    public void validateMessage(State state) throws J2cProtocolException {
        this.validateMessage(state, State.ESTABLISHING_CONNECTION);
    }
}

