/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.Association;
import J2cProtocol.DisconnectMessage;
import J2cProtocol.J2cAbruptDisconnectException;
import J2cProtocol.J2cProtocolException;
import J2cProtocol.Message;
import J2cProtocol.MessageFactory;
import J2cProtocol.NoDataToSendMessage;
import J2cProtocol.PauseReplyMessage;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedList;

class AssociationReader
extends Thread {
    private static final long WAIT_TIME = 1000L;
    private static final long READ_WAIT_TIME = 10000L;
    private static final long YIELD_INTERVAL = 100L;
    private static final int HIGH_WATERMARK = 100;
    private static final int LOW_WATERMARK = 50;
    private Association mAssociation;
    private DataInputStream mInput;
    private MessageFactory mMessageFactory;
    private LinkedList mMessageQueue = null;
    private boolean mKeepReading = true;
    private boolean mHasFinished = false;
    private boolean mSuspended = false;
    private volatile boolean mReceivedDisconnect = false;
    private J2cProtocolException mProtocolException = null;
    private boolean mExpectingInput = true;

    AssociationReader(Association association, MessageFactory messageFactory, DataInputStream dataInputStream) {
        super("AssociationReader-" + Thread.currentThread().getName());
        this.mAssociation = association;
        this.mMessageFactory = messageFactory;
        this.mInput = dataInputStream;
        this.mMessageQueue = new LinkedList();
    }

    synchronized void wakeup() {
        this.notifyAll();
    }

    synchronized void suspendReading() {
        this.mSuspended = true;
    }

    synchronized void resumeReading() {
        this.mSuspended = false;
        this.wakeup();
    }

    synchronized Message getIncomingMessage() throws J2cProtocolException {
        if (this.mMessageQueue.size() == 0 && !this.mAssociation.haveWorkToDo() && !this.hasFinished()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Message message = null;
        int n2 = this.mMessageQueue.size();
        if (n2 > 0) {
            message = (Message)this.mMessageQueue.getFirst();
            this.mMessageQueue.removeFirst();
            if (!this.mKeepReading && n2 - 1 <= 50) {
                this.debug("Enabling reading at size " + this.mMessageQueue.size());
                this.mKeepReading = true;
                this.wakeup();
            }
        }
        if (message == null && this.hasFinished()) {
            if (this.mProtocolException == null) {
                this.mProtocolException = new J2cAbruptDisconnectException("Reached end of input");
            }
            throw this.mProtocolException;
        }
        return message;
    }

    private synchronized void putIncomingMessage(Message message) {
        while ((this.mSuspended || !this.mKeepReading) && this.mAssociation.isActive()) {
            try {
                this.wait(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.mMessageQueue.addLast(message);
        int n2 = this.mMessageQueue.size();
        if (this.mKeepReading && n2 >= 100) {
            this.debug("Disabling reading at size " + n2);
            this.mKeepReading = false;
        }
        if (n2 == 1) {
            this.wakeup();
        }
    }

    synchronized boolean hasIncomingMessage() {
        return this.mMessageQueue.size() > 0;
    }

    synchronized int numberOfMessagesInQueue() {
        return this.mMessageQueue.size();
    }

    synchronized void waitForShutdown() {
        try {
            this.getIncomingMessage();
        }
        catch (J2cProtocolException j2cProtocolException) {
            // empty catch block
        }
        if (!this.hasFinished()) {
            try {
                this.trace("Waiting for read thread to finish");
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private Message readMessage() throws J2cProtocolException {
        this.mAssociation.getReadStopWatch().start();
        try {
            Message message;
            int n2 = this.readMessageCode(this.mExpectingInput);
            try {
                message = this.mMessageFactory.createMessage(n2, this.mAssociation.getInputBuffer());
            }
            catch (J2cProtocolException j2cProtocolException) {
                J2cProtocolException j2cProtocolException2 = new J2cProtocolException(j2cProtocolException.getMessage() + " received while reading from input stream.");
                j2cProtocolException2.setStackTrace(j2cProtocolException.getStackTrace());
                throw j2cProtocolException2;
            }
            message.read(this.mInput);
            this.mAssociation.incrementBytesRead(2 + message.getLength());
            this.mExpectingInput = !this.isStopStreamingMessage(message);
            Message message2 = message;
            return message2;
        }
        catch (IOException iOException) {
            throw new J2cAbruptDisconnectException("Connection lost (" + iOException.toString() + ")", iOException);
        }
        finally {
            this.mAssociation.getReadStopWatch().stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readMessageCode(boolean bl2) throws IOException {
        if (!bl2) {
            this.mAssociation.getPauseStopWatch().start();
        }
        try {
            int n2 = this.mInput.readUnsignedShort();
            return n2;
        }
        finally {
            if (!bl2) {
                this.mAssociation.getPauseStopWatch().stop();
            }
        }
    }

    private boolean isStopStreamingMessage(Message message) {
        return message instanceof PauseReplyMessage || message instanceof NoDataToSendMessage;
    }

    boolean hasReceivedDisconnect() {
        return this.mReceivedDisconnect;
    }

    private synchronized boolean hasFinished() {
        return this.mHasFinished;
    }

    private synchronized void setFinished(boolean bl2) {
        this.mHasFinished = bl2;
    }

    private void readLoop() {
        boolean bl2 = true;
        long l2 = System.currentTimeMillis() + 100L;
        while (bl2) {
            if (System.currentTimeMillis() >= l2) {
                Thread.yield();
                l2 = System.currentTimeMillis() + 100L;
            }
            try {
                Message message = this.readMessage();
                if (message instanceof DisconnectMessage) {
                    this.mReceivedDisconnect = true;
                }
                if (!this.mAssociation.isServicing()) continue;
                this.putIncomingMessage(message);
            }
            catch (J2cProtocolException j2cProtocolException) {
                bl2 = false;
                this.mProtocolException = j2cProtocolException;
                this.trace("Read loop ending with " + j2cProtocolException.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        AssociationReader associationReader;
        try {
            this.readLoop();
            Object var2_1 = null;
            associationReader = this;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            AssociationReader associationReader2 = this;
            synchronized (associationReader2) {
                this.setFinished(true);
                this.wakeup();
            }
            throw throwable;
        }
        synchronized (associationReader) {
            this.setFinished(true);
            this.wakeup();
        }
    }

    private void debug(String string) {
        this.mAssociation.debug(string);
    }

    private void trace(String string) {
        this.mAssociation.trace(string);
    }
}

