/*
 * Decompiled with CFR 0.152.
 */
package InteleViewer;

import DataModels.DataModel;
import FileUtilities.FileOperations;
import GuiUtilities.Dialog.MultiMonitorOptionDialog;
import InteleViewer.Fz;
import InteleViewer.Hs;
import InteleViewer.IN;
import InteleViewer.nM;
import InteleViewer.nN;
import InteleViewer.nP;
import InteleViewer.nR;
import PatientSearchLibrary.Data.Series;
import RuntimeTool.ControlFile;
import StringUtilities.StringCheck;
import Viewer.Util.CDBurningUtilities;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.intelerad.datamodels.dicom.DicomAttribute;
import com.intelerad.lib.dicomtools.DicomDir;
import com.intelerad.lib.dicomtools.DicomObjectProvider;
import com.intelerad.lib.dicomtools.JdtUtil;
import com.intelerad.systemutilities.lib.SystemUtilities;
import com.intelerad.tools.lib.concurrent.Callable;
import com.intelerad.tools.lib.concurrent.CancellationException;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ly {
    private static final int a = 16;
    private static final List a;
    public static final long a = 26460000L;
    public static final long b = 2352L;

    public static boolean a(File file) throws FileNotFoundException {
        if (file.exists()) {
            File[] fileArray;
            if (!ly.b(file)) {
                ly.a(file);
            }
            return (fileArray = file.listFiles()).length == 0 || ly.a(fileArray);
        }
        if (!FileOperations.createDirectory(file)) {
            throw new FileNotFoundException("Error creating export folder\n" + file.toString());
        }
        if (!ly.b(file)) {
            ly.a(file);
        }
        return true;
    }

    private static boolean a(File[] fileArray) {
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (a.contains(fileArray[i2].getName().toUpperCase())) continue;
            return false;
        }
        return true;
    }

    private static boolean b(File file) {
        return FileOperations.canWriteDirectoryOSSpecific(file) && file.canRead();
    }

    private static void a(File file) throws FileNotFoundException {
        throw new FileNotFoundException("Export folder\n" + file + "\nis not readable and writable.");
    }

    public static DicomDir a(File file) {
        File file2 = new File(file, "DICOMDIR");
        try {
            return DicomDir.readDicomDir(file2);
        }
        catch (Exception exception) {
            Fz.a("Error reading DICOMDIR file " + file2.getAbsolutePath(), exception);
            return null;
        }
    }

    public static void a(Component component, String string, String string2) {
        MultiMonitorOptionDialog.showConfirmDialog(component, string2, string, -1, 0);
    }

    public static Callable a(ControlFile controlFile) {
        return new nM(controlFile);
    }

    public static Callable a(ControlFile controlFile, File file) {
        return new nN(controlFile, file);
    }

    public static boolean a(Component component, File file) {
        String string = file.getAbsolutePath();
        if (ly.b(component, "Erase export folder contents", "Export folder " + string + " not empty.\n" + "Erase contents?", "Erase", false)) {
            while (!FileOperations.removeDirectoryContents(file)) {
                boolean bl2 = ly.b(component, "Error erasing export folder contents", "Unable to erase contents of export folder\n" + string + "\nMake sure that no file or folder\n" + "under the export folder is currently accessed.", "Retry", true);
                if (bl2) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean b(Component component, String string, String string2, String string3, boolean bl2) {
        boolean[] blArray = new boolean[1];
        nP nP2 = new nP(blArray, component, string, string2, string3, bl2);
        if (EventQueue.isDispatchThread()) {
            nP2.run();
        } else {
            try {
                EventQueue.invokeAndWait(nP2);
            }
            catch (Exception exception) {
                Fz.a("Caught exception while waiting for user input", exception);
                return false;
            }
        }
        return blArray[0];
    }

    public static boolean a(Component component, String string, String string2, String string3, boolean bl2) {
        int n2;
        Object[] objectArray = new String[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string3;
        objectArray2[1] = "Cancel";
        int n3 = n2 = bl2 ? 0 : 3;
        return 0 == MultiMonitorOptionDialog.showOptionDialog(component, string2, string, -1, n2, null, objectArray2, objectArray2[0]);
    }

    public static final String a(List list) {
        String string;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            string = ly.a(iterator.next());
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
        }
        int n2 = hashSet.size();
        if (n2 <= 1) {
            string = ly.b(list.get(0));
            string = string.trim().toUpperCase();
            if ((string = string.replaceAll("[^A-Z0-9_]", "_").replaceAll("__*", "_").replaceAll("^_", "").replaceAll("_$", "")).length() > 16) {
                string = string.substring(0, 16);
            }
            return string;
        }
        string = n2 < 100 ? String.valueOf(n2) : "M";
        return simpleDateFormat.format(new Date()) + "_DCM_" + string + "P";
    }

    private static final String a(Object object) {
        if (object instanceof Series) {
            return ((Series)object).getPatientId();
        }
        if (object instanceof DataModel) {
            return (String)((DataModel)object).getProperty(DicomAttribute.PatientID);
        }
        if (object instanceof IN) {
            return ((IN)object).a().a;
        }
        throw new IllegalArgumentException("Object must be a Series or DataModel.");
    }

    private static final String b(Object object) {
        if (object instanceof Series) {
            return ((Series)object).getPatientName();
        }
        if (object instanceof DataModel) {
            return (String)((DataModel)object).getProperty(DicomAttribute.PatientName);
        }
        if (object instanceof IN) {
            return ((IN)object).a().b;
        }
        throw new IllegalArgumentException("Object must be a Series or DataModel.");
    }

    private static long a(DicomObjectProvider dicomObjectProvider, Set set) throws Hs {
        long l2 = 0L;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Throwable throwable;
            String string = (String)iterator.next();
            DicomObject dicomObject = dicomObjectProvider.getDicomObjectByUid(string);
            Throwable throwable2 = null;
            try {
                l2 += JdtUtil.getDicomObjectSizeInBytes(dicomObject, 8193);
            }
            catch (DicomException | IOException throwable3) {
                throwable = throwable3;
                throwable2 = throwable3;
            }
            if (throwable2 == null) continue;
            throwable = new Hs("Error getting size of dicom object for sop instance uid " + string);
            throwable.initCause(throwable2);
            throw throwable;
        }
        return l2;
    }

    public static String a(long l2, long l3) {
        double d2 = (double)l2 / 1000000.0;
        double d3 = (double)l3 / 1000000.0;
        DecimalFormat decimalFormat = new DecimalFormat("#,###.0");
        Fz.c("Not enough disk space for exporting data. Required space: " + decimalFormat.format(l2) + " -- available space: " + decimalFormat.format(l3));
        return "Not enough disk space to export selected series.\nRequired space: " + decimalFormat.format(d2) + " MB\nAvailable space: " + decimalFormat.format(d3) + " MB";
    }

    private static long a(File file, long l2) {
        long l3 = 0L;
        if (file.isFile()) {
            long l4;
            long l5;
            File file2 = file;
            l3 = l5 = file2.length();
            if (l2 > 0L && (l4 = l5 % l2) > 0L) {
                l3 = (l5 / l2 + 1L) * l2;
            }
        } else {
            File file3 = file;
            File[] fileArray = file3.listFiles();
            if (fileArray != null) {
                for (int i2 = 0; i2 < fileArray.length; ++i2) {
                    l3 += ly.a(fileArray[i2], l2);
                }
            }
        }
        return l3;
    }

    private static long a() {
        String string = System.getProperty("java.home");
        Fz.b("Determined Java installation directory: " + string);
        File file = new File(string).getParentFile();
        Fz.b("Determined InteleViewer installation directory: " + file.getAbsolutePath());
        long l2 = SystemUtilities.getClusterSize(file.getAbsolutePath());
        Fz.b("Cluster size: " + l2);
        if (!file.isDirectory() || !file.exists()) {
            throw new IllegalStateException("Unable to determine InteleViewer installation directory");
        }
        return ly.a(file, l2);
    }

    private static boolean a(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return true;
        }
        String[] stringArray = file.list();
        return stringArray == null || stringArray.length <= 0;
    }

    private static String a(File file) {
        if (!CDBurningUtilities.hasMedia() || !CDBurningUtilities.isMediaRecordable()) {
            return "There is no writable CD media in drive " + file;
        }
        if (!ly.a(file.getAbsolutePath())) {
            return "The disc in drive " + file + " already has data on it.\n" + "InteleViewer does not support burning multi-session CDs.";
        }
        return "";
    }

    public static final boolean b(Component component, File file) {
        nR nR2 = new nR(component, file);
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                nR2.run();
            }
            catch (CancellationException cancellationException) {
                return false;
            }
        }
        try {
            SwingUtilities.invokeAndWait(nR2);
        }
        catch (InterruptedException interruptedException) {
            Fz.a("Unexpected interrupted exception", interruptedException);
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            if (invocationTargetException.getTargetException() instanceof CancellationException) {
                return false;
            }
            Fz.a("Unexpected InvocationTargetException", invocationTargetException2);
            return false;
        }
        return true;
    }

    private static final void b(Component component, File file) {
        String string;
        File file2 = file;
        while (!StringCheck.isStringBlank(string = ly.a(file2))) {
            if (!ly.a(component, "Problem with CD", string + "\n\nPlease insert a blank, recordable CD into the drive.", "Retry", false)) {
                throw new CancellationException();
            }
            file2 = file;
        }
    }

    public static void a(Component component, File file) {
        ly.b(component, file);
    }

    static {
        a = Collections.unmodifiableList(Arrays.asList("DESKTOP.INI"));
    }
}

