/*
 * Decompiled with CFR 0.152.
 */
package InteleDicomLibrary.Services;

import InteleDicomLibrary.Services.DicomConnectionParameters;
import InteleDicomLibrary.Services.Scu;
import RuntimeTool.DebugManager;
import StringUtilities.StringCheck;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.DimseUtil;
import java.io.IOException;
import java.net.UnknownHostException;

public class VerifyScu
extends Scu {
    public VerifyScu(DicomConnectionParameters dicomConnectionParameters) {
        this(dicomConnectionParameters.getHost(), dicomConnectionParameters.getPort(), dicomConnectionParameters.getCalledAe(), dicomConnectionParameters.getCallingAe());
    }

    public VerifyScu(String string, int n2, String string2, String string3) {
        super(string, n2, string2, string3);
        this.mDebug = DebugManager.getDefault();
    }

    public boolean ping() {
        return StringCheck.isStringBlank(this.pingWithMessage());
    }

    public String pingWithMessage() {
        String string = null;
        try {
            string = this.associate();
        }
        catch (UnknownHostException unknownHostException) {
            return this.logException("Invalid hostname: " + this.mHost + ".", unknownHostException);
        }
        catch (IOException iOException) {
            return this.logException("Could not connect to: " + this.mHost + ":" + this.mPort + ".", iOException);
        }
        catch (IllegalValueException illegalValueException) {
            if (illegalValueException.getMessage().equals("first byte of PDATA-PDU not 0x04 but '-1'")) {
                return this.logException("Workstation AE title not recognized by the server. Verify the AE Title configurations above, and on the server.", (Exception)((Object)illegalValueException));
            }
            return this.logException("Could not form an association.", (Exception)((Object)illegalValueException));
        }
        catch (UnknownUIDException unknownUIDException) {
            return this.logException("Could not form an association.", (Exception)((Object)unknownUIDException));
        }
        if (!StringCheck.isStringBlank(string)) {
            return string;
        }
        this.mDebug.printTrace("Sending echo request..");
        int n2 = 0;
        try {
            DicomObject dicomObject = DimseUtil.createEchoRequest((Integer)new Integer(mMessageId), (Integer)new Integer(4097));
            this.mAssociation.sendInPresentationContext(this.mPresentationContextId, dicomObject, null);
            DicomObject dicomObject2 = this.mAssociation.receiveCommand();
            n2 = dicomObject2.getI(9);
        }
        catch (IllegalValueException illegalValueException) {
            return this.logException("Communications error.", (Exception)((Object)illegalValueException));
        }
        catch (DicomException dicomException) {
            return this.logException("Communications error.", (Exception)((Object)dicomException));
        }
        catch (UnknownUIDException unknownUIDException) {
            return this.logException("Communications error.", (Exception)((Object)unknownUIDException));
        }
        catch (IOException iOException) {
            return this.logException("Communications error.", iOException);
        }
        this.mDebug.printTrace("Received echo response, status: " + n2);
        if (n2 != SUCCESS) {
            return "Received unknown status: " + n2;
        }
        return null;
    }

    public void close() {
        super.close();
    }

    private String logException(String string, Exception exception) {
        DebugManager.getDefault().printException(string, exception);
        return string;
    }

    private String associate() throws IOException, IllegalValueException, UnknownUIDException {
        boolean bl2 = this.associate(4097);
        if (!bl2) {
            return "Association rejected by " + this.mCalledAe;
        }
        return null;
    }
}

