/*
 * Decompiled with CFR 0.152.
 */
package InteleDicomLibrary.Print;

import InteleDicomLibrary.Print.DicomPrintImage;
import InteleDicomLibrary.Print.DicomPrintImageProvider;
import InteleDicomLibrary.Print.PrintManagementScu;
import InteleDicomLibrary.Services.DimseException;
import InteleDicomLibrary.Services.DimseMessage;
import InteleDicomLibrary.Services.Scu;
import RuntimeTool.Debug;
import RuntimeTool.DebugManager;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.tools.Sequences;
import com.intelerad.datamodels.dicom.DicomAttribute;
import com.intelerad.datamodels.dicom.print.DicomPrintConstants;
import com.intelerad.datamodels.dicom.print.PrintJob;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class DicomPrintJobController {
    private final PrintManagementScu mScu;
    private final PrintJob mPrintJob;
    private volatile boolean mCancelOperation = false;

    public DicomPrintJobController(PrintJob printJob, List list) {
        this.mPrintJob = printJob;
        this.mScu = new PrintManagementScu(this.mPrintJob.getConnectionParameters(), list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrintProgressMeter printProgressMeter) throws DicomException {
        Debug debug = DebugManager.getDefault();
        this.mScu.setDebug(debug);
        try {
            String string = "Printing to " + this.mPrintJob.getPrinter() + ": ";
            debug.printTrace(string + "Creating association");
            if (!this.mScu.associate()) {
                debug.printTrace(string + "Could not make association: " + this.mScu.getErrorDetails());
                throw new DicomException("Could not make association: " + this.mScu.getErrorDetails());
            }
            debug.printTrace(string + "Successfully associated");
            try {
                DimseMessage dimseMessage = this.mScu.createFilmSession(this.getFilmSessionAttributes());
                boolean bl2 = this.mPrintJob.collate();
                this.printImages(printProgressMeter, dimseMessage.getAffectedInstanceUid(), bl2);
                if (!this.mCancelOperation && !bl2) {
                    debug.printTrace(string + "Printing films");
                    this.mScu.printFilmSession(dimseMessage.getAffectedInstanceUid());
                }
                printProgressMeter.advanceMeter(1.0);
                this.mScu.deleteFilmSession(dimseMessage.getAffectedInstanceUid());
                Object var7_10 = null;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                try {
                    debug.printTrace(string + "Releasing association");
                    this.mScu.release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                debug.printTrace(string + "Releasing association");
                this.mScu.release();
            }
            catch (Exception exception) {}
        }
        catch (IllegalValueException illegalValueException) {
            Scu.throwDicomException((Exception)((Object)illegalValueException));
        }
        catch (DimseException dimseException) {
            Scu.throwDicomException(dimseException);
        }
        catch (IOException iOException) {
            Scu.throwDicomException(iOException);
        }
        catch (UnknownUIDException unknownUIDException) {
            Scu.throwDicomException((Exception)((Object)unknownUIDException));
        }
    }

    public void cancelPrintJob() {
        this.mCancelOperation = true;
    }

    public List getWarnings() {
        return this.mScu.getWarnings();
    }

    private Map getFilmSessionAttributes() {
        return this.mPrintJob.getPrinter().getConfiguration().getModule(DicomPrintConstants.getBasicFilmSessionPresentationModule(), this.mPrintJob.getProtocol());
    }

    private Map getFilmBoxAttributes(float f2) {
        return this.mPrintJob.getPrinter().getConfiguration().getModule(DicomPrintConstants.getBasicFilmBoxPresentationModule(), this.mPrintJob.getProtocol());
    }

    private void printImages(PrintProgressMeter printProgressMeter, String string, boolean bl2) throws DicomException, IllegalValueException, IOException, UnknownUIDException, DimseException {
        DicomPrintImageProvider dicomPrintImageProvider = this.mPrintJob.getImageProvider();
        int n2 = dicomPrintImageProvider.getNumberOfImages();
        double d2 = (double)n2 + (bl2 ? 1.0 : 2.0);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2 && !this.mCancelOperation) {
            DicomPrintImage dicomPrintImage = dicomPrintImageProvider.getImage(n4);
            DimseMessage dimseMessage = this.mScu.createFilmBox(string, this.getFilmBoxAttributes((float)dicomPrintImage.getWidth()));
            n4 += this.fillImageBox(dimseMessage.getData(), dicomPrintImageProvider, n4);
            if (bl2 && !this.mCancelOperation) {
                DebugManager.getDefault().printTrace("Printing film " + ++n3);
                this.mScu.printFilmBox(dimseMessage.getAffectedInstanceUid());
                this.mScu.deleteFilmBox(dimseMessage.getAffectedInstanceUid());
            }
            printProgressMeter.advanceMeter((double)n4 / d2);
        }
    }

    private int fillImageBox(DicomObject dicomObject, DicomPrintImageProvider dicomPrintImageProvider, int n2) throws DicomException, IllegalValueException, IOException, UnknownUIDException, DimseException {
        int n3 = Math.min(dicomObject.getSize(726), dicomPrintImageProvider.getNumberOfImages() - n2);
        for (int i2 = 0; i2 < n3 && !this.mCancelOperation; ++i2) {
            DicomPrintImage dicomPrintImage = dicomPrintImageProvider.getImage(n2 + i2);
            DicomObject dicomObject2 = dicomPrintImage.getDicomObject();
            DicomObject dicomObject3 = new DicomObject();
            if (this.mPrintJob.getProtocol().isTrueSize()) {
                dicomObject3.set(DicomAttribute.RequestedImageSize.getJdtDname(), (Object)new Float(dicomPrintImage.getWidth()));
                dicomObject3.set(DicomAttribute.RequestedDecimateCropBehavior.getJdtDname(), (Object)"CROP");
            }
            Sequences sequences = new Sequences(dicomObject3);
            this.copyImageValues(dicomObject2, sequences);
            this.mScu.setImageBox(dicomObject, i2, dicomObject3);
        }
        return n3;
    }

    private void copyImageValues(DicomObject dicomObject, Sequences sequences) throws DicomException {
        this.copyValue(dicomObject, sequences, 461);
        this.copyValue(dicomObject, sequences, 462);
        this.copyValue(dicomObject, sequences, 466);
        this.copyValue(dicomObject, sequences, 467);
        this.copyPixelAspectRatio(dicomObject, sequences);
        this.copyValue(dicomObject, sequences, 475);
        this.copyValue(dicomObject, sequences, 476);
        this.copyValue(dicomObject, sequences, 477);
        this.copyValue(dicomObject, sequences, 478);
        this.copyValue(dicomObject, sequences, 1184);
    }

    private void copyValue(DicomObject dicomObject, Sequences sequences, int n2) throws DicomException {
        sequences.set(732, 0, n2, dicomObject.get(n2));
    }

    private void copyPixelAspectRatio(DicomObject dicomObject, Sequences sequences) throws DicomException {
        Object object = dicomObject.get(473, 0);
        Object object2 = dicomObject.get(473, 1);
        if (object == null || object2 == null) {
            object = new Integer(1);
            object2 = new Integer(1);
        }
        sequences.set(732, 0, 473, object, 0);
        sequences.set(732, 0, 473, object2, 1);
    }

    public static interface PrintProgressMeter {
        public void advanceMeter(double var1);
    }
}

