/*
 * Decompiled with CFR 0.152.
 */
package InteleDicomLibrary.Client;

import DataModels.SearchFramework.Clause;
import DataModels.SearchFramework.Comparators.BeginsWith;
import DataModels.SearchFramework.Comparators.Equals;
import DataModels.SearchFramework.Comparators.GreaterThanEqual;
import DataModels.SearchFramework.Comparators.LessThanEqual;
import DataModels.SearchFramework.Match;
import DataModels.SearchFramework.Operator;
import DataModels.SearchFramework.Term;
import InteleDicomLibrary.Client.FindClientException;
import InteleDicomLibrary.Pacs.DicomComparable;
import RuntimeTool.DebugManager;
import com.archimed.dicom.DDate;
import com.archimed.dicom.DDateRange;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.intelerad.datamodels.dicom.DicomAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FindUtilities {
    public static final Map COMPARATOR_MAP;
    private static final boolean SERIES_LEVEL = false;
    private static final boolean STUDY_LEVEL = true;
    private static final DicomComparable SIMPLE_MATCH_COMPARABLE;
    public static final DicomComparable CONTAINSALL;

    public static DicomObject getDicomSearchObjectForSeries(String string) {
        try {
            DicomObject dicomObject = FindUtilities.getInitializedSeriesLevelSearchObject();
            dicomObject.set(78, (Object)"SERIES");
            dicomObject.set(425, (Object)string);
            return dicomObject;
        }
        catch (DicomException dicomException) {
            throw new RuntimeException("Unexpected Exception in FindUtlities.getDicomSearchObject(): " + (Object)((Object)dicomException), dicomException);
        }
    }

    public static DicomObject getStudyLevelDicomSearchObject(Match match) throws FindClientException {
        return FindUtilities.convertMatchExpression(match, true);
    }

    public static DicomObject getSeriesLevelDicomSearchObject(Match match) throws FindClientException {
        return FindUtilities.convertMatchExpression(match, false);
    }

    private static DicomObject convertMatchExpression(Match match, boolean bl2) throws FindClientException {
        DicomObject dicomObject;
        try {
            dicomObject = !bl2 ? FindUtilities.getInitializedSeriesLevelSearchObject() : FindUtilities.getInitializedStudyLevelSearchObject();
            dicomObject.set(78, (Object)(!bl2 ? "SERIES" : "STUDY"));
        }
        catch (DicomException dicomException) {
            throw new RuntimeException("Unexpected exception: " + (Object)((Object)dicomException), dicomException);
        }
        List list = match.getClauseList();
        List list2 = ((Clause)list.get(0)).getTermList();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Term term = (Term)iterator.next();
            try {
                FindUtilities.addTerm(dicomObject, term);
            }
            catch (DicomException dicomException) {
                throw new FindClientException("Could not set a dicom value for key " + term.getAttribute() + " and value " + term.getValue(), dicomException);
            }
        }
        return dicomObject;
    }

    private static void addValue(DicomObject dicomObject, int n2, int n3, Object object) throws DicomException {
        dicomObject.set_ge(n2, n3, (Object)(dicomObject.get_ge(n2, n3) + "\\" + object));
    }

    private static DicomObject getInitializedStudyLevelSearchObject() throws DicomException {
        DicomObject dicomObject = new DicomObject();
        dicomObject.set(148, null);
        dicomObject.set(147, null);
        dicomObject.set(157, null);
        dicomObject.set(64, null);
        dicomObject.set(70, null);
        dicomObject.set(88, null);
        dicomObject.set(77, null);
        dicomObject.set(427, null);
        dicomObject.set(425, null);
        dicomObject.set(95, null);
        dicomObject.set(456, null);
        dicomObject.set(457, null);
        dicomObject.set(79, null);
        dicomObject.set(150, null);
        dicomObject.set(151, null);
        dicomObject.set(158, null);
        dicomObject.set(152, null);
        dicomObject.set(154, null);
        dicomObject.set(155, null);
        dicomObject.set(159, null);
        dicomObject.set(165, null);
        dicomObject.set(166, null);
        dicomObject.set(82, null);
        dicomObject.set(381, null);
        return dicomObject;
    }

    private static DicomObject getInitializedSeriesLevelSearchObject() throws DicomException {
        DicomObject dicomObject = FindUtilities.getInitializedStudyLevelSearchObject();
        dicomObject.set(81, null);
        dicomObject.set(458, null);
        dicomObject.set(97, null);
        dicomObject.set(65, null);
        dicomObject.set(71, null);
        dicomObject.set(426, null);
        dicomObject.set(428, null);
        return dicomObject;
    }

    private static Object getDateValue(DicomObject dicomObject, Object object, DicomComparable dicomComparable, DicomAttribute dicomAttribute) {
        if (Equals.getInstance() == dicomComparable) {
            return FindUtilities.getSingleDate(object, dicomComparable);
        }
        return FindUtilities.getDateRange(dicomObject, object, dicomComparable, dicomAttribute);
    }

    private static DDate getSingleDate(Object object, DicomComparable dicomComparable) {
        DDate dDate = new DDate(dicomComparable.getDicomValue(object).toString());
        DebugManager.getDefault().printDebug("DICOM Date = " + dDate.toDICOMString());
        return dDate;
    }

    private static DDateRange getDateRange(DicomObject dicomObject, Object object, DicomComparable dicomComparable, DicomAttribute dicomAttribute) {
        DDateRange dDateRange = (DDateRange)dicomObject.get_ge(dicomAttribute.getGroup(), dicomAttribute.getElement());
        DDateRange dDateRange2 = new DDateRange((String)dicomComparable.getDicomValue(object));
        DDateRange dDateRange3 = dDateRange != null ? FindUtilities.mergeDateRanges(dDateRange, dDateRange2) : dDateRange2;
        DebugManager.getDefault().printDebug("DICOM Date Range = " + dDateRange3.toDICOMString());
        return dDateRange3;
    }

    private static DDateRange mergeDateRanges(DDateRange dDateRange, DDateRange dDateRange2) {
        DDate dDate = dDateRange.getDate1();
        DDate dDate2 = dDateRange.getDate2();
        DDate dDate3 = dDateRange2.getDate1();
        DDate dDate4 = dDateRange2.getDate2();
        if (dDate3 == null) {
            dDate3 = dDate;
        }
        if (dDate4 == null) {
            dDate4 = dDate2;
        }
        return new DDateRange(dDate3, dDate4);
    }

    private static void addTerm(DicomObject dicomObject, Term term) throws DicomException {
        DicomAttribute dicomAttribute = DicomAttribute.getAttributeFromName(term.getAttribute());
        DicomComparable dicomComparable = (DicomComparable)COMPARATOR_MAP.get(term.getOperator());
        if (dicomAttribute == null || dicomComparable == null) {
            throw new RuntimeException("Attribtue or comparator is unknown.");
        }
        if (term.getOperator() == Operator.CONTAINSANY) {
            Set set = Operator.splitOperand(term.getValue());
            int n2 = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                object = FindUtilities.fixValue(dicomAttribute, object, dicomObject, dicomComparable);
                if (n2 == 0) {
                    dicomObject.set_ge(dicomAttribute.getGroup(), dicomAttribute.getElement(), object);
                } else {
                    FindUtilities.addValue(dicomObject, dicomAttribute.getGroup(), dicomAttribute.getElement(), object);
                }
                ++n2;
            }
        } else {
            Object object = term.getValue();
            object = FindUtilities.fixValue(dicomAttribute, object, dicomObject, dicomComparable);
            dicomObject.set_ge(dicomAttribute.getGroup(), dicomAttribute.getElement(), object);
        }
    }

    private static Object fixValue(DicomAttribute dicomAttribute, Object object, DicomObject dicomObject, DicomComparable dicomComparable) {
        if (dicomAttribute == DicomAttribute.StudyDate) {
            return FindUtilities.getDateValue(dicomObject, object, dicomComparable, dicomAttribute);
        }
        return dicomComparable.getDicomValue(object);
    }

    static {
        SIMPLE_MATCH_COMPARABLE = new DicomComparable(){

            public Object getDicomValue(Object object) {
                return object;
            }
        };
        CONTAINSALL = new DicomComparable(){

            public Object getDicomValue(Object object) {
                Set set = Operator.splitOperand((String)object);
                if (set.isEmpty()) {
                    return "";
                }
                return "*" + set.iterator().next() + "*";
            }
        };
        HashMap<Operator, Object> hashMap = new HashMap<Operator, Object>();
        hashMap.put(Operator.EQUALS, Equals.getInstance());
        hashMap.put(Operator.BEGINS, BeginsWith.getInstance());
        hashMap.put(Operator.SIMPLE_MATCH, SIMPLE_MATCH_COMPARABLE);
        hashMap.put(Operator.CONTAINSALL, CONTAINSALL);
        hashMap.put(Operator.GREATEREQUAL, GreaterThanEqual.getInstance());
        hashMap.put(Operator.LESSEQUAL, LessThanEqual.getInstance());
        hashMap.put(Operator.CONTAINSANY, Equals.getInstance());
        COMPARATOR_MAP = Collections.unmodifiableMap(hashMap);
    }
}

