/*
 * Decompiled with CFR 0.152.
 */
package InteleDicomLibrary.Client;

import DataModels.DataModel;
import DataModels.SearchFramework.Clause;
import DataModels.SearchFramework.Match;
import DataModels.SearchFramework.Operator;
import DataModels.SearchFramework.Term;
import InteleDicomLibrary.Client.FindClientException;
import InteleDicomLibrary.Client.FindUtilities;
import InteleDicomLibrary.Services.DicomConnectionParameters;
import InteleDicomLibrary.Services.FindScu;
import com.archimed.dicom.DicomObject;
import com.intelerad.datamodels.dicom.DicomAttribute;
import com.intelerad.datamodels.dicom.DicomDataModel;
import com.intelerad.tools.lib.concurrent.CancellationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FindClient {
    public static final String DEBUG_KEY = "FindClient";
    private DicomConnectionParameters mConnectionParameters;
    private volatile boolean mCancelled;

    public FindClient(DicomConnectionParameters dicomConnectionParameters) {
        this.mConnectionParameters = dicomConnectionParameters;
    }

    public List findStudies(Match match, int n2) throws FindClientException {
        this.checkForCancel();
        this.checkSupported(match);
        Set set = this.extractModalityList(match);
        if (set.size() > 1) {
            return this.doMultipleModalitiesQuery(set, match, n2);
        }
        DicomObject dicomObject = FindUtilities.getStudyLevelDicomSearchObject(match);
        FindScu findScu = new FindScu(this.mConnectionParameters);
        this.checkForCancel();
        List list = findScu.findPatients(dicomObject, n2);
        this.checkForCancel();
        if (list == null) {
            throw new FindClientException("Error communicating with remote");
        }
        ArrayList<DicomDataModel> arrayList = new ArrayList<DicomDataModel>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new DicomDataModel((DicomObject)iterator.next()));
        }
        return arrayList;
    }

    private void checkSupported(Match match) {
        if (match.getNumberOfClauses() != 1) {
            throw new IllegalArgumentException("Don't know how to read match expressions at with more than 1 clause.");
        }
    }

    private List createNewMatchers(Set set, Match match) {
        ArrayList<Match> arrayList = new ArrayList<Match>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            arrayList.add(this.copyAndReplaceModality(string, match));
        }
        return arrayList;
    }

    private List doMultipleModalitiesQuery(Set set, Match match, int n2) throws FindClientException {
        Iterator iterator;
        ArrayList arrayList;
        List list = this.createNewMatchers(set, match);
        ArrayList arrayList2 = new ArrayList(100);
        Object object = list.iterator();
        while (object.hasNext()) {
            arrayList = (Match)object.next();
            iterator = this.findStudies((Match)((Object)arrayList), n2);
            arrayList2.addAll(iterator);
        }
        object = new HashMap();
        arrayList = arrayList2.iterator();
        while (arrayList.hasNext()) {
            iterator = (DataModel)arrayList.next();
            object.put(iterator.getProperty(DicomAttribute.StudyInstanceUID), iterator);
        }
        arrayList = new ArrayList(100);
        iterator = object.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
            if (arrayList.size() < n2) continue;
            break;
        }
        return arrayList;
    }

    private Match copyAndReplaceModality(String string, Match match) {
        List list = match.getClause(0).getTermList();
        Clause clause = new Clause();
        Object object = list.iterator();
        while (object.hasNext()) {
            Term term = (Term)object.next();
            if (term.getAttribute().equals(DicomAttribute.ModalitiesInStudy.getName())) {
                clause.addTerm(new Term(DicomAttribute.ModalitiesInStudy.getName(), Operator.EQUALS, string));
                continue;
            }
            clause.addTerm(term);
        }
        object = new Match();
        ((Match)object).addClause(clause);
        return object;
    }

    private Set extractModalityList(Match match) {
        String string = DicomAttribute.ModalitiesInStudy.getName();
        List list = match.getClause(0).getTermList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Term term = (Term)iterator.next();
            if (!term.getAttribute().equals(string) || term.getOperator() != Operator.CONTAINSANY) continue;
            return Operator.splitOperand(term.getValue());
        }
        return Collections.EMPTY_SET;
    }

    public List findSeries(Match match) throws FindClientException {
        this.checkForCancel();
        this.checkSupported(match);
        if (match.getClause(0).getNumberOfTerms() > 2) {
            throw new IllegalArgumentException("Don't know how to read match expressions at with more than 2 terms.");
        }
        if (match.getClause(0).getNumberOfTerms() <= 0) {
            throw new IllegalArgumentException("Must have at least 1 term!");
        }
        this.validateSeriesTerm(match.getClause(0).getTerm(0));
        if (match.getClause(0).getNumberOfTerms() > 1) {
            this.validateSeriesTerm(match.getClause(0).getTerm(1));
        }
        DicomObject dicomObject = FindUtilities.getSeriesLevelDicomSearchObject(match);
        FindScu findScu = new FindScu(this.mConnectionParameters);
        List list = new ArrayList();
        this.checkForCancel();
        list = findScu.findPatients(dicomObject, -1);
        this.checkForCancel();
        if (list == null) {
            throw new FindClientException("Error communicating with remote");
        }
        ArrayList<DicomDataModel> arrayList = new ArrayList<DicomDataModel>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new DicomDataModel((DicomObject)iterator.next()));
        }
        this.checkForCancel();
        return arrayList;
    }

    private void validateSeriesTerm(Term term) {
        if (!term.getAttribute().equals(DicomAttribute.StudyInstanceUID.getName()) && !term.getAttribute().equals(DicomAttribute.SeriesInstanceUID.getName())) {
            throw new IllegalArgumentException("Only understand study/series instance uid attribute.");
        }
    }

    private void checkForCancel() {
        if (this.mCancelled) {
            throw new CancellationException();
        }
    }

    public void cancel() {
        this.mCancelled = true;
    }
}

