/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Worker;

import com.intelerad.tools.lib.concurrent.AsynchronousCallable;
import com.intelerad.tools.lib.concurrent.CallListener;
import com.intelerad.tools.lib.concurrent.CallListenerWrapper;
import com.intelerad.tools.lib.concurrent.CallableUtilities;
import com.intelerad.tools.lib.concurrent.Cancellable;
import com.intelerad.tools.lib.concurrent.CancellableCallable;
import com.intelerad.tools.lib.concurrent.Invoker;
import com.intelerad.tools.lib.concurrent.TaskController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public final class PeriodicTask
implements Cancellable {
    private static State SEARCH_STATE = new State("DELAY_STATE");
    private static State DELAY_STATE = new State("SEARCH_STATE");
    private final AsynchronousCallable mCallable;
    private final MyCallListener mCallListener;
    private final int mDelay;
    private State mState;
    private Cancellable mCurrentTask;
    private boolean mCancel;

    public PeriodicTask(AsynchronousCallable asynchronousCallable, CallListener callListener, int n2) {
        this.mCallable = asynchronousCallable;
        this.mCallListener = new MyCallListener(callListener);
        this.mDelay = n2;
    }

    public PeriodicTask(final CancellableCallable cancellableCallable, CallListener callListener, int n2) {
        this.mCallListener = new MyCallListener(callListener);
        this.mDelay = n2;
        this.mCallable = new AsynchronousCallable(){

            public TaskController call(CallListener callListener) {
                return CallableUtilities.execute(cancellableCallable, callListener, Invoker.EVENT_THREAD_INVOKER);
            }
        };
    }

    public int getDelay() {
        return this.mDelay;
    }

    public void start(boolean bl2) {
        if (this.mCurrentTask != null) {
            throw new IllegalStateException("Periodic Searcher is already started");
        }
        this.stateTransition(bl2 ? SEARCH_STATE : DELAY_STATE);
    }

    public void cancel() {
        this.mCancel = true;
        if (this.mCurrentTask != null) {
            this.mCurrentTask.cancel();
        }
    }

    private void stateTransition(State state) {
        this.mState = state;
        if (this.mCancel) {
            return;
        }
        if (this.mState == DELAY_STATE) {
            Timer timer = new Timer(this.mDelay, new MyTimerActionListener());
            timer.setRepeats(false);
            timer.start();
        } else if (this.mState == SEARCH_STATE) {
            this.startSearch();
        }
    }

    private void startSearch() {
        this.mCurrentTask = this.mCallable.call(this.mCallListener);
    }

    private class MyCallListener
    extends CallListenerWrapper {
        public MyCallListener(CallListener callListener) {
            super(callListener);
        }

        public void handleSuccess(Object object) {
            super.handleSuccess(object);
            PeriodicTask.this.stateTransition(DELAY_STATE);
        }
    }

    private static class State {
        private String mMessage;

        public State(String string) {
            this.mMessage = string;
        }

        public String toString() {
            return this.mMessage;
        }
    }

    private class MyTimerActionListener
    implements ActionListener {
        private MyTimerActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PeriodicTask.this.stateTransition(SEARCH_STATE);
        }
    }
}

