/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util.TileCacheMonitorTool;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public final class Statistics
extends JPanel {
    private long[] stats = null;
    private int percent = 0;
    private static final Color DARK_BLUE = new Color(10, 10, 120);
    private static final Color DARK_RED = new Color(240, 40, 40);
    private static final Color BACKGROUND = new Color(180, 180, 220);
    private static final Font DEFAULT_FONT = new Font("monospaced", 1, 14);
    private static final String[] LABELS = new String[]{"     Tile Count: ", "     Cache Hits: ", "   Cache Misses: ", "       Add Tile: ", "    Remove Tile: ", "  Remove(flush): ", "Remove(control): ", "Update(addTile): ", "Update(getTile): ", " Used Memory(%): "};

    public Statistics() {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(270, 200));
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        LineBorder lineBorder = new LineBorder(Color.gray, 1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(lineBorder, "Statistics", 1, 2, DEFAULT_FONT, Color.black);
        CompoundBorder compoundBorder = new CompoundBorder(emptyBorder, titledBorder);
        this.setBorder(compoundBorder);
        this.stats = new long[LABELS.length];
    }

    public void set(long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, int n2) {
        this.stats[0] = l2;
        this.stats[1] = l3;
        this.stats[2] = l4;
        this.stats[3] = l5;
        this.stats[4] = l6;
        this.stats[5] = l7;
        this.stats[6] = l8;
        this.stats[7] = l9;
        this.stats[8] = l10;
        this.stats[9] = n2;
        this.percent = n2;
        this.repaint();
    }

    public void set(int n2) {
        this.percent = n2;
        this.stats[9] = n2;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Insets insets = this.getInsets();
        graphics2D.setColor(BACKGROUND);
        graphics2D.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        int n2 = insets.left + 10;
        int n3 = insets.top + 10;
        int n4 = this.getHeight() - insets.bottom - 5;
        int n5 = 20;
        int n6 = n4 - n3 + 1;
        graphics2D.setColor(DARK_BLUE);
        graphics2D.fillRect(n2, n3, n5, n6);
        graphics2D.setColor(Color.white);
        graphics2D.drawRect(n2 - 1, n3 - 1, n5 + 1, n6 + 1);
        graphics2D.setColor(DARK_RED);
        int n7 = (int)((float)n6 * ((float)this.percent / 100.0f));
        if (n7 > 0) {
            graphics2D.fillRect(n2, n4 - n7, n5, n7);
        }
        int n8 = insets.left + 50;
        int n9 = insets.top + 20;
        graphics2D.setColor(Color.black);
        graphics2D.setFont(DEFAULT_FONT);
        int n10 = this.getFontMetrics(DEFAULT_FONT).getAscent();
        for (int i2 = 0; i2 < LABELS.length; ++i2) {
            graphics2D.drawString(LABELS[i2] + this.stats[i2], n8, n9);
            n9 += n10;
        }
    }
}

