/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import GuiUtilities.Layouts.GridBagBuilder;
import GuiUtilities.Util.SimpleDatePickerPanel;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SearchDatePicker
extends JPanel {
    private static final long DAY = 86400000L;
    public static final DateComboBoxEnum ALL_DATES = new DateComboBoxEnum("All Dates"){

        public Date[] getDateRange() {
            return new Date[]{null, null};
        }
    };
    public static final DateComboBoxEnum TODAY = new DateComboBoxEnum("Today"){

        public Date[] getDateRange() {
            return new Date[]{SearchDatePicker.buildLastMidNight(), new Date(System.currentTimeMillis())};
        }
    };
    public static final DateComboBoxEnum YESTERDAY = new DateComboBoxEnum("Yesterday"){

        public Date[] getDateRange() {
            Date date = new Date(SearchDatePicker.buildLastMidNight().getTime() - 86400000L);
            return new Date[]{date, date};
        }
    };
    public static final DateComboBoxEnum LAST_2_DAYS = new DateComboBoxEnum("Last 48 hours"){

        public Date[] getDateRange() {
            return new Date[]{new Date(System.currentTimeMillis() - 172800000L), new Date(System.currentTimeMillis())};
        }
    };
    public static final DateComboBoxEnum LAST_WEEK = new DateComboBoxEnum("Last 7 Days"){

        public Date[] getDateRange() {
            return new Date[]{new Date(System.currentTimeMillis() - 604800000L), new Date(System.currentTimeMillis())};
        }
    };
    public static final DateComboBoxEnum LAST_MONTH = new DateComboBoxEnum("Last 31 Days"){

        public Date[] getDateRange() {
            return new Date[]{new Date(System.currentTimeMillis() - 2678400000L), new Date(System.currentTimeMillis())};
        }
    };
    private static final DateComboBoxEnum CUSTOM = new DateComboBoxEnum("Custom Range"){

        public Date[] getDateRange() {
            return null;
        }
    };
    private JLabel mFromLabel;
    private JLabel mToLabel;
    private SimpleDatePickerPanel mFromDatePicker;
    private SimpleDatePickerPanel mToDatePicker;
    private JComboBox mPresets;
    private final List mDateEnumList;

    public SearchDatePicker() {
        Object[] objectArray = new Object[]{ALL_DATES, TODAY, YESTERDAY, LAST_2_DAYS, LAST_WEEK, LAST_MONTH, CUSTOM};
        this.mDateEnumList = Collections.unmodifiableList(Arrays.asList(objectArray));
        this.guiInit();
    }

    public Date[] getDates() {
        Date date = this.mFromDatePicker.getDate();
        Date date2 = this.mToDatePicker.getDate();
        if (date != null && date2 != null && date.getTime() > date2.getTime()) {
            this.mFromDatePicker.setDate(date2);
            this.mToDatePicker.setDate(date);
            return this.getDates();
        }
        return new Date[]{date, date2};
    }

    public void setDate(DateComboBoxEnum dateComboBoxEnum) {
        if (!this.mDateEnumList.contains(dateComboBoxEnum)) {
            throw new IllegalStateException("DateComboBoxEnum \"" + dateComboBoxEnum + "\" was not found in the list of enums known by this object.");
        }
        this.mPresets.setSelectedItem(dateComboBoxEnum);
    }

    public void setDates(Date date, Date date2) {
        Iterator iterator = this.mDateEnumList.iterator();
        while (iterator.hasNext()) {
            DateComboBoxEnum dateComboBoxEnum = (DateComboBoxEnum)iterator.next();
            Date[] dateArray = dateComboBoxEnum.getDateRange();
            if (dateArray == null || !SearchDatePicker.datesEquals(date, dateArray[0]) || !SearchDatePicker.datesEquals(date2, dateArray[1])) continue;
            this.setDate(dateComboBoxEnum);
            return;
        }
        this.setDate(CUSTOM);
        this.mFromDatePicker.setDate(date);
        this.mToDatePicker.setDate(date2);
    }

    private static boolean datesEquals(Date date, Date date2) {
        if (date == date2 && date == null) {
            return true;
        }
        return date.equals(date2);
    }

    private void guiInit() {
        SimpleDatePickerPanel.GuiModificationListener guiModificationListener = new SimpleDatePickerPanel.GuiModificationListener(){

            public void guiModified(String string) {
                SearchDatePicker.this.setPresetsToCustom();
            }
        };
        this.mFromDatePicker = new SimpleDatePickerPanel();
        this.mFromDatePicker.setGuiModificationListener(guiModificationListener);
        this.mToDatePicker = new SimpleDatePickerPanel();
        this.mToDatePicker.setGuiModificationListener(guiModificationListener);
        this.mPresets = new JComboBox<Object>(this.mDateEnumList.toArray());
        this.mPresets.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                SearchDatePicker.this.updateDates();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagBuilder gridBagBuilder = new GridBagBuilder().setInsets(5, 5, 5, 5).setFill(2, 1.0, 0.0);
        this.add((Component)this.mPresets, gridBagBuilder.setLocation(0, 0).setSize(2, 1).getConstraints());
        this.mFromLabel = new JLabel("From");
        this.mFromLabel.setHorizontalTextPosition(4);
        this.add((Component)this.mFromLabel, gridBagBuilder.setLocation(0, 1).setFill(2, 0.0, 0.0).getConstraints());
        this.add((Component)this.mFromDatePicker, gridBagBuilder.setLocation(1, 1).setInsets(5, 5, 5, 3).getConstraints());
        this.mToLabel = new JLabel("To");
        this.mToLabel.setHorizontalTextPosition(4);
        this.add((Component)this.mToLabel, gridBagBuilder.setLocation(0, 2).setFill(2, 0.0, 0.0).getConstraints());
        this.add((Component)this.mToDatePicker, gridBagBuilder.setLocation(1, 2).setInsets(5, 5, 5, 3).getConstraints());
        this.add(Box.createGlue(), gridBagBuilder.setLocation(0, 3).setSize(2, 1).setFill(1, 1.0, 1.0).getConstraints());
        this.updateDates();
    }

    private void setPresetsToCustom() {
        this.mPresets.setSelectedItem(CUSTOM);
    }

    private void updateDates() {
        DateComboBoxEnum dateComboBoxEnum = (DateComboBoxEnum)this.mPresets.getSelectedItem();
        Date[] dateArray = dateComboBoxEnum.getDateRange();
        if (dateArray != null) {
            this.mFromDatePicker.setDate(dateArray[0]);
            this.mToDatePicker.setDate(dateArray[1]);
        }
    }

    private static Date buildLastMidNight() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private static abstract class DateComboBoxEnum {
        private final String mUiText;

        private DateComboBoxEnum(String string) {
            this.mUiText = string;
        }

        public abstract Date[] getDateRange();

        public String toString() {
            return this.mUiText;
        }
    }
}

