/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import DataModels.SearchFramework.Operator;
import DataStructures.CollectionUtilities;
import GuiUtilities.Util.AttributeOperatorValueGui;
import GuiUtilities.Util.RowValue;
import GuiUtilities.Util.SearchCriteriaPanel;
import GuiUtilities.Util.SearchCriterionDefinition;
import GuiUtilities.Util.ValueFieldFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class SearchCriteriaPanelBuilder
implements PropertyChangeListener {
    private Map mNameToAttribute;
    private Map mAttributeToName;
    private List mPreferredSearchAttributeMaps;
    private String mAttributePreferenceKey;
    private String mOperatorPreferenceKey;
    private SearchCriteriaPanel mSearchCriteriaPanel = null;
    protected ValueFieldFactory mValueFieldFactory;
    private List mSearchCriterionDefinitions;

    protected SearchCriteriaPanelBuilder(List list, List list2, String string, String string2) {
        this(list, list2, string, string2, new AttributeOperatorValueGui.DefaultValueFieldFactory(10));
    }

    protected SearchCriteriaPanelBuilder(List list, List list2, String string, String string2, ValueFieldFactory valueFieldFactory) {
        this.initMaps(list);
        this.mSearchCriterionDefinitions = list;
        this.mPreferredSearchAttributeMaps = list2;
        this.mAttributePreferenceKey = string;
        this.mOperatorPreferenceKey = string2;
        this.mValueFieldFactory = valueFieldFactory;
    }

    protected abstract String getAttributeName(Object var1);

    protected abstract void handleSearchAttributesChanged(List var1);

    private void initMaps(List list) {
        this.mNameToAttribute = new LinkedHashMap();
        this.mAttributeToName = new HashMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SearchCriterionDefinition searchCriterionDefinition = (SearchCriterionDefinition)iterator.next();
            Object object = searchCriterionDefinition.getAttribute();
            String string = this.getAttributeName(object);
            this.mNameToAttribute.put(string, object);
        }
        this.mAttributeToName = CollectionUtilities.inverseMap(this.mNameToAttribute);
    }

    private void initSearchCriteriaPanel() {
        ArrayList<RowValue> arrayList = new ArrayList<RowValue>();
        Iterator iterator = this.mPreferredSearchAttributeMaps.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            String string = (String)map.get(this.mAttributePreferenceKey);
            String string2 = (String)map.get(this.mOperatorPreferenceKey);
            Object v2 = this.mNameToAttribute.get(string);
            Operator operator = Operator.fromString(string2);
            if (v2 == null || string == null || string2 == null) continue;
            arrayList.add(new RowValue(v2, operator, ""));
        }
        this.mSearchCriteriaPanel = new SearchCriteriaPanel(this.mSearchCriterionDefinitions, arrayList, this.mValueFieldFactory);
        this.mSearchCriteriaPanel.addPropertyChangeListener("rows", this);
    }

    public final SearchCriteriaPanel getSearchCriteriaPanel() {
        if (this.mSearchCriteriaPanel == null) {
            this.initSearchCriteriaPanel();
        }
        return this.mSearchCriteriaPanel;
    }

    private List getSearchAttributePreferenceMaps() {
        RowValue[] rowValueArray = this.mSearchCriteriaPanel.getRows();
        ArrayList arrayList = new ArrayList(rowValueArray.length);
        for (int i2 = 0; i2 < rowValueArray.length; ++i2) {
            HashMap hashMap = new HashMap();
            RowValue rowValue = rowValueArray[i2];
            Object object = rowValue.getAttribute();
            Operator operator = (Operator)rowValue.getOperator();
            String string = operator.getName();
            Object v2 = this.mAttributeToName.get(object);
            hashMap.put(this.mAttributePreferenceKey, v2);
            hashMap.put(this.mOperatorPreferenceKey, string);
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.handleSearchAttributesChanged(this.getSearchAttributePreferenceMaps());
    }
}

