/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import GuiUtilities.Layouts.GridBagBuilder;
import GuiUtilities.Util.AbstractCriteriaPanel;
import GuiUtilities.Util.AttributeOperatorValueGui;
import GuiUtilities.Util.AttributeOperatorValuePanel;
import GuiUtilities.Util.RowValue;
import GuiUtilities.Util.SearchCriterionDefinition;
import GuiUtilities.Util.ValueField;
import GuiUtilities.Util.ValueFieldFactory;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;

public class SearchCriteriaPanel
extends AbstractCriteriaPanel
implements PropertyChangeListener {
    static final String PROPERTIES_ROWS = "rows";
    private List mCriterionDefinitions;
    private AttributeOperatorValuePanel mAttributeOperatorValuePanel;
    private ValueFieldFactory mValueFieldFactory;
    private JButton mMoreButton;
    private JButton mLessButton;

    public SearchCriteriaPanel(List list, List list2, ValueFieldFactory valueFieldFactory) {
        this.mCriterionDefinitions = Collections.unmodifiableList(new ArrayList(list));
        this.mValueFieldFactory = valueFieldFactory;
        this.initGui(list2);
    }

    private void initGui(List list) {
        this.mMoreButton = new JButton("More Fields");
        this.mLessButton = new JButton("Fewer Fields");
        this.mAttributeOperatorValuePanel = new AttributeOperatorValuePanel();
        int n2 = list.size() == 0 ? 2 : list.size();
        for (int i2 = 0; i2 < Math.min(this.mCriterionDefinitions.size(), n2); ++i2) {
            this.addRow();
        }
        this.setRowValues(list);
        this.setLayout(new GridBagLayout());
        GridBagBuilder gridBagBuilder = new GridBagBuilder().setFill(1, 1.0, 0.0);
        this.add((Component)this.mAttributeOperatorValuePanel, gridBagBuilder.setLocation(0, 0).getConstraints());
        this.add(Box.createGlue(), gridBagBuilder.setLocation(0, 1).setFill(1, 1.0, 1.0).getConstraints());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        this.mMoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchCriteriaPanel.this.addRow();
            }
        });
        jPanel.add(this.mMoreButton);
        jPanel.add(Box.createHorizontalStrut(5));
        this.mLessButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchCriteriaPanel.this.removeRow();
            }
        });
        jPanel.add(this.mLessButton);
        this.add((Component)jPanel, gridBagBuilder.setLocation(0, 2).setInsets(5, 0, 0, 0).getConstraints());
        this.checkButtonsEnable();
    }

    public void reset() {
        RowValue[] rowValueArray = this.getRows();
        for (int i2 = 0; i2 < rowValueArray.length; ++i2) {
            RowValue rowValue = rowValueArray[i2];
            rowValueArray[i2] = new RowValue(rowValue.getAttribute(), rowValue.getOperator(), "");
        }
        this.setRows(Arrays.asList(rowValueArray));
    }

    private void setRowValues(List list) {
        for (int i2 = 0; i2 < list.size() && i2 < this.mAttributeOperatorValuePanel.getComponentCount(); ++i2) {
            RowValue rowValue = (RowValue)list.get(i2);
            this.mAttributeOperatorValuePanel.get(i2).updateGui(rowValue.getAttribute(), rowValue.getOperator(), rowValue.getValue());
        }
    }

    public void setRows(List list) {
        if (list.size() < 1 || list.size() > this.mCriterionDefinitions.size()) {
            throw new IllegalStateException("Can set rows to more than number of possible rows or less than 1. tried to set rows to: " + list.size());
        }
        if (list.size() != this.mAttributeOperatorValuePanel.getNumberOfRows()) {
            boolean bl2 = list.size() > this.mAttributeOperatorValuePanel.getNumberOfRows();
            int n2 = list.size() - this.mAttributeOperatorValuePanel.getNumberOfRows();
            n2 = n2 < 0 ? -n2 : n2;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (bl2) {
                    this.addRow();
                    continue;
                }
                this.removeRow();
            }
        }
        this.setRowValues(list);
    }

    private void addRow() {
        if (this.mAttributeOperatorValuePanel.getNumberOfRows() >= this.mCriterionDefinitions.size()) {
            return;
        }
        ExclusiveAttributeOperatorValue exclusiveAttributeOperatorValue = new ExclusiveAttributeOperatorValue(this.mCriterionDefinitions, this.mValueFieldFactory);
        exclusiveAttributeOperatorValue.addPropertyChangeListener(this);
        this.mAttributeOperatorValuePanel.addRow(exclusiveAttributeOperatorValue);
        SearchCriterionDefinition searchCriterionDefinition = (SearchCriterionDefinition)this.mCriterionDefinitions.get(0);
        exclusiveAttributeOperatorValue.updateGui(searchCriterionDefinition.getAttribute(), searchCriterionDefinition.getOperatorList(), "");
        this.refreshSelectedItems();
        this.checkButtonsEnable();
        this.fireRowsChanged();
    }

    private void removeRow() {
        if (this.mAttributeOperatorValuePanel.getNumberOfRows() <= 1) {
            return;
        }
        this.mAttributeOperatorValuePanel.removeRow();
        this.refreshSelectedItems();
        this.checkButtonsEnable();
        this.fireRowsChanged();
    }

    private void fireRowsChanged() {
        this.firePropertyChange(PROPERTIES_ROWS, null, this.getRows());
    }

    private void checkButtonsEnable() {
        this.mMoreButton.setEnabled(this.mAttributeOperatorValuePanel.getNumberOfRows() < this.mCriterionDefinitions.size());
        this.mLessButton.setEnabled(this.mAttributeOperatorValuePanel.getNumberOfRows() > 1);
    }

    private void refreshSelectedItems() {
        this.refreshSelectedItems(null);
    }

    private void refreshSelectedItems(ExclusiveAttributeOperatorValue exclusiveAttributeOperatorValue) {
        List list = this.getAllAttibuteNames();
        if (exclusiveAttributeOperatorValue != null) {
            list.remove(exclusiveAttributeOperatorValue.getAttributeValue());
        }
        for (int i2 = 0; i2 < this.mAttributeOperatorValuePanel.getNumberOfRows(); ++i2) {
            AttributeOperatorValueGui attributeOperatorValueGui = this.mAttributeOperatorValuePanel.get(i2);
            if (attributeOperatorValueGui == exclusiveAttributeOperatorValue) continue;
            if (!list.contains(attributeOperatorValueGui.getAttributeValue())) {
                attributeOperatorValueGui.updateGui(list.get(0), "", "");
            }
            list.remove(attributeOperatorValueGui.getAttributeValue());
        }
    }

    private List getAllAttibuteNames() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.mCriterionDefinitions.size());
        Iterator iterator = this.mCriterionDefinitions.iterator();
        while (iterator.hasNext()) {
            SearchCriterionDefinition searchCriterionDefinition = (SearchCriterionDefinition)iterator.next();
            arrayList.add(searchCriterionDefinition.getAttribute());
        }
        return arrayList;
    }

    public RowValue[] getRows() {
        RowValue[] rowValueArray = new RowValue[this.mAttributeOperatorValuePanel.getNumberOfRows()];
        for (int i2 = 0; i2 < rowValueArray.length; ++i2) {
            AttributeOperatorValueGui attributeOperatorValueGui = this.mAttributeOperatorValuePanel.get(i2);
            rowValueArray[i2] = new RowValue(attributeOperatorValueGui.getAttributeValue(), attributeOperatorValueGui.getOperatorValue(), attributeOperatorValueGui.getValue());
        }
        return rowValueArray;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!"valueField".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        ValueField valueField = (ValueField)propertyChangeEvent.getOldValue();
        ValueField valueField2 = (ValueField)propertyChangeEvent.getNewValue();
        this.mAttributeOperatorValuePanel.replaceValueComponent(valueField.getComponent(), valueField2.getComponent());
    }

    static /* synthetic */ void access$300(SearchCriteriaPanel searchCriteriaPanel, ExclusiveAttributeOperatorValue exclusiveAttributeOperatorValue) {
        searchCriteriaPanel.refreshSelectedItems(exclusiveAttributeOperatorValue);
    }

    static /* synthetic */ void access$400(SearchCriteriaPanel searchCriteriaPanel) {
        searchCriteriaPanel.fireRowsChanged();
    }

    private class ExclusiveAttributeOperatorValue
    extends AttributeOperatorValueGui.EnhancedAttributeOperatorValueComboBox {
        public ExclusiveAttributeOperatorValue(List list, ValueFieldFactory valueFieldFactory) {
            super(list, valueFieldFactory);
            this.mAttributeComboBox.addItemListener(new ItemListener(this, SearchCriteriaPanel.this){
                private final /* synthetic */ SearchCriteriaPanel val$this$0;
                private final /* synthetic */ ExclusiveAttributeOperatorValue this$1;
                {
                    this.this$1 = exclusiveAttributeOperatorValue;
                    this.val$this$0 = searchCriteriaPanel;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    SearchCriteriaPanel.access$300(ExclusiveAttributeOperatorValue.access$200(this.this$1), this.this$1);
                    if (itemEvent.getStateChange() == 1) {
                        SearchCriteriaPanel.access$400(ExclusiveAttributeOperatorValue.access$200(this.this$1));
                        this.this$1.updateValueField();
                    }
                }
            });
            this.mOperatorComboBox.addItemListener(new ItemListener(this){
                private final /* synthetic */ ExclusiveAttributeOperatorValue this$1;
                {
                    this.this$1 = exclusiveAttributeOperatorValue;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        SearchCriteriaPanel.access$400(ExclusiveAttributeOperatorValue.access$200(this.this$1));
                    }
                }
            });
        }

        static /* synthetic */ SearchCriteriaPanel access$200(ExclusiveAttributeOperatorValue exclusiveAttributeOperatorValue) {
            return exclusiveAttributeOperatorValue.SearchCriteriaPanel.this;
        }
    }
}

