/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import GuiUtilities.Util.CompositeScreen;
import GuiUtilities.Util.CompositeScreenBuilder;
import GuiUtilities.Util.ScreenElement;
import RuntimeTool.DebugManager;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ScreenConfiguration {
    private final ScreenElement[] mScreenElements;
    private final CompositeScreen mCompositeScreen;
    private final GraphicsConfiguration mBestGraphicsConfiguration;

    public ScreenConfiguration() {
        this(1);
    }

    public ScreenConfiguration(int n2) {
        GraphicsDevice[] graphicsDeviceArray = ScreenConfiguration.getPhysicalScreenDevices();
        if (graphicsDeviceArray.length == 1 && n2 > 1) {
            this.mScreenElements = this.createScreenElements(graphicsDeviceArray[0], n2);
            this.mCompositeScreen = new CompositeScreen(this.mScreenElements);
        } else {
            this.mScreenElements = this.createScreenElements(graphicsDeviceArray);
            this.mCompositeScreen = CompositeScreenBuilder.build(this.mScreenElements);
        }
        this.mBestGraphicsConfiguration = this.findBestGraphicsConfiguration(graphicsDeviceArray);
    }

    public ScreenConfiguration(Rectangle[] rectangleArray) {
        this.mScreenElements = this.createScreenElements(rectangleArray);
        this.mCompositeScreen = new CompositeScreen(this.mScreenElements);
        this.mBestGraphicsConfiguration = null;
    }

    public static GraphicsDevice[] getPhysicalScreenDevices() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
    }

    private Insets getScreenInsets(GraphicsConfiguration graphicsConfiguration) {
        return Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
    }

    private ScreenElement[] createScreenElements(GraphicsDevice graphicsDevice, int n2) {
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = this.getScreenInsets(graphicsConfiguration);
        ScreenElement[] screenElementArray = new ScreenElement[n2];
        int n3 = (int)rectangle.getHeight();
        int n4 = (int)rectangle.getWidth() / n2;
        int n5 = 0;
        for (int i2 = 0; i2 < screenElementArray.length; ++i2) {
            screenElementArray[i2] = new ScreenElement(new Rectangle(n5, 0, n4, n3), insets);
            n5 += n4;
        }
        return screenElementArray;
    }

    private ScreenElement[] createScreenElements(GraphicsDevice[] graphicsDeviceArray) {
        ArrayList<ScreenElement> arrayList = new ArrayList<ScreenElement>();
        for (int i2 = 0; i2 < graphicsDeviceArray.length; ++i2) {
            GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[i2].getDefaultConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            Insets insets = this.getScreenInsets(graphicsConfiguration);
            boolean bl2 = true;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Rectangle rectangle2 = ((ScreenElement)iterator.next()).getBounds();
                if (!rectangle2.intersects(rectangle)) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            arrayList.add(new ScreenElement(rectangle, insets));
        }
        return arrayList.toArray(new ScreenElement[arrayList.size()]);
    }

    private ScreenElement[] createScreenElements(Rectangle[] rectangleArray) {
        ScreenElement[] screenElementArray = new ScreenElement[rectangleArray.length];
        for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
            screenElementArray[i2] = new ScreenElement(rectangleArray[i2], null);
        }
        return screenElementArray;
    }

    private Rectangle[] collectScreenBounds() {
        Rectangle[] rectangleArray = new Rectangle[this.mScreenElements.length];
        for (int i2 = 0; i2 < this.mScreenElements.length; ++i2) {
            rectangleArray[i2] = this.mScreenElements[i2].getBounds();
        }
        return rectangleArray;
    }

    private GraphicsConfiguration findBestGraphicsConfiguration(GraphicsDevice[] graphicsDeviceArray) {
        if (graphicsDeviceArray.length == 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        int n2 = ScreenConfiguration.getColourSpaceType(graphicsConfiguration);
        DebugManager.getDefault().printTrace("Default monitor has colour type " + n2);
        if (ScreenConfiguration.isGrayColourType(n2)) {
            return graphicsConfiguration;
        }
        for (int i2 = 0; i2 < graphicsDeviceArray.length; ++i2) {
            GraphicsConfiguration graphicsConfiguration2 = graphicsDeviceArray[i2].getDefaultConfiguration();
            int n3 = ScreenConfiguration.getColourSpaceType(graphicsConfiguration2);
            DebugManager.getDefault().printTrace("Monitor " + i2 + " has colour type " + n3);
            if (ScreenConfiguration.isGrayColourType(n2) || !ScreenConfiguration.isGrayColourType(n3)) continue;
            graphicsConfiguration = graphicsConfiguration2;
            n2 = n3;
            DebugManager.getDefault().printTrace("Using graphics config for monitor " + i2);
        }
        return graphicsConfiguration;
    }

    private static int getColourSpaceType(GraphicsConfiguration graphicsConfiguration) {
        return graphicsConfiguration.getColorModel().getColorSpace().getType();
    }

    private static boolean isGrayColourType(int n2) {
        return n2 == 6;
    }

    public GraphicsConfiguration getBestGraphicsConfiguration() {
        return this.mBestGraphicsConfiguration;
    }

    public CompositeScreen getCompositeScreen() {
        return this.mCompositeScreen;
    }

    public int getScreenCount() {
        return this.mScreenElements.length;
    }

    public int getScreenIndex(int n2, int n3) {
        return this.getScreenIndex(new Point(n2, n3));
    }

    public int getScreenIndex(Point point) {
        int n2;
        Rectangle[] rectangleArray = this.collectScreenBounds();
        int n3 = 0;
        double d2 = point.distance(rectangleArray[0].getCenterX(), rectangleArray[0].getCenterY());
        for (n2 = 0; n2 < rectangleArray.length && !rectangleArray[n2].contains(point); ++n2) {
            double d3 = point.distance(rectangleArray[n2].getCenterX(), rectangleArray[n2].getCenterY());
            if (!(d3 < d2)) continue;
            d2 = d3;
            n3 = n2;
        }
        return n2 < rectangleArray.length ? n2 : n3;
    }

    public Point getCentrePoint(int n2, int n3, int n4, int n5) {
        return this.getCentrePoint(new Rectangle(n2, n3, n4, n5));
    }

    public Point getCentrePoint(Rectangle rectangle) {
        int n2;
        int n3;
        Rectangle[] rectangleArray = this.collectScreenBounds();
        Rectangle rectangle2 = rectangleArray[this.getScreenIndex(n3 = (int)(rectangle.getX() + (rectangle.getWidth() - 1.0) / 2.0), n2 = (int)(rectangle.getY() + (rectangle.getHeight() - 1.0) / 2.0))];
        Rectangle rectangle3 = rectangle2.intersects(rectangle) ? rectangle2.intersection(rectangle) : rectangleArray[0];
        return new Point((int)(rectangle3.getX() + (rectangle3.getWidth() - 1.0) / 2.0), (int)(rectangle3.getY() + (rectangle3.getHeight() - 1.0) / 2.0));
    }

    public Point getCentreOrigin(Rectangle rectangle, Dimension dimension) {
        return this.getCentreOrigin(rectangle, (int)dimension.getWidth(), (int)dimension.getHeight());
    }

    public Point getCentreOrigin(Rectangle rectangle, int n2, int n3) {
        Point point = this.getCentrePoint(rectangle);
        Rectangle rectangle2 = this.mScreenElements[this.getScreenIndex(point)].getBounds();
        int n4 = (int)(point.getX() - (double)((n2 - 1) / 2));
        int n5 = (int)(point.getY() - (double)((n3 - 1) / 2));
        n4 = Math.min(n4, (int)(rectangle2.getX() + rectangle2.getWidth()) - n2);
        n5 = Math.min(n5, (int)(rectangle2.getY() + rectangle2.getHeight()) - n3);
        return new Point(Math.max(n4, (int)rectangle2.getX()), Math.max(n5, (int)rectangle2.getY()));
    }

    public List getScreenBounds() {
        Rectangle[] rectangleArray = this.collectScreenBounds();
        ArrayList<Object> arrayList = new ArrayList<Object>(rectangleArray.length);
        for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
            Rectangle rectangle = rectangleArray[i2];
            arrayList.add(rectangle.clone());
        }
        return arrayList;
    }

    public Rectangle getScreenBounds(int n2) {
        return (Rectangle)this.mScreenElements[n2].getBounds().clone();
    }

    public Rectangle[] getSpannedScreens(Rectangle rectangle) {
        return this.getSpannedScreens(rectangle, 0.0, 0.0);
    }

    public Rectangle[] getSpannedScreens(Rectangle rectangle, double d2, double d3) {
        Rectangle[] rectangleArray = this.collectScreenBounds();
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
            Rectangle rectangle2 = rectangleArray[i2].intersection(rectangle);
            if (rectangle2.isEmpty() || rectangle2.getWidth() / rectangleArray[i2].getWidth() <= d2 || rectangle2.getHeight() / rectangleArray[i2].getHeight() <= d3) continue;
            arrayList.add(new Rectangle(rectangleArray[i2]));
        }
        Rectangle rectangle3 = rectangleArray[this.getScreenIndex((int)rectangle.getCenterX(), (int)rectangle.getCenterY())];
        if (!arrayList.contains(rectangle3)) {
            arrayList.add(rectangle3);
        }
        return arrayList.toArray(new Rectangle[arrayList.size()]);
    }

    public Rectangle[] getHorizontallySpannedScreens(Rectangle rectangle, double d2) {
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y + (rectangle.height - 1) / 2, rectangle.width, 1);
        return this.getSpannedScreens(rectangle2, d2, 0.0);
    }

    public Rectangle[] getVerticallySpannedScreens(Rectangle rectangle, double d2) {
        Rectangle rectangle2 = new Rectangle(rectangle.x + (rectangle.width - 1) / 2, rectangle.y, 1, rectangle.height);
        return this.getSpannedScreens(rectangle2, 0.0, d2);
    }

    public Dimension getMaximumDimension() {
        Rectangle[] rectangleArray = this.collectScreenBounds();
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
            Dimension dimension = rectangleArray[i2].getSize();
            if (d2 < dimension.getWidth()) {
                d2 = dimension.getWidth();
            }
            if (!(d3 < dimension.getHeight())) continue;
            d3 = dimension.getHeight();
        }
        return new Dimension((int)d2, (int)d3);
    }

    public String toString() {
        Rectangle[] rectangleArray = this.collectScreenBounds();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
            stringBuffer.append("Screen " + i2 + " bounds: " + rectangleArray[i2] + " ");
        }
        return stringBuffer.toString();
    }
}

