/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import GuiUtilities.Util.ScreenElement;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompositeScreen {
    public static final int INSETS_HORIZONTAL = 1;
    public static final int INSETS_VERTICAL = 2;
    public static final int INSETS_ALL = 3;
    private List mScreenElements = new ArrayList(10);

    public CompositeScreen() {
    }

    public CompositeScreen(ScreenElement[] screenElementArray) {
        for (int i2 = 0; i2 < screenElementArray.length; ++i2) {
            this.addScreenElement(screenElementArray[i2]);
        }
    }

    public void addScreenElement(Rectangle rectangle, Insets insets) {
        this.addScreenElement(new ScreenElement(rectangle, insets));
    }

    public void addScreenElement(ScreenElement screenElement) {
        this.mScreenElements.add(screenElement);
    }

    public int getScreenCount() {
        return this.mScreenElements.size();
    }

    public Rectangle getEnclosingBounds() {
        return this.getEnclosingBounds(0);
    }

    public Rectangle getEnclosingBounds(int n2) {
        if (this.getScreenCount() == 0) {
            return new Rectangle();
        }
        Rectangle rectangle = new Rectangle(((ScreenElement)this.mScreenElements.get(0)).getBounds());
        Iterator iterator = this.mScreenElements.iterator();
        while (iterator.hasNext()) {
            rectangle.add(((ScreenElement)iterator.next()).getBounds());
        }
        this.stripInsets(rectangle, n2);
        return rectangle;
    }

    public Rectangle getBounds(int n2) {
        return this.getBounds(n2, 0);
    }

    public Rectangle getBounds(int n2, int n3) {
        Rectangle rectangle = new Rectangle(((ScreenElement)this.mScreenElements.get(n2)).getBounds());
        this.stripInsets(rectangle, n3);
        return rectangle;
    }

    public int getPixelArea() {
        Rectangle rectangle = this.getEnclosingBounds();
        return rectangle.width * rectangle.height;
    }

    private void stripInsets(Rectangle rectangle, int n2) {
        if (n2 == 0) {
            return;
        }
        if ((n2 & 1) > 0) {
            this.stripHorizontalInsets(rectangle);
        }
        if ((n2 & 2) > 0) {
            this.stripVerticalInsets(rectangle);
        }
    }

    private void stripHorizontalInsets(Rectangle rectangle) {
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = this.mScreenElements.iterator();
        while (iterator.hasNext()) {
            ScreenElement screenElement = (ScreenElement)iterator.next();
            Insets insets = screenElement.getInsets();
            if (insets == null) continue;
            n3 = Math.max(n3, insets.top);
            n2 = Math.max(n2, insets.bottom);
        }
        rectangle.y += n3;
        rectangle.height -= n3;
        rectangle.height -= n2;
    }

    private void stripVerticalInsets(Rectangle rectangle) {
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = this.mScreenElements.iterator();
        while (iterator.hasNext()) {
            ScreenElement screenElement = (ScreenElement)iterator.next();
            Insets insets = screenElement.getInsets();
            if (insets == null) continue;
            n2 = Math.max(n2, insets.left);
            n3 = Math.max(n3, insets.right);
        }
        rectangle.x += n2;
        rectangle.width -= n2;
        rectangle.width -= n3;
    }

    public String toString() {
        return "CompositeScreen: composed screen count = [" + this.getScreenCount() + "]" + " bounds = [" + this.getEnclosingBounds() + "]" + " pixel area = [" + this.getPixelArea() + "]";
    }
}

