/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import GuiUtilities.Layouts.GridLayoutPlus;
import GuiUtilities.Util.LabelValuePair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class CheckBoxGroupPanel
extends JPanel {
    private GridLayoutPlus mLayout;
    private Map mCheckboxValueMap;

    public CheckBoxGroupPanel(String[] stringArray) {
        LabelValuePair[] labelValuePairArray = new LabelValuePair[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            labelValuePairArray[i2] = new LabelValuePair(stringArray[i2], stringArray[i2]);
        }
        this.initGui(labelValuePairArray);
    }

    public CheckBoxGroupPanel(LabelValuePair[] labelValuePairArray) {
        this.initGui(labelValuePairArray);
    }

    private void initGui(LabelValuePair[] labelValuePairArray) {
        this.mCheckboxValueMap = new LinkedHashMap();
        JCheckBox jCheckBox = null;
        for (int i2 = 0; i2 < labelValuePairArray.length; ++i2) {
            jCheckBox = new JCheckBox(labelValuePairArray[i2].getLabel());
            this.mCheckboxValueMap.put(jCheckBox, labelValuePairArray[i2]);
            this.add(jCheckBox);
        }
    }

    public List getCheckBoxes() {
        return Collections.unmodifiableList(new ArrayList(this.mCheckboxValueMap.keySet()));
    }

    public List getSelection() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList(this.mCheckboxValueMap.keySet());
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            JCheckBox jCheckBox = (JCheckBox)iterator.next();
            if (!jCheckBox.isSelected()) continue;
            arrayList.add(((LabelValuePair)this.mCheckboxValueMap.get(jCheckBox)).getValue());
        }
        return arrayList;
    }

    public void setGridLayout(GridLayoutPlus gridLayoutPlus) {
        this.mLayout = gridLayoutPlus;
        this.setLayout(this.mLayout);
    }

    public void selectAll(boolean bl2) {
        ArrayList arrayList = new ArrayList(this.mCheckboxValueMap.keySet());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            JCheckBox jCheckBox = (JCheckBox)iterator.next();
            jCheckBox.setSelected(bl2);
        }
    }
}

