/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import GuiUtilities.JCalendar.Calendar.JCalendar;
import GuiUtilities.Util.EnhancedDialog;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class CalendarPicker
extends EnhancedDialog
implements ActionListener {
    private JCalendar mCalendar;
    private JFormattedTextField mDateField;
    private JButton mOkButton;
    private JButton mCancelButton;

    public CalendarPicker(Frame frame, JFormattedTextField jFormattedTextField, Date date) {
        super(frame, "Calendar", true);
        this.mDateField = jFormattedTextField;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.createCalendarPane(jPanel);
        this.createControlPane(jPanel);
        this.setContentPane(jPanel);
        this.setCalendar(date);
        this.pack();
    }

    private void setCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.mCalendar.setCalendar(calendar);
    }

    private void createCalendarPane(JPanel jPanel) {
        this.mCalendar = new JCalendar(2);
        jPanel.add("Center", this.mCalendar);
    }

    public void createControlPane(JPanel jPanel) {
        Box box = new Box(0);
        box.setBorder(new EmptyBorder(8, 8, 8, 8));
        box.add(Box.createGlue());
        this.mOkButton = new JButton("Ok");
        this.mOkButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.mOkButton);
        this.mCancelButton = new JButton("Cancel");
        this.mCancelButton.addActionListener(this);
        box.add(this.mOkButton);
        box.add(Box.createGlue());
        box.add(this.mCancelButton);
        box.add(Box.createGlue());
        jPanel.add("South", box);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mOkButton) {
            this.ok();
        } else {
            this.cancel();
        }
    }

    public void ok() {
        Calendar calendar = this.mCalendar.getCalendar();
        this.mDateField.setValue(calendar.getTime());
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }
}

