/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import GuiUtilities.Util.GuiUtilities;
import GuiUtilities.Util.SearchCriterionDefinition;
import GuiUtilities.Util.ValueField;
import GuiUtilities.Util.ValueFieldFactory;
import java.awt.BorderLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class AttributeOperatorValueGui {
    protected JComboBox mOperatorComboBox;
    private JComponent mOperatorComponent;
    protected ValueFieldFactory mValueFieldFactory;
    protected ValueField mValueField;
    private PropertyChangeSupport mPropertyChangeSupport;

    protected AttributeOperatorValueGui(Object[] objectArray, ValueFieldFactory valueFieldFactory) {
        this.mOperatorComboBox = new JComboBox<Object>(objectArray);
        this.mValueFieldFactory = valueFieldFactory;
        this.mValueField = this.mValueFieldFactory.createValueField(null);
        this.mPropertyChangeSupport = new PropertyChangeSupport(this);
        this.mOperatorComponent = this.mOperatorComboBox.getModel().getSize() == 1 ? new JPanel() : this.mOperatorComboBox;
    }

    public static AttributeOperatorValueGui createInstance(String string, Object[] objectArray, int n2) {
        return new AttributeOperatorValueLabel(string, objectArray, new DefaultValueFieldFactory(n2));
    }

    public static AttributeOperatorValueGui createInstance(Object[] objectArray, Object[] objectArray2, int n2) {
        return new AttributeOperatorValueComboBox(objectArray, objectArray2, new DefaultValueFieldFactory(n2));
    }

    public static AttributeOperatorValueGui createInstance(List list, int n2) {
        return new EnhancedAttributeOperatorValueComboBox(list, (ValueFieldFactory)new DefaultValueFieldFactory(n2));
    }

    public abstract JComponent getAttributeComponent();

    public JComponent getOperatorComponent() {
        return this.mOperatorComponent;
    }

    public JComponent getValueComponent() {
        return this.mValueField.getComponent();
    }

    public abstract Object getAttributeValue();

    public Object getOperatorValue() {
        return this.mOperatorComboBox.getSelectedItem();
    }

    public String getValue() {
        return this.mValueField.getText();
    }

    public void updateGui(Object object, Object object2, String string) {
        this.updateAttribute(object);
        this.mOperatorComboBox.setSelectedItem(object2);
        this.updateValueField();
        this.mValueField.setText(string);
    }

    protected void updateValueField() {
        ValueField valueField = this.mValueField;
        ValueField valueField2 = this.mValueFieldFactory.createValueField(this.getAttributeValue());
        if (valueField.getComponent().getClass() == valueField2.getComponent().getClass()) {
            return;
        }
        this.mValueField = valueField2;
        this.mPropertyChangeSupport.firePropertyChange("valueField", valueField, valueField2);
    }

    protected abstract void updateAttribute(Object var1);

    public void setEnabled(boolean bl2) {
        this.getAttributeComponent().setEnabled(bl2);
        this.mOperatorComboBox.setEnabled(bl2);
        this.mValueField.setEnabled(bl2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.mPropertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.mPropertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Attribute Operator Value Tester");
        jFrame.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        Object[] objectArray = new String[]{"Contains", "Starts with", "Equals"};
        AttributeOperatorValueGui attributeOperatorValueGui = AttributeOperatorValueGui.createInstance("Attribute", objectArray, 15);
        jPanel.add(attributeOperatorValueGui.getAttributeComponent());
        jPanel.add(attributeOperatorValueGui.getOperatorComponent());
        jPanel.add(attributeOperatorValueGui.getValueComponent());
        Object[] objectArray2 = new String[]{"Study Descriptions", "Series Name", "User Name", "Dog's Name"};
        AttributeOperatorValueGui attributeOperatorValueGui2 = AttributeOperatorValueGui.createInstance(objectArray2, objectArray, 15);
        jPanel2.add(attributeOperatorValueGui2.getAttributeComponent());
        jPanel2.add(attributeOperatorValueGui2.getOperatorComponent());
        jPanel2.add(attributeOperatorValueGui2.getValueComponent());
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add("North", jPanel);
        jFrame.getContentPane().add("South", jPanel2);
        jFrame.pack();
        GuiUtilities.centerWindow(jFrame);
        jFrame.show();
    }

    public static class EnhancedAttributeOperatorValueComboBox
    extends AttributeOperatorValueComboBox {
        private final List mCriterionDefinitions;

        public EnhancedAttributeOperatorValueComboBox(List list, ValueFieldFactory valueFieldFactory) {
            super(EnhancedAttributeOperatorValueComboBox.createAttributeNameArray(list), ((SearchCriterionDefinition)list.get(0)).getOperatorList(), valueFieldFactory);
            this.mCriterionDefinitions = Collections.unmodifiableList(new ArrayList(list));
            this.mAttributeComboBox.addItemListener(new ItemListener(this){
                private final /* synthetic */ EnhancedAttributeOperatorValueComboBox this$0;
                {
                    this.this$0 = enhancedAttributeOperatorValueComboBox;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    EnhancedAttributeOperatorValueComboBox.access$000(this.this$0);
                }
            });
        }

        public Object getAttributeValue() {
            return this.getCriterionFromObject().getAttribute();
        }

        private static Object[] createAttributeNameArray(List list) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SearchCriterionDefinition searchCriterionDefinition = (SearchCriterionDefinition)iterator.next();
                arrayList.add(searchCriterionDefinition.getAttributeLabel());
            }
            return arrayList.toArray();
        }

        private void setAttributeName() {
            SearchCriterionDefinition searchCriterionDefinition = this.getCriterionFromObject();
            if (searchCriterionDefinition == null) {
                throw new IllegalStateException("Couldn't set attribute name: " + searchCriterionDefinition.getAttributeLabel());
            }
            this.mOperatorComboBox.setModel(new DefaultComboBoxModel<Object>(searchCriterionDefinition.getOperatorList()));
        }

        protected void updateAttribute(Object object) {
            for (int i2 = 0; i2 < this.mCriterionDefinitions.size(); ++i2) {
                Object object2 = ((SearchCriterionDefinition)this.mCriterionDefinitions.get(i2)).getAttribute();
                if (!object2.equals(object)) continue;
                this.mAttributeComboBox.setSelectedIndex(i2);
            }
        }

        private SearchCriterionDefinition getCriterionFromObject() {
            return (SearchCriterionDefinition)this.mCriterionDefinitions.get(this.mAttributeComboBox.getSelectedIndex());
        }

        static /* synthetic */ void access$000(EnhancedAttributeOperatorValueComboBox enhancedAttributeOperatorValueComboBox) {
            enhancedAttributeOperatorValueComboBox.setAttributeName();
        }
    }

    private static class AttributeOperatorValueComboBox
    extends AttributeOperatorValueGui {
        protected JComboBox mAttributeComboBox;

        public AttributeOperatorValueComboBox(Object[] objectArray, Object[] objectArray2, ValueFieldFactory valueFieldFactory) {
            super(objectArray2, valueFieldFactory);
            this.mAttributeComboBox = new JComboBox<Object>(objectArray);
        }

        public JComponent getAttributeComponent() {
            return this.mAttributeComboBox;
        }

        public Object getAttributeValue() {
            return this.mAttributeComboBox.getSelectedItem();
        }

        protected void updateAttribute(Object object) {
            this.mAttributeComboBox.setSelectedItem(object);
        }
    }

    private static class AttributeOperatorValueLabel
    extends AttributeOperatorValueGui {
        private JLabel mAttributeLabel;

        public AttributeOperatorValueLabel(String string, Object[] objectArray, ValueFieldFactory valueFieldFactory) {
            super(objectArray, valueFieldFactory);
            this.mAttributeLabel = new JLabel(string);
        }

        public JComponent getAttributeComponent() {
            return this.mAttributeLabel;
        }

        public Object getAttributeValue() {
            return this.mAttributeLabel.getText();
        }

        protected void updateAttribute(Object object) {
            this.mAttributeLabel.setText((String)object);
        }
    }

    public static class SimpleTextValueField
    implements ValueField {
        private JTextField mTextField;

        public SimpleTextValueField(int n2) {
            this.mTextField = new JTextField(n2);
        }

        public JComponent getComponent() {
            return this.mTextField;
        }

        public String getText() {
            return this.mTextField.getText();
        }

        public void setText(String string) {
            this.mTextField.setText(string);
        }

        public void setEnabled(boolean bl2) {
            this.mTextField.setEnabled(bl2);
        }
    }

    public static class DefaultValueFieldFactory
    implements ValueFieldFactory {
        private int mValueColumns;

        public DefaultValueFieldFactory(int n2) {
            this.mValueColumns = n2;
        }

        public ValueField createValueField(Object object) {
            return new SimpleTextValueField(this.mValueColumns);
        }
    }
}

