/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public class InfoPanelBuilder {
    public static final TextComponentFactory DEFAULT_TEXT_AREA_FACTORY = new TextAreaFactory(false);
    private static final Insets COMPONENT_INSETS = new Insets(2, 4, 2, 0);
    private static final Border EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
    private final JPanel mPanel;
    private final Insets mInsets;
    private int mGridY = 0;

    public InfoPanelBuilder(JPanel jPanel, Insets insets) {
        this.mPanel = jPanel;
        this.mInsets = insets;
        jPanel.setLayout(new GridBagLayout());
    }

    public InfoPanelBuilder(JPanel jPanel) {
        this(jPanel, COMPONENT_INSETS);
    }

    public void addSeparator(JLabel jLabel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.mGridY++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.mPanel.add((Component)this.getLabeledSeparator(jLabel), gridBagConstraints);
    }

    private JPanel getLabeledSeparator(JLabel jLabel) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = this.mInsets;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)new JSeparator(0), gridBagConstraints);
        return jPanel;
    }

    public void addLine(String string, Object object) {
        this.addLabel(string, false);
        this.addValue(object);
    }

    public void addLabel(String string, boolean bl2) {
        JLabel jLabel = new JLabel(string + ":");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.mGridY;
        gridBagConstraints.anchor = bl2 ? 18 : 12;
        gridBagConstraints.insets = this.mInsets;
        this.mPanel.add((Component)jLabel, gridBagConstraints);
    }

    public void addValue(Object object) {
        this.addValue(object, DEFAULT_TEXT_AREA_FACTORY, false);
    }

    public void addValue(Object object, TextComponentFactory textComponentFactory, boolean bl2) {
        JComponent jComponent = textComponentFactory.createComponent(object);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = bl2 ? 0 : 1;
        int n2 = gridBagConstraints.gridwidth = bl2 ? 2 : 1;
        if (bl2) {
            ++this.mGridY;
        }
        gridBagConstraints.gridy = this.mGridY++;
        gridBagConstraints.weightx = 1.0;
        double d2 = jComponent instanceof JScrollPane ? jComponent.getPreferredSize().getHeight() / 15.0 : 0.0;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = this.mInsets;
        this.mPanel.add((Component)jComponent, gridBagConstraints);
    }

    public void addFiller() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.mGridY++;
        gridBagConstraints.weighty = 1.0;
        this.mPanel.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    public static JTextComponent createTextArea(Object object, boolean bl2) {
        JTextArea jTextArea = new JTextArea(InfoPanelBuilder.valueToText(object));
        jTextArea.setWrapStyleWord(bl2);
        jTextArea.setLineWrap(true);
        jTextArea.setForeground(Color.BLUE);
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setBorder(EMPTY_BORDER);
        return jTextArea;
    }

    public static String valueToText(Object object) {
        return object == null ? "" : object.toString();
    }

    public static final class TextAreaFactory
    implements TextComponentFactory {
        private final boolean mWrapWords;

        public TextAreaFactory(boolean bl2) {
            this.mWrapWords = bl2;
        }

        public JComponent createComponent(Object object) {
            return InfoPanelBuilder.createTextArea(object, this.mWrapWords);
        }
    }

    public static interface TextComponentFactory {
        public JComponent createComponent(Object var1);
    }
}

