/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Panel;

import DataModels.DataModel;
import DataModels.ModelProperty;
import GuiUtilities.Panel.InfoPanelBuilder;
import java.awt.Color;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DataModelInfoPanel
extends JPanel {
    private final DataModel mModel;
    private final Collection mProperties;
    private final Collection mMultilineProperties;
    private final PropertyEvaluator mPropertyEvaluator;

    public DataModelInfoPanel(DataModel dataModel, Collection collection, Collection collection2, PropertyEvaluator propertyEvaluator) {
        this.mModel = dataModel;
        this.mProperties = collection;
        this.mMultilineProperties = collection2;
        this.mPropertyEvaluator = propertyEvaluator;
        this.initGui();
    }

    private void initGui() {
        InfoPanelBuilder infoPanelBuilder = new InfoPanelBuilder(this, new Insets(2, 4, 10, 0));
        Iterator iterator = this.mProperties.iterator();
        while (iterator.hasNext()) {
            ModelProperty modelProperty = (ModelProperty)iterator.next();
            Object object = this.mPropertyEvaluator.getValue(this.mModel, modelProperty);
            final String string = InfoPanelBuilder.valueToText(object);
            final boolean bl2 = this.mMultilineProperties.contains(modelProperty) && string.length() > 0;
            infoPanelBuilder.addLabel(modelProperty.getDescription(), true);
            InfoPanelBuilder.TextComponentFactory textComponentFactory = new InfoPanelBuilder.TextComponentFactory(){

                public JComponent createComponent(Object object) {
                    if (bl2) {
                        JEditorPane jEditorPane = new JEditorPane("text/html", string);
                        jEditorPane.setEditable(false);
                        jEditorPane.setBackground(Color.LIGHT_GRAY);
                        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
                        jScrollPane.setMinimumSize(jEditorPane.getPreferredSize());
                        jScrollPane.setPreferredSize(jEditorPane.getPreferredSize());
                        return jScrollPane;
                    }
                    return InfoPanelBuilder.createTextArea(string, true);
                }
            };
            infoPanelBuilder.addValue(object, textComponentFactory, bl2);
        }
        infoPanelBuilder.addFiller();
    }

    public static class DefaultPropertyEvaluator
    implements PropertyEvaluator {
        public Object getValue(DataModel dataModel, ModelProperty modelProperty) {
            return dataModel.getProperty(modelProperty);
        }
    }

    public static interface PropertyEvaluator {
        public Object getValue(DataModel var1, ModelProperty var2);
    }
}

