/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Layouts;

import GuiUtilities.Layouts.ConstraintLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class ParagraphLayout
extends ConstraintLayout {
    public static final int TYPE_MASK = 3;
    public static final int STRETCH_H_MASK = 4;
    public static final int STRETCH_V_MASK = 8;
    public static final int NEW_PARAGRAPH_VALUE = 1;
    public static final int NEW_PARAGRAPH_TOP_VALUE = 2;
    public static final int NEW_LINE_VALUE = 3;
    public static final Integer NEW_PARAGRAPH = new Integer(1);
    public static final Integer NEW_PARAGRAPH_TOP = new Integer(2);
    public static final Integer NEW_LINE = new Integer(3);
    public static final Integer STRETCH_H = new Integer(4);
    public static final Integer STRETCH_V = new Integer(8);
    public static final Integer STRETCH_HV = new Integer(12);
    public static final Integer NEW_LINE_STRETCH_H = new Integer(7);
    public static final Integer NEW_LINE_STRETCH_V = new Integer(11);
    public static final Integer NEW_LINE_STRETCH_HV = new Integer(15);
    protected int hGapMajor;
    protected int vGapMajor;
    protected int hGapMinor;
    protected int vGapMinor;
    protected int rows;
    protected int colWidth1;
    protected int colWidth2;

    public ParagraphLayout() {
        this(10, 10, 12, 11, 4, 4);
    }

    public ParagraphLayout(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.hMargin = n2;
        this.vMargin = n3;
        this.hGapMajor = n4;
        this.vGapMajor = n5;
        this.hGapMinor = n6;
        this.vGapMinor = n7;
    }

    public void measureLayout(Container container, Dimension dimension, int n2) {
        int n3 = container.getComponentCount();
        if (n3 > 0) {
            int n4;
            int n5;
            Insets insets = container.getInsets();
            Dimension dimension2 = container.getSize();
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            boolean bl2 = false;
            Dimension[] dimensionArray = new Dimension[n3];
            for (n5 = 0; n5 < n3; ++n5) {
                Component component = container.getComponent(n5);
                if (!this.includeComponent(component)) continue;
                Dimension dimension3 = this.getComponentSize(component, n2);
                int n9 = dimension3.width;
                n4 = dimension3.height;
                dimensionArray[n5] = dimension3;
                Integer n10 = (Integer)this.getConstraint(component);
                if (n5 == 0 || n10 == NEW_PARAGRAPH || n10 == NEW_PARAGRAPH_TOP) {
                    if (n5 != 0) {
                        n6 += n7 + this.vGapMajor;
                    }
                    this.colWidth1 = Math.max(this.colWidth1, n9);
                    n8 = 0;
                    n7 = 0;
                    bl2 = true;
                } else if (n10 == NEW_LINE || bl2) {
                    if (!bl2 && n5 != 0) {
                        n6 += n7 + this.vGapMinor;
                    }
                    n8 = n9;
                    this.colWidth2 = Math.max(this.colWidth2, n8);
                    if (!bl2) {
                        n7 = 0;
                    }
                    bl2 = false;
                } else {
                    this.colWidth2 = Math.max(this.colWidth2, n8 += n9 + this.hGapMinor);
                    bl2 = false;
                }
                n7 = Math.max(n4, n7);
            }
            if (dimension != null) {
                dimension.width = this.colWidth1 + this.hGapMajor + this.colWidth2;
                dimension.height = n6 + n7;
            } else {
                n5 = dimension2.height - (n6 + n7) - insets.top - insets.bottom - 2 * this.vMargin;
                n6 = 0;
                bl2 = false;
                int n11 = 0;
                int n12 = 0;
                Integer n13 = NEW_PARAGRAPH;
                n4 = 0;
                boolean bl3 = true;
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n14;
                    Component component = container.getComponent(i2);
                    if (!this.includeComponent(component)) continue;
                    Dimension dimension4 = dimensionArray[i2];
                    int n15 = dimension4.height;
                    Integer n16 = (Integer)this.getConstraint(component);
                    int n17 = n14 = n16 != null ? n16 : 0;
                    if (i2 == 0 || n16 == NEW_PARAGRAPH || n16 == NEW_PARAGRAPH_TOP) {
                        if (i2 != 0) {
                            this.layoutRow(container, dimensionArray, n11, i2 - 1, n6, n12, n7, bl3, n2, n13);
                        }
                        n4 = 0;
                        n13 = n16;
                        n11 = i2;
                        bl3 = true;
                        if (i2 != 0) {
                            n6 += n7 + this.vGapMajor;
                        }
                        n7 = 0;
                        n12 = this.colWidth1 + this.hGapMajor - this.hGapMinor;
                        bl2 = true;
                    } else if (n16 == NEW_LINE || bl2) {
                        if (!bl2) {
                            this.layoutRow(container, dimensionArray, n11, n3 - 1, n6, n12, n7, bl3, n2, n13);
                            n4 = 0;
                            n11 = i2;
                            bl3 = false;
                            n6 += n7 + this.vGapMinor;
                            n7 = 0;
                        }
                        n12 += dimensionArray[i2].width + this.hGapMinor;
                        bl2 = false;
                    } else {
                        n12 += dimensionArray[i2].width + this.hGapMinor;
                        bl2 = false;
                    }
                    if ((n14 & 8) != 0 && n4 == 0) {
                        n4 = 1;
                        n15 += n5;
                    }
                    n7 = Math.max(n15, n7);
                }
                this.layoutRow(container, dimensionArray, n11, n3 - 1, n6, n12, n7, bl3, n2, n13);
            }
        }
    }

    protected void layoutRow(Container container, Dimension[] dimensionArray, int n2, int n3, int n4, int n5, int n6, boolean bl2, int n7, Integer n8) {
        int n9 = 0;
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n10 = dimension.width - n5 - insets.left - insets.right - 2 * this.hMargin;
        for (int i2 = n2; i2 <= n3; ++i2) {
            Dimension dimension2;
            Dimension dimension3;
            Component component = container.getComponent(i2);
            if (!this.includeComponent(component)) continue;
            Integer n11 = (Integer)this.getConstraint(component);
            int n12 = n11 != null ? n11 : 0;
            Dimension dimension4 = dimensionArray[i2];
            int n13 = dimension4.width;
            int n14 = dimension4.height;
            if ((n12 & 4) != 0) {
                n13 += n10;
                dimension3 = this.getComponentSize(component, 2);
                dimension2 = this.getComponentSize(component, 1);
                n13 = Math.max(dimension2.width, Math.min(dimension3.width, n13));
            }
            if ((n12 & 8) != 0) {
                n14 = n6;
                dimension3 = this.getComponentSize(component, 2);
                dimension2 = this.getComponentSize(component, 1);
                n14 = Math.max(dimension2.height, Math.min(dimension3.height, n14));
            }
            if (i2 == n2) {
                n9 = bl2 ? this.colWidth1 - n13 : this.colWidth1 + this.hGapMajor;
            } else if (bl2 && i2 == n2 + 1) {
                n9 = this.colWidth1 + this.hGapMajor;
            }
            int n15 = n8 == NEW_PARAGRAPH_TOP ? 0 : (n6 - n14) / 2;
            component.setBounds(insets.left + this.hMargin + n9, insets.top + this.vMargin + n4 + n15, n13, n14);
            n9 += n13 + this.hGapMinor;
        }
    }
}

