/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.JCalendar.Calendar;

import GuiUtilities.JCalendar.Calendar.JDayChooser;
import GuiUtilities.JCalendar.Calendar.JMonthChooser;
import GuiUtilities.JCalendar.Calendar.JYearChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JCalendar
extends JPanel
implements PropertyChangeListener {
    protected JYearChooser yearChooser = null;
    protected JMonthChooser monthChooser = null;
    protected JDayChooser dayChooser = null;
    private Calendar calendar;
    private Locale locale = Locale.getDefault();
    private boolean initialized = false;

    public JCalendar() {
        this(0);
    }

    public JCalendar(int n2) {
        this.calendar = Calendar.getInstance();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3));
        this.monthChooser = new JMonthChooser(n2);
        this.yearChooser = new JYearChooser();
        this.monthChooser.setYearChooser(this.yearChooser);
        jPanel.add(this.monthChooser);
        jPanel.add(this.yearChooser);
        this.dayChooser = new JDayChooser();
        this.dayChooser.addPropertyChangeListener(this);
        this.monthChooser.setDayChooser(this.dayChooser);
        this.monthChooser.addPropertyChangeListener(this);
        this.yearChooser.setDayChooser(this.dayChooser);
        this.yearChooser.addPropertyChangeListener(this);
        this.add((Component)jPanel, "North");
        this.add((Component)this.dayChooser, "Center");
        this.initialized = true;
    }

    private void setCalendar(Calendar calendar, boolean bl2) {
        Calendar calendar2 = this.calendar;
        this.calendar = calendar;
        if (bl2) {
            this.yearChooser.setYear(calendar.get(1));
            this.monthChooser.setMonth(calendar.get(2));
            this.dayChooser.setDay(calendar.get(5));
        }
        this.firePropertyChange("calendar", calendar2, this.calendar);
    }

    public void setCalendar(Calendar calendar) {
        this.setCalendar(calendar, true);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setLocale(Locale locale) {
        if (!this.initialized) {
            super.setLocale(locale);
        } else {
            Locale locale2 = this.locale;
            this.locale = locale;
            this.dayChooser.setLocale(this.locale);
            this.monthChooser.setLocale(this.locale);
            this.firePropertyChange("locale", locale2, this.locale);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.dayChooser != null) {
            this.dayChooser.setFont(font);
            this.monthChooser.setFont(font);
            this.yearChooser.setFont(font);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.dayChooser != null) {
            this.dayChooser.setForeground(color);
            this.monthChooser.setForeground(color);
            this.yearChooser.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.dayChooser != null) {
            this.dayChooser.setBackground(color);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.calendar != null) {
            Calendar calendar = (Calendar)this.calendar.clone();
            if (propertyChangeEvent.getPropertyName().equals("day")) {
                calendar.set(5, (Integer)propertyChangeEvent.getNewValue());
                this.setCalendar(calendar, false);
            } else if (propertyChangeEvent.getPropertyName().equals("month")) {
                calendar.set(2, (Integer)propertyChangeEvent.getNewValue());
                this.setCalendar(calendar, false);
            } else if (propertyChangeEvent.getPropertyName().equals("year")) {
                calendar.set(1, (Integer)propertyChangeEvent.getNewValue());
                this.setCalendar(calendar, false);
            }
        }
    }

    public String getName() {
        return "JCalendar";
    }

    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        if (this.dayChooser != null) {
            this.dayChooser.setEnabled(bl2);
            this.monthChooser.setEnabled(bl2);
            this.yearChooser.setEnabled(bl2);
        }
    }

    public JDayChooser getDayChooser() {
        return this.dayChooser;
    }

    public JMonthChooser getMonthChooser() {
        return this.monthChooser;
    }

    public JYearChooser getYearChooser() {
        return this.yearChooser;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JCalendar");
        jFrame.getContentPane().add(new JCalendar());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

