/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Event;

import DataStructures.WorkQueue;
import GuiUtilities.Event.EventListener;
import GuiUtilities.Event.EventQueueUtilities;
import GuiUtilities.Event.ExceptionHandler;
import RuntimeTool.DebugManager;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class EventDispatcher {
    private static boolean mDispatching = false;
    private static WorkQueue mWorkQueue = new WorkQueue();
    private Map mEventListenerMap = new HashMap();
    private ExceptionHandler mExceptionHandler = null;

    private static void dispatchAllEvents() {
        Runnable runnable = new Runnable(){

            public void run() {
                EventDispatcher.dispatchAllEventsInEventThread();
            }
        };
        EventQueueUtilities.invokeNowOrLater(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dispatchAllEventsInEventThread() {
        if (mDispatching) {
            return;
        }
        mDispatching = true;
        try {
            while (!mWorkQueue.isEmpty()) {
                WorkEntry workEntry = (WorkEntry)mWorkQueue.getWork();
                workEntry.getDispatcher().dispatchEvent(workEntry.getEvent(), workEntry.getStackTrace());
            }
        }
        finally {
            mDispatching = false;
        }
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.mExceptionHandler = exceptionHandler;
    }

    private void checkEventType(Class clazz) {
        if (!EventObject.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Invalid event type: " + clazz);
        }
    }

    public synchronized void addListener(Class clazz, EventListener eventListener) {
        this.checkEventType(clazz);
        Map map = this.getListenerMap(clazz);
        map.put(eventListener, null);
    }

    public synchronized void removeListener(Class clazz, EventListener eventListener) {
        this.checkEventType(clazz);
        if (eventListener == null) {
            return;
        }
        Map map = this.getListenerMap(clazz);
        map.remove(eventListener);
    }

    synchronized Set getListenerSet(Class clazz) {
        return this.getListenerMap(clazz).keySet();
    }

    private synchronized Map getListenerMap(Class clazz) {
        WeakHashMap weakHashMap = (WeakHashMap)this.mEventListenerMap.get(clazz);
        if (weakHashMap == null) {
            weakHashMap = new WeakHashMap();
            this.mEventListenerMap.put(clazz, weakHashMap);
        }
        return weakHashMap;
    }

    synchronized Set getFullListenerSet(Class clazz) {
        LinkedHashSet linkedHashSet = new LinkedHashSet(this.getListenerSet(clazz));
        for (clazz = clazz.getSuperclass(); clazz != null && (class$java$util$EventObject == null ? EventDispatcher.class$("java.util.EventObject") : class$java$util$EventObject).isAssignableFrom(clazz); clazz = clazz.getSuperclass()) {
            linkedHashSet.addAll(this.getListenerSet(clazz));
        }
        return linkedHashSet;
    }

    public void fireEvent(EventObject eventObject) {
        mWorkQueue.addWork(new WorkEntry(this, eventObject, new Exception()));
        EventDispatcher.dispatchAllEvents();
    }

    private void dispatchEvent(EventObject eventObject, Exception exception) {
        Set set = this.getFullListenerSet(eventObject.getClass());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            EventListener eventListener = (EventListener)iterator.next();
            try {
                if (eventListener == null) continue;
                eventListener.eventReceived(eventObject);
            }
            catch (Throwable throwable) {
                String string = "Error in event listener " + eventListener;
                if (this.mExceptionHandler == null) {
                    DebugManager.getDefault().printException(string, throwable);
                    DebugManager.getDefault().printException("Event fired with the following stack trace:", exception);
                    continue;
                }
                this.mExceptionHandler.handleException(eventObject, string, throwable, exception);
            }
        }
    }

    private static class WorkEntry {
        private final EventDispatcher mDispatcher;
        private final EventObject mEvent;
        private final Exception mStackTrace;

        private WorkEntry(EventDispatcher eventDispatcher, EventObject eventObject, Exception exception) {
            this.mDispatcher = eventDispatcher;
            this.mEvent = eventObject;
            this.mStackTrace = exception;
        }

        private EventDispatcher getDispatcher() {
            return this.mDispatcher;
        }

        private EventObject getEvent() {
            return this.mEvent;
        }

        private Exception getStackTrace() {
            return this.mStackTrace;
        }
    }
}

