/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Dialog;

import GuiUtilities.Dialog.ValueValidator;
import GuiUtilities.Layouts.GridBagBuilder;
import GuiUtilities.Util.EnhancedDialog;
import GuiUtilities.Util.GuiUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ValidatingInputDialog
extends EnhancedDialog {
    private final JTextField mTextField;
    private final JButton mOkButton;
    private final JButton mCancelButton;
    private final ValueValidator mValueValidator;
    private final JLabel mWarningLabel;
    private boolean mIsCancelled;
    private final Dialog mParent;

    public ValidatingInputDialog(Dialog dialog, boolean bl2, String string, String string2, String string3, String string4, Icon icon, ValueValidator valueValidator) {
        super(dialog, string, bl2);
        this.mParent = dialog;
        this.mValueValidator = valueValidator;
        this.getContentPane().setLayout(new BorderLayout());
        this.mWarningLabel = new JLabel();
        this.mWarningLabel.setVisible(false);
        this.mWarningLabel.setMinimumSize(this.mWarningLabel.getPreferredSize());
        if (icon != null) {
            this.mWarningLabel.setIcon(icon);
        }
        this.mOkButton = new JButton(string3);
        this.mOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidatingInputDialog.this.ok();
            }
        });
        this.mCancelButton = new JButton("Cancel");
        this.mCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidatingInputDialog.this.cancel();
            }
        });
        this.mTextField = new JTextField();
        this.mTextField.setColumns(15);
        this.setInitialValue(string4);
        this.mTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                ValidatingInputDialog.this.validateValue(ValidatingInputDialog.this.mTextField.getText());
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ValidatingInputDialog.this.validateValue(ValidatingInputDialog.this.mTextField.getText());
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                ValidatingInputDialog.this.validateValue(ValidatingInputDialog.this.mTextField.getText());
            }
        });
        this.getContentPane().add(this.createCenterPanel(string2), "Center");
        this.getContentPane().add(this.createBottomPanel(), "South");
        if (string4 != null) {
            this.validateValue(string4);
        }
    }

    public void setInitialValue(String string) {
        this.mTextField.setText(string);
    }

    public String askValue() {
        this.show();
        if (this.isCancelled()) {
            return null;
        }
        return this.getValue();
    }

    public void show() {
        GuiUtilities.centerWindowOnParent(this.mParent, this);
        this.mIsCancelled = false;
        super.show();
    }

    public boolean isCancelled() {
        if (this.isShowing()) {
            throw new IllegalStateException("Only use isCancelled() once the dialog was disposed.");
        }
        return this.mIsCancelled;
    }

    public void cancel() {
        this.mIsCancelled = true;
        this.dispose();
    }

    public void ok() {
        if (this.isValueValid(this.getValue())) {
            this.mIsCancelled = false;
            this.dispose();
        }
    }

    public String getValue() {
        return this.mTextField.getText();
    }

    private boolean isValueValid(String string) {
        String string2 = this.mValueValidator.validateValue(string);
        boolean bl2 = string2 == null || string2.equals("");
        return bl2;
    }

    private void validateValue(String string) {
        String string2 = this.mValueValidator.validateValue(string);
        boolean bl2 = this.isValueValid(string);
        this.mWarningLabel.setText(string2);
        this.mWarningLabel.setVisible(!bl2);
        this.mOkButton.setEnabled(bl2);
        this.mTextField.setForeground(bl2 ? Color.black : Color.red);
    }

    private Component createCenterPanel(String string) {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalTextPosition(4);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagBuilder().setLocation(0, 0).setAnchor(13).setFill(2, 0.2, 0.0).setInsets(10, 15, 10, 0).setSize(1, 1).getConstraints());
        jPanel.add((Component)this.mTextField, new GridBagBuilder().setLocation(1, 0).setAnchor(17).setFill(2, 1.0, 0.0).setInsets(10, 2, 10, 15).setSize(1, 1).getConstraints());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 1));
        jPanel2.add(this.mWarningLabel);
        jPanel.add((Component)jPanel2, new GridBagBuilder().setLocation(1, 1).setAnchor(11).setFill(2, 1.0, 0.0).setInsets(0, 0, 0, 0).setSize(1, 1).getConstraints());
        return jPanel;
    }

    private Component createBottomPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.mOkButton);
        jPanel.add(this.mCancelButton);
        return jPanel;
    }
}

