/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Dialog;

import GuiUtilities.Dialog.ProgressDialog;
import GuiUtilities.Dialog.ProgressMeter;
import GuiUtilities.Worker.WorkerController;
import java.awt.Window;
import javax.swing.ImageIcon;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressMeterDialog
extends ProgressDialog
implements ProgressMeter {
    private JProgressBar mProgressBar;
    private WorkerController mController;
    private boolean isCancelled;
    private String mActionMessage;

    public ProgressMeterDialog(Window window, ImageIcon imageIcon, String string) {
        super(window, imageIcon, string);
    }

    protected JProgressBar createProgressBar(String string) {
        this.mActionMessage = string;
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setEnabled(true);
        jProgressBar.setStringPainted(true);
        jProgressBar.setIndeterminate(false);
        jProgressBar.setBorderPainted(true);
        jProgressBar.setMaximum(100);
        jProgressBar.setMinimum(0);
        jProgressBar.setString(this.getProgressString(0));
        jProgressBar.setValue(0);
        this.mProgressBar = jProgressBar;
        return jProgressBar;
    }

    protected String getProgressString(int n2) {
        return this.mActionMessage + " (" + n2 + "%)";
    }

    public void setCancellable(WorkerController workerController) {
        this.mController = workerController;
        if (this.isCancelled) {
            this.mController.cancel();
        }
    }

    protected void cancel() {
        this.isCancelled = true;
        if (this.mController != null) {
            this.mController.cancel();
        }
    }

    public void advanceMeter(final double d2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n2 = (int)(d2 * 100.0);
                ProgressMeterDialog.this.mProgressBar.setValue(n2);
                ProgressMeterDialog.this.mProgressBar.setString(ProgressMeterDialog.this.getProgressString(n2));
            }
        });
    }
}

