/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.DataModels;

import DataModels.DataModel;
import DataModels.ModelProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractSpinnerModel;

class ModelPropertySpinnerModel
extends AbstractSpinnerModel {
    private final DataModel mDataModel;
    private final ModelProperty mProperty;
    private final PropertyChangeListener mListener;
    private final long mFirst;
    private final long mLast;
    private long mCurrentValue;
    private static final Collection mAcceptedPropertyTypes = Arrays.asList(Integer.class, Long.class, String.class);

    ModelPropertySpinnerModel(DataModel dataModel, ModelProperty modelProperty, long l2, long l3) {
        if (!mAcceptedPropertyTypes.contains(modelProperty.getValueClass())) {
            throw new IllegalArgumentException("Invalid property type: " + modelProperty.getValueClass() + " " + modelProperty);
        }
        this.mDataModel = dataModel;
        this.mProperty = modelProperty;
        this.mFirst = l2;
        this.mLast = l3;
        this.mListener = new DataModelListener();
        this.mDataModel.addWeakPropertyChangeListener(modelProperty, this.mListener);
        this.updateSpinnerFromModelProperty();
    }

    public Object getNextValue() {
        return new Long(Math.min(this.mCurrentValue + 1L, this.mLast));
    }

    public Object getPreviousValue() {
        return new Long(Math.max(this.mFirst, this.mCurrentValue - 1L));
    }

    public Object getValue() {
        return new Long(this.mCurrentValue);
    }

    public void setValue(Object object) {
        this.validateValue(object);
        this.mCurrentValue = (Long)object;
        this.updateDataModel();
    }

    boolean sameValueAsDataModel() {
        Long l2 = this.convertToSpinnerValue(this.mDataModel.getProperty(this.mProperty));
        return l2 != null && l2 == this.mCurrentValue;
    }

    private void validateValue(Object object) {
        if (!(object instanceof Long)) {
            throw new IllegalArgumentException("Value is not a Long, but a " + object.getClass());
        }
        long l2 = (Long)object;
        if (this.isOutOfRange(l2)) {
            throw new IllegalArgumentException("Value " + l2 + " is out of the range [" + this.mFirst + ", " + this.mLast + "]");
        }
    }

    private boolean isOutOfRange(long l2) {
        return l2 < this.mFirst || l2 > this.mLast;
    }

    private void updateSpinnerFromModelProperty() {
        Long l2 = this.convertToSpinnerValue(this.mDataModel.getProperty(this.mProperty));
        if (l2 != null) {
            this.mCurrentValue = l2;
            this.fireStateChanged();
        }
    }

    void updateDataModel() {
        this.mDataModel.setProperty(this.mProperty, this.convertToModelPropertyValue(this.mCurrentValue));
    }

    private Long convertToSpinnerValue(Object object) {
        if (object == null) {
            return null;
        }
        if (Number.class.isAssignableFrom(object.getClass())) {
            return new Long(((Number)object).longValue());
        }
        if (object instanceof String) {
            try {
                return new Long(Long.parseLong((String)object));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        throw new IllegalArgumentException("Cannot convert values of type " + object.getClass());
    }

    private Object convertToModelPropertyValue(long l2) {
        if (this.mProperty.getValueClass() == Long.class) {
            return new Long(l2);
        }
        if (this.mProperty.getValueClass() == String.class) {
            return Long.toString(l2);
        }
        if (this.mProperty.getValueClass() == Integer.class) {
            if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Value out of range for an integer: " + l2);
            }
            return new Integer((int)l2);
        }
        throw new IllegalArgumentException("Cannot convert value to type " + this.mProperty.getValueClass());
    }

    private final class DataModelListener
    implements PropertyChangeListener {
        private DataModelListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ModelPropertySpinnerModel.this.updateSpinnerFromModelProperty();
        }
    }
}

